# -*- python -*-

# Copyright (C) 1998,1999,2000 by the Free Software Foundation, Inc.
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software 
# Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

"""Distributed default settings for significant Mailman config variables.
"""

# NEVER make site configuration changes to this file.  ALWAYS make them in
# mm_cfg.py instead, in the designated area.  See the comments in that file
# for details.


import os

def seconds(s): return s
def minutes(m): return m * 60
def hours(h): return h * 60 * 60
def days(d): return d * 60 * 60 * 24



#####
# General system-wide defaults
#####

# Should image logos be used?  Set this to false to disable image logos from
# "our sponsors" and just use textual links instead.  Otherwise, this should
# contain the URL base path to the logo images (and must contain the trailing
# slash)..  If you want to disable Mailman's logo footer altogther, hack
# Mailman/htmlformat.py:MailmanLogo(), which also contains the hardcoded links
# and image names.
IMAGE_LOGOS = '/icons/'

# Don't change MAILMAN_URL, unless you want to point it at the list.org
# mirror.
MAILMAN_URL = 'http://www.gnu.org/software/mailman/mailman.html'
#MAILMAN_URL = 'http://www.list.org/'

# Site-specific settings
DEFAULT_HOST_NAME   = 'powerusersbbs.net'
# DEFAULT_URL must end in a slash!
DEFAULT_URL         = 'http://powerusersbbs.net/mailman/'
# PUBLIC_ARCHIVE_URL and PRIVATE_ARCHIVE_URL should not end in slashes!
PUBLIC_ARCHIVE_URL  = '/pipermail'
PRIVATE_ARCHIVE_URL = '/mailman/private'

HOME_PAGE         = 'index.html'
MAILMAN_OWNER     = 'mailman-owner@%s' % DEFAULT_HOST_NAME



#####
# Archive defaults
#####

# Are archives on or off by default?
DEFAULT_ARCHIVE = 1                               # 0=Off, 1=On

# Are archives public or private by default?
DEFAULT_ARCHIVE_PRIVATE    = 0                    # 0=public, 1=private

# ARCHIVE_TO_MBOX
#-1 - do not do any archiving
# 0 - do not archive to mbox, use builtin mailman html archiving only
# 1 - archive to mbox to use an external archiving mechanism only
# 2 - archive to both mbox and builtin mailman html archiving -
#     use this to make both external archiving mechanism work and
#     mailman's builtin html archiving.  the flat mail file can be
#     useful for searching, external archivers, etc.
#
ARCHIVE_TO_MBOX = 2

# 0 - yearly
# 1 - monthly
# 2 - quarterly
# 3 - weekly
# 4 - daily
#
DEFAULT_ARCHIVE_VOLUME_FREQUENCY = 1

# These variables control the use of an external archiver.  Normally if
# archiving is turned on (see ARCHIVE_TO_MBOX above and the list's archive*
# attributes) the internal Pipermail archiver is used.  This is the default if
# both of these variables are set to false.  When either is set, the value
# should be a shell command string which will get passed to os.popen().  This
# string can contain %(listname)s for dictionary interpolation.  The name of
# the list being archived will be substituted for this.
#
# Note that if you set one of these variables, you should set both of them
# (they can be the same string).  This will mean your external archiver will
# be used regardless of whether public or private archives are selected.
PUBLIC_EXTERNAL_ARCHIVER = 0
PRIVATE_EXTERNAL_ARCHIVER = 0

# Set this to 1 to enable gzipping of the downloadable archive .txt file.
# Note that this is /extremely/ inefficient, so an alternative is to just
# collect the messages in the associated .txt file and run a cron job every
# night to generate the txt.gz file.  See cron/nightly_gzip for details.
GZIP_ARCHIVE_TXT_FILES = 0

# Pipermail archives contain the raw email addresses of the posting authors.
# Some view this as a goldmine for spam harvesters.  Set this to false to
# moderately obscure email addresses, but note that this breaks mailto: URLs
# in the archives too.
ARCHIVER_OBSCURES_EMAILADDRS = 0

# Pipermail assumes that messages bodies contain US-ASCII text.
# Change this option to define a different character set to be used as
# the default character set for the archive.  The term "character set"
# is used in MIME to refer to a method of converting a sequence of
# octets into a sequence of characters.  If you change the default
# charset, you might need to add it to VERBATIM_ENCODING below.
DEFAULT_CHARSET = None

# Most character set encodings require special HTML entity characters to be
# quoted, otherwise they won't look right in the Pipermail archives.  However
# some character sets must not quote these characters so that they can be
# rendered properly in the browsers.  The primary issue is multi-byte
# encodings where the octet 0x26 does not always represent the & character.
# This variable contains a list of such characters sets which are not
# HTML-quoted in the archives.
VERBATIM_ENCODING = ['iso-2022-jp']



#####
# Delivery defaults
#####

# Delivery module for the message pipeline.  See
# Mailman/Handlers/HandlerAPI.py for details.  Unless overridden specifically
# in that module, this handler is used for message delivery to the list, and
# to an individual user.  This value must be a string naming a module in the
# Mailman.Handlers package.
#
# SECURITY WARNING: The Sendmail module is not secure!  Please read the
# comments in Mailman/Handlers/Sendmail.py for details.  Use at your own
# risk.
#
#DELIVERY_MODULE = 'Sendmail'
DELIVERY_MODULE = 'SMTPDirect'

# Ceiling on the number of recipients that can be specified in a single SMTP
# transaction.  Set to 0 to submit the entire recipient list in one
# transaction.  Only used with the SMTPDirect DELIVERY_MODULE.
SMTP_MAX_RCPTS = 500

# Maximum number of simulatenous subthreads that will be used for SMTP
# delivery.  After the recipients list is chunked according to SMTP_MAX_RCPTS,
# each chunk is handed off to the smptd by a separate such thread.  If your
# Python interpreter was not built for threads, this feature is disabled.  You
# can explicitly disable it in all cases by setting MAX_DELIVERY_THREADS to
# 0.  This feature is only supported with the SMTPDirect DELIVERY_MODULE.
#
# NOTE: This is an experimental feature and limited testing shows that it may
# in fact degrade performance, possibly due to Python's global interpreter
# lock.  Use with caution.
MAX_DELIVERY_THREADS = 0

# SMTP host and port, when DELIVERY_MODULE is 'SMTPDirect'
SMTPHOST = 'localhost'
SMTPPORT = 0                                      # default from smtplib

# Command for direct command pipe delivery to sendmail compatible program,
# when DELIVERY_MODULE is 'Sendmail'.
SENDMAIL_CMD = '/usr/lib/sendmail'

# Allow for handling of MTA-specific features (i.e. aliases).  Most MTAs use
# "sendmail" (including Sendmail, Postfix, and Exim).  Qmail uses the "qmail"
# style.
MTA_ALIASES_STYLE = 'sendmail'

# Set these variables if you need to authenticate to your NNTP server for
# Usenet posting or reading.  If no authentication is necessary, specify None
# for both variables.
NNTP_USERNAME = None
NNTP_PASSWORD = None

# Set this if you have an NNTP server you prefer gatewayed lists to use.
DEFAULT_NNTP_HOST = ''



#####
# General defaults
#####

# Set to true to use the crypt module for passwords instead of md5.  Crypt may
# not work on all Python installations.  Don't change this value once you have
# lists running...  In fact, you should just let configure set this one and
# leave it alone.
USE_CRYPT = 1

# When allowing only members to post to a mailing list, how is the sender of
# the message determined?  If this variable is set to 1, then first the
# message's envelope sender is used, with a fallback to the sender if there is
# no envelope sender.  Set this variable to 0 to always use the sender.
#
# The envelope sender is set by the SMTP delivery and is thus less easily
# spoofed than the sender, which is typically just taken from the From: header
# and thus easily spoofed by the end-user.  However, sometimes the envelope
# sender isn't set correctly and this will manifest itself by postings being
# held for approval even if they appear to come from a list member.  If you
# are having this problem, set this variable to 0, but understand that some
# spoofed messages may get through.
USE_ENVELOPE_SENDER = 0

# When true, Mailman will consider user@host.domain to be the same address as
# user@domain.  If set to 0, Mailman will consider user@host.domain to be the
# same address as user@Host.DoMain, but different than user@domain.  Usernames
# will always be case preserved, and host parts of addresses will all be
# lowercased.
SMART_ADDRESS_MATCH = 1

# When set, the listinfo web page overview of lists on the machine will be
# confined to only those lists whose web_page_url configuration option host is
# included within the URL by which the page is visited - only those "on the
# virtual host".  If unset, then all lists are included in the overview.  The
# admin page overview always includes all the lists.
VIRTUAL_HOST_OVERVIEW = 1
DEFAULT_FILTER_PROG = ''                # Currently not used!

# How many members to display at a time on the admin cgi to unsubscribe them
# or change their options?
DEFAULT_ADMIN_MEMBER_CHUNKSIZE = 30

# how many bytes of a held message post should be displayed in the admindb web
# page?  Use a negative number to indicate the entire message, regardless of
# size (though this will slow down rendering those pages).
ADMINDB_PAGE_TEXT_LIMIT = 4096



#####
# List defaults
#####

# Should a list, by default be advertised?  What is the default maximum number
# of explicit recipients allowed?  What is the default maximum message size
# allowed?
DEFAULT_LIST_ADVERTISED = 1
DEFAULT_MAX_NUM_RECIPIENTS = 10
DEFAULT_MAX_MESSAGE_SIZE = 40		# KB

# These format strings will be expanded w.r.t. the dictionary for the
# mailing list instance.
DEFAULT_SUBJECT_PREFIX  = "[%(real_name)s] "
DEFAULT_MSG_HEADER = ""
DEFAULT_MSG_FOOTER = """_______________________________________________
%(real_name)s mailing list
%(real_name)s@%(host_name)s
%(web_page_url)slistinfo%(cgiext)s/%(_internal_name)s
"""

# Mail command processor will ignore mail command lines after designated max.
DEFAULT_MAIL_COMMANDS_MAX_LINES = 25

# Is the list owner notified of admin requests immediately by mail, as well as
# by daily pending-request reminder?
DEFAULT_ADMIN_IMMED_NOTIFY = 1

# Is the list owner notified of subscribes/unsubscribes?
DEFAULT_ADMIN_NOTIFY_MCHANGES = 0

# Are lists, by default, moderated?
DEFAULT_MODERATED = 0

# Bounce if 'To:', 'Cc:', or 'Resent-To:' fields don't explicitly name list?
# This is an anti-spam measure
DEFAULT_REQUIRE_EXPLICIT_DESTINATION = 1

# Alternate names acceptable as explicit destinations for this list.
DEFAULT_ACCEPTABLE_ALIASES ="""
"""
# For mailing lists that have only other mailing lists for members:
DEFAULT_UMBRELLA_LIST = 0

# For umbrella lists, the suffix for the account part of address for
# administrative notices (subscription confirmations, password reminders):
DEFAULT_UMBRELLA_MEMBER_ADMIN_SUFFIX = "-owner"

# This variable controlls whether monthly password reminders are sent.
DEFAULT_SEND_REMINDERS = 1

# Send welcome messages to new users?  Probably should keep this set to 1.
DEFAULT_SEND_WELCOME_MSG = 1

# Wipe sender information, and make it look like the list-admin
# address sends all messages
DEFAULT_ANONYMOUS_LIST = 0

# {header-name: regexp} spam filtering - we include some for example sake.
DEFAULT_BOUNCE_MATCHING_HEADERS = """
# Lines that *start* with a '#' are comments.
to: friend@public.com
message-id: relay.comanche.denmark.eu
from: list@listme.com
from: .*@uplinkpro.com
"""

# Mailman can be configured to "munge" Reply-To: headers for any passing
# messages.  One the one hand, there are a lot of good reasons not to munge
# Reply-To: but on the other, people really seem to want this feature.  See
# the help for reply_goes_to_list in the web UI for links discussing the
# issue.
# 0 - Reply-To: not munged
# 1 - Reply-To: set back to the list
# 2 - Reply-To: set to an explicit value (reply_to_address)
DEFAULT_REPLY_GOES_TO_LIST = 0

# SUBSCRIBE POLICY
# 0 - open list (only when ALLOW_OPEN_SUBSCRIBE is set to 1) **
# 1 - confirmation required for subscribes
# 2 - admin approval required for subscribes
# 3 - both confirmation and admin approval required
#
# ** please do not choose option 0 if you are not allowing open
# subscribes (next variable)
DEFAULT_SUBSCRIBE_POLICY = 1

# does this site allow completely unchecked subscriptions?
ALLOW_OPEN_SUBSCRIBE = 0

# Private_roster == 0: anyone can see, 1: members only, 2: admin only.
DEFAULT_PRIVATE_ROSTER = 0

# When exposing members, make them unrecognizable as email addrs, so
# web-spiders can't pick up addrs for spam purposes.
DEFAULT_OBSCURE_ADDRESSES = 1

# Make it 1 when it works.
DEFAULT_MEMBER_POSTING_ONLY = 0



#####
# Digestification defaults
#####

# Will list be available in non-digested form?
DEFAULT_NONDIGESTABLE = 1

# Will list be available in digested form?
DEFAULT_DIGESTABLE = 1
DEFAULT_DIGEST_HEADER = ""
DEFAULT_DIGEST_FOOTER = DEFAULT_MSG_FOOTER

DEFAULT_DIGEST_IS_DEFAULT = 0
DEFAULT_MIME_IS_DEFAULT_DIGEST = 0
DEFAULT_DIGEST_SIZE_THRESHHOLD = 30	# KB
DEFAULT_DIGEST_SEND_PERIODIC = 1
DEFAULT_PLAIN_DIGEST_KEEP_HEADERS = ['message', 'date', 'from',
                                     'subject', 'to', 'cc',
                                     'reply-to', 'organization']



#####
# Bounce processing defaults
#####

# Should we do any bounced mail response at all?
DEFAULT_BOUNCE_PROCESSING = 1

# Minimum number of days that address has been undeliverable before 
# we take the automatic bounce action.
DEFAULT_MINIMUM_REMOVAL_DATE = 5

# Minimum number of delivery failure notices for an account before we
# consider doing the automatic bounce action.
DEFAULT_MINIMUM_POST_COUNT_BEFORE_BOUNCE_ACTION = 3

# 0 means do nothing
# 1 means disable and notify the list admin
# 2 means disable and don't notify the list admin
# 3 means remove and notify
DEFAULT_AUTOMATIC_BOUNCE_ACTION = 1

# Maximum number of posts that can go by w/o a bounce before we figure 
# delivery failures to a particular recipient have been resolved.  This
# needs to account for the big lag between delivery attempt and issuance of 
# the failure notice.  We recommend a value representing the maximum number
# of messages you'd reasonably expect an average list to get in 1 hour.
DEFAULT_MAX_POSTS_BETWEEN_BOUNCES = 5

# Check for administrivia in messages sent to the main list?
DEFAULT_ADMINISTRIVIA = 1

# List of addresses (lhs of the @) that likely come only from MTAs bouncing
# messages.  This is used in qrunner and MailCommandHandler.py to stop
# processing or forwarding such messages.
#
# TBD: why orphanage?  why postoffice?
LIKELY_BOUNCE_SENDERS = ('daemon', 'mailer-daemon', 'postmaster',
                         'orphanage', 'postoffice')



#####
# General time limits
#####

# Authentication cookie control.  When set to 0, Mailman's admin cookie
# expires at the end of your session.  This is preferred for security reasons,
# and to avoid potential problems with incorrect clock and timezone settings.
# Set this to a value > 0 to use persistent admin cookies with a lifetime of
# that number of seconds.
ADMIN_COOKIE_LIFE = 0

# How long should subscriptions requests await confirmation before being
# dropped?
PENDING_REQUEST_LIFE = days(3)

# How long should messages which have delivery failures continue to be
# retried?  After this period of time, a message that has failed recipients
# will be dequeued and those recipients will never receive the message.
DELIVERY_RETRY_PERIOD = days(5)



#####
# Lock management defaults
#####

# These variables control certain aspects of lock acquisition and retention.
# They should be tuned as appropriate for your environment.  All variables are
# specified in units of floating point seconds.  YOU MAY NEED TO TUNE THESE
# VARIABLES DEPENDING ON THE SIZE OF YOUR LISTS, THE PERFORMANCE OF YOUR
# HARDWARE, NETWORK AND GENERAL MAIL HANDLING CAPABILITIES, ETC.

# Set this to true to turn on MailList object lock debugging messages, which
# will be written to logs/locks.  If you think you're having lock problems, or
# just want to tune the locks for your system, turn on lock debugging.
LIST_LOCK_DEBUGGING = 0

# This variable specifies how long the lock will be retained for a specific
# operation on a mailing list.  Watch your logs/lock file and if you see a lot
# of lock breakages, you might need to bump this up.  However if you set this
# too high, a faulty script (or incorrect use of bin/withlist) can prevent the
# list from being used until the lifetime expires.  This is probably one of
# the most crucial tuning variables in the system.
LIST_LOCK_LIFETIME = hours(5)

# This variable specifies how long an attempt will be made to acquire a list
# lock by the qrunner process.  If the lock acquisition times out, the message
# will be re-queued for later delivery.
LIST_LOCK_TIMEOUT = seconds(10)

# cron/qrunner lock lifetime.  This is probably the second most crucial tuning
# variable in the system.  See the notes for LIST_LOCK_LIFETIME above.  Watch
# your logs/smtp file and make sure that QRUNNER_LOCK_LIFETIME is set longer
# than the longest period you see here.  It is a bad thing if multiple
# qrunners run at the same time.
QRUNNER_LOCK_LIFETIME = hours(10)

# Two other qrunner resource management variables.  The first controls the
# maximum lifetime of any single qrunner process, and the second controls the
# maximum number of messages a single qrunner process will, er, process.
# Exceeding either limit causes qrunner to exit, reclaiming system resources
# and deleting the lock.  Other qrunners will then process the remaining
# messages.  Set either to None to inhibit this resource check.
QRUNNER_PROCESS_LIFETIME = minutes(15)
QRUNNER_MAX_MESSAGES = 300



#####
# Nothing below here is user configurable.  Most of these values are in this
# file for convenience.  Don't change any of them or override any of them in
# your mm_cfg.py file!
#####

# These directories are used to find various important files in the Mailman
# installation.  PREFIX and EXEC_PREFIX are set by configure and should point
# to the installation directory of the Mailman package.
PYTHON  	= '/apps/python222/python.exe'
PREFIX  	= '/unixos2/home/mailman'
EXEC_PREFIX	= '${prefix}'
VAR_PREFIX	= '/unixos2/home/mailman'

# Work around a bogus autoconf 2.12 bug
if EXEC_PREFIX == '${prefix}':
    EXEC_PREFIX = PREFIX

# CGI extension, change using configure script
CGIEXT = ''

# Group id that group-owns the Mailman installation
MAILMAN_UID = 0
MAILMAN_GID = 0

# Enumeration for types of configurable variables in Mailman.
Toggle     = 1
Radio      = 2
String     = 3
Text       = 4
Email      = 5
EmailList  = 6
Host       = 7
Number     = 8
FileUpload = 9

# Held message disposition actions, for use between admindb.py and
# ListAdmin.py.
DEFER = 0
APPROVE = 1
REJECT = 2
DISCARD = 3
SUBSCRIBE = 4

# Standard text field width
TEXTFIELDWIDTH = 40

# Bitfield for user options
Digests             = 0 # handled by other mechanism, doesn't need a flag.
DisableDelivery     = 1
DontReceiveOwnPosts = 2 # Non-digesters only
AcknowledgePosts    = 4
DisableMime         = 8 # Digesters only
ConcealSubscription = 16

# Useful directories
LIST_DATA_DIR	= os.path.join(VAR_PREFIX, 'lists')
HTML_DIR	= os.path.join(PREFIX, 'public_html')
CGI_DIR 	= os.path.join(EXEC_PREFIX, 'cgi-bin')
LOG_DIR 	= os.path.join(VAR_PREFIX, 'logs')
LOCK_DIR	= os.path.join(VAR_PREFIX, 'locks')
DATA_DIR	= os.path.join(VAR_PREFIX, 'data')
QUEUE_DIR       = os.path.join(VAR_PREFIX, 'qfiles')
SPAM_DIR        = os.path.join(VAR_PREFIX, 'spam')
WRAPPER_DIR	= os.path.join(EXEC_PREFIX, 'mail')
SCRIPTS_DIR	= os.path.join(PREFIX, 'scripts')
TEMPLATE_DIR	= os.path.join(PREFIX, 'templates')
PUBLIC_ARCHIVE_FILE_DIR  = os.path.join(VAR_PREFIX, 'archives', 'public')
PRIVATE_ARCHIVE_FILE_DIR = os.path.join(VAR_PREFIX, 'archives', 'private')

SITE_PW_FILE = os.path.join(DATA_DIR, 'adm.pw')

# Import a bunch of version numbers
from Version import *
