/**********************************************************************/
/*                                                                    */
/* MAIL.CMD version 1.1                                               */
/*                                                                    */
/* REXX-script to make a connection with the Internet, exchange       */
/* mail and news, and terminate the connection.                       */
/*                                                                    */
/* Written and copyrighted by Ruud Senden, 1995                       */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Start of user variables, it is all right to change these.          */
/* Please see MAIL.DOC for information about these variables.         */
/*                                                                    */
logFile     = 'E:\INTERNET\ACCU\MAIL.LOG'    /* Logfile               */
dirExport   = 'E:\INTERNET\ACCU\SOUP'        /* Process mail to send  */
dirSend     = 'E:\INTERNET\ACCU\SOUP\REPLY'  /* Send mail and news    */
dirRecv     = 'E:\INTERNET\ACCU\SOUP'        /* Receive mail and news */
dirImport   = 'E:\INTERNET\ACCU\SOUP'        /* Process received mail */

prgExport   = 'SOUP2SQ -s'                   /* Process mail to send  */
prgSend     = 'SOUPER -s'                    /* Send mail and news    */
prgRecv     = 'SOUPER'                       /* Receive mail and news */
prgImport   = 'SOUP2SQ -r'                   /* Process received mail */

                                             /* Initialise connection */
prgConnect  = 'DETACH ppp.exe com1 19200 mru 1500 rtscts modem defaultroute priority 1 notify exit idle 15 connect "accu.cmd"'            
prgKill     = 'PPPKILL'                      /* Terminate connection  */

newsServer  = 'news.cs.ruu.nl'               /* News server           */

timeout1    = 300                            /* First timeout         */
timeout2    = 60                             /* Second timeout        */
triggerFile = 'E:\INTERNET\ACCU\CONNECT.TMR' /* File needed for timer */
/*                                                                    */
/* End of user variables, don't change anything after this point.     */
/**********************************************************************/

parse upper arg HangUp  /* Parse program parameters                   */

say ''                  /* Print empty line                           */
ConnectionStarted = 0   /* No Initialise Connection-cmd given         */
startDir = directory()  /* Save current directory                     */

call loadFuncs          /* Load necessary external functions          */
call checkFiles         /* Check logfile and triggerfile              */

signal on error name error     /* Install signal handlers to catch    */
signal on failure name error   /* fatal errors, so the connection     */
signal on halt name error      /* can be terminated if necessary.     */
signal on syntax name error    /*                                     */
signal on notready name error  /*                                     */

call export             /* Export mail and news to send from msg-base */
call connect            /* Initialise connection with the Internet    */
call wait_server        /* Wait for the server to become available    */
call send               /* Send mail and news to the Internet         */
call receive            /* Receive mail and news from the Internet    */
call disconnect         /* Terminate connection with the Internet     */
call import             /* Import received mail and news in msg-base  */

call directory startDir /* Reset current directory                    */
call SockDropFuncs      /* Drop REXX socket-functions                 */
call SysDropFuncs       /* Drop REXX utility-functions                */
exit                    /* Exit REXX-script                           */


/**********************************************************************/
/* The export-function will process mail and news from your           */
/* message-base to create reply-packets which will be sent to         */
/* the Internet after the connection is established.                  */
/* If prgExport is empty this function will be skipped.               */
/*                                                                    */
export:

if prgExport \= 'PRGEXPORT' & prgExport \= '' then do

   call wrt_msg 'Scanning for mail and news to send to the Internet...'
   call chgDir dirExport
   prgExport' >>& 'logFile

   /* The following part will only work if you use SOUP-packets,      */
   /* else you'll have to change or delete it.                        */
   /*                                                                 */
   call chgDir dirSend
   if stream('REPLIES','c','query exists') = '' then
      call wrt_msg 'No mail or news available to send to the Internet.'
   /*                                                                 */
   /* End of SOUP-part.                                               */

end  /* Do */

return
/*                                                                    */
/* End of export-function.                                            */
/**********************************************************************/


/**********************************************************************/
/* The connect-function will initialise the connection with the       */
/* Internet.                                                          */
/* If prgConnect is empty, this function will be skipped.             */
/*                                                                    */
connect:

if prgConnect \= 'PRGCONNECT' & prgConnect \= '' then do
   call wrt_msg 'Initializing connection with the Internet...'
   ConnectionStarted = 1
   prgConnect
end  /* Do */

return                                                                
/*                                                                    */
/* End of connect-function                                            */
/**********************************************************************/


/**********************************************************************/
/* The wait_server-function will wait for the news-server to become   */
/* available. There are two time-out values, the first one will       */
/* start immediatly, the second one will start after a CONNECT-msg    */
/* is received by your dial-script (a change to you dial-script is    */
/* needed to enable the second time-out, see MAIL.DOC).               */
/*                                                                    */
wait_server:

strt2 = -1
tm = time( 'Reset' )
call wrt_msg 'Waiting until the news-server becomes available...'

do while SockGetHostByName( NewsServer, "host.!" ) = 0

   if timeout1 \= 0 then
      if time( 'Elapsed' ) > timeout1 then do
         call wrt_msg 'Timer 1 expired.'
         signal error
      end  /* Do */

   if timeout2 \= 0 then do
      if strt2 \= -1 then do
         if time( 'Elapsed' ) - strt2 > timeout2 then do
            call wrt_msg 'Timer 2 expired.'
            signal error
         end  /* Do */
      end  /* Do */
      else
         if stream( triggerFile, 'c', 'query exists' ) \= '' then do
            strt2 = time( 'Elapsed' )
            ret = SysFileDelete( triggerFile )
         end  /* Do */
   end  /* Do */
 
   call SysSleep 1

end /* do */

return
/*                                                                    */
/* End of connect-function.                                           */
/**********************************************************************/


/**********************************************************************/
/* The send-function will send available mail and news to the         */
/* Internet.                                                          */
/* If prgSend is empty this function will be skipped.                 */
/*                                                                    */
send:

if prgSend \= 'PRGSEND' & prgSend \= '' then do
   call chgDir dirSend

   /* The following check will only work if you use SOUP-packets.     */
   /* If you use other packets or don't use packets at all, you will  */
   /* have to change or delete this test.                             */
   /*                                                                 */
   if stream('REPLIES','c','query exists') \= '' then do
      call wrt_msg 'Sending mail and/or news to the Internet...'
      prgSend' >>& 'logFile
   end  /* Do */
   /*                                                                 */
   /* End of SOUP-part                                                */

end  /* Do */

return
/*                                                                    */
/* End of send-function.                                              */
/**********************************************************************/


/**********************************************************************/
/* The receive-function will receive new mail and news from the       */
/* Internet.                                                          */
/* If prgRecv is empty this function will be skipped.                 */
/*                                                                    */
receive:

if prgRecv \= 'PRGRECV' & prgRecv \= '' then do

   call wrt_msg 'Receiving new mail and/or news from the Internet...'
   call chgDir dirRecv
   prgRecv' >>& 'logFile

   /* This check will only work if you use SOUP-packets, else you'll  */
   /* have to change or delete it.                                    */
   /*                                                                 */
   if stream('AREAS','c','query size') = 0 then
      call wrt_msg 'No mail or news received from the Internet.'
   /*                                                                 */
   /* End of SOUP-part.                                               */

   end  /* Do */

return
/*                                                                    */
/* End of receive-function.                                           */
/**********************************************************************/


/**********************************************************************/
/* The disconnect-function will terminate the connection with the     */
/* Internet, or, if a parameter is specified on the command-line,     */
/* it will display a message of how to terminate the connection       */
/* yourself.                                                          */
/* If prgKill is empty, a warning message will be shown.              */
/*                                                                    */
disconnect:

if ConnectionStarted = 1 then do
   if prgKill = 'PRGKILL' | prgKill = '' then
      call wrt_msg 'Warning: no command configured to terminate the ',
                   'connection with the Internet.'
   else do
      if HangUp \= "" then do
         say "Type '"prgKill"' at an OS/2 command prompt to terminate"
         say "the connection with the Internet."
      end  /* Do */
      else do
         call wrt_msg 'Terminating connection with the Internet...'
         prgKill' >>& 'logFile
         ConnectionStarted = 0
      end  /* Do */
   end  /* Do */
end  /* Do */

return
/*                                                                    */
/* End of disconnect-function.                                        */
/**********************************************************************/


/**********************************************************************/
/* The import-funtion imports received mail and news into your        */
/* message-base.                                                      */
/* If prgImport is empty, this function will be skipped.              */
/*                                                                    */
import:

if prgImport \= 'PRGIMPORT' & prgImport \= '' then do
   call chgDir dirImport

   /* This check will only work if you use SOUP-packets, else you'll  */
   /* have to change or delete this check.                            */
   /*                                                                 */
   if stream('AREAS','c','query size') \= 0 then do
      call wrt_msg 'Processing received mail and/or news...'
      prgImport' >>& 'logFile
   end  /* Do */
   /*                                                                 */
   /* End of SOUP-part.                                               */

end  /* Do */

return
/*                                                                    */
/* End of import-function                                             */
/**********************************************************************/


/**********************************************************************/
/* the loadFuncs-function loads the necessary external functions.     */
/*                                                                    */
loadFuncs:

if RxFuncQuery( "SysLoadFuncs" ) then do
   call RxFuncAdd "SysLoadFuncs", "REXXUTIL", "SysLoadFuncs"
   call SysLoadFuncs
end /* Do */

if RxFuncQuery( "SockLoadFuncs" ) then do
   call RxFuncAdd "SockLoadFuncs", "RxSock", "SockLoadFuncs"
   call SockLoadFuncs "NoLogo"
end /* Do */

return
/*                                                                    */
/* End of loadFuncs-function                                          */
/**********************************************************************/


/**********************************************************************/
/* The checkFiles-function checks whether the given logfile is        */
/* valid and removes some files                                       */
/*                                                                    */
checkFiles:

ret = stream( logFile, 'c', 'open' )
if ret \= 'READY:' then do
   say "Can't open logfile "logFile" ("ret")."
   say "Please check the logFile variable which can be found"
   say "at the top of this REXX-script."
   signal error
end  /* Do */
ret = stream( logFile, 'c', 'close' )
ret = SysFileDelete( triggerFile )
ret = SysFileDelete( logFile )

return
/*                                                                    */
/* End of checkFiles-function.                                        */
/**********************************************************************/


/**********************************************************************/
/* The chgDir-function changes to another directory, displaying an    */
/* error-message and terminating the program if it fails.             */
/* If the given parameter is empty, this function will be skipped.    */
/*                                                                    */
chgDir:

parse arg newDir
if newDir \= '' then do
   curDir = directory( newDir )
   if curDir \= newDir then do
      say ''
      say 'Error changing directory to 'newDir'!'
      say 'Please check the variables at the top of this REXX-script.'
      signal error
   end  /* Do */
end  /* Do */

return
/*                                                                    */
/* End of chgDir-function.                                            */
/**********************************************************************/


/**********************************************************************/
/* The wrt_msg-function writes a message to both the logfile and      */
/* the screen.                                                        */
/*                                                                    */
wrt_msg:

parse arg msg

ret = lineout( logFile, '' )
ret = lineout( logFile, msg )
ret = lineout( logFile, '' )
ret = stream( logFile, 'c', 'close' )
say msg

return
/*                                                                    */
/* End of wrt_msg-function.                                           */
/**********************************************************************/


/**********************************************************************/
/* The error-function is called when an error occures. It displays    */
/* a message, calls the function disconnect, resets the current       */
/* directory, drops the loaded REXX-functions and terminates the      */
/* program.                                                           */
/*                                                                    */
error:

say ''
say 'Abnormal program termination.'

call disconnect
call beep 50, 500
call directory startDir

if \ RxFuncQuery( 'SockDropFuncs' ) then
   call SockDropFuncs
if \ RxFuncQuery( 'SysDropFuncs' ) then
   call SysDropFuncs

exit
/*                                                                    */
/* End of error-function.                                             */
/**********************************************************************/
