/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.StandardSearchView;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.gui.InputPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;

public class MetaSearchFrame
extends JDialog {
    private StandardSearchView searchView;
    private String schemaURI;
    private JPanel regSearchPanel;
    private JLabel regLabel;
    private JTextField regSearchField;
    private JPanel schemaPanel;
    private InputPanel inputPanel;
    private JPanel buttonPanel;
    private JButton cancelButton;
    private JButton searchButton;
    private JScrollPane schemaScroller;
    private JPanel grandPanel;
    private final int WIDTH = 500;
    private final int HEIGHT = 500;
    private final int INIT_X = 200;
    private final int INIT_Y = 200;

    public MetaSearchFrame(StandardSearchView standardSearchView, String string) {
        super(GUIMediator.getAppFrame(), GUIMediator.getStringResource("META_SEARCH_TITLE"), true);
        if (string == null || string.equals("")) {
            return;
        }
        this.schemaURI = string;
        this.searchView = standardSearchView;
        ((Component)this).setSize(500, 500);
        ((Component)this).setLocation(200, 200);
        this.regSearchPanel = new JPanel();
        this.regLabel = new JLabel(GUIMediator.getStringResource("META_SEARCH_STRING"));
        this.regSearchField = new JTextField(20);
        this.regSearchPanel.add(this.regLabel);
        this.regSearchPanel.add(this.regSearchField);
        this.schemaPanel = new JPanel(new BorderLayout());
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(this.schemaURI);
        this.inputPanel = new InputPanel(limeXMLSchema);
        this.schemaPanel.add((Component)this.inputPanel, "Center");
        this.schemaScroller = new JScrollPane(this.schemaPanel);
        this.buttonPanel = new JPanel();
        this.cancelButton = new JButton(GUIMediator.getStringResource("META_SEARCH_CANCEL_BUTTON_LABEL"));
        this.searchButton = new JButton(GUIMediator.getStringResource("META_SEARCH_SEARCH_BUTTON_LABEL"));
        this.buttonPanel.add(this.searchButton);
        this.searchButton.addActionListener(new SearchListener());
        this.buttonPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(new CancelListener());
        this.grandPanel = new JPanel(new BorderLayout());
        this.grandPanel.add((Component)this.regSearchPanel, "North");
        this.grandPanel.add((Component)this.buttonPanel, "South");
        this.grandPanel.add((Component)this.schemaScroller, "Center");
        Container container = this.getContentPane();
        container.add((Component)this.grandPanel, "Center");
    }

    private byte[] triggerSearch() {
        byte[] byArray;
        String string = this.regSearchField.getText().trim();
        if (string.equals("") && ((string = this.inputPanel.getFirstField()) == null || string.equals(""))) {
            return null;
        }
        String string2 = this.inputPanel.getInput();
        int n = 0;
        this.dispose();
        MediaType mediaType = null;
        if (LimeXMLSchema.getDisplayString(this.schemaURI).equals("audio")) {
            mediaType = MediaType.getAudioMediaType();
        } else if (LimeXMLSchema.getDisplayString(this.schemaURI).equals("video")) {
            mediaType = MediaType.getVideoMediaType();
        }
        if (string2 == null) {
            byArray = GUIMediator.instance().getRouter().query(string, n, mediaType);
            GUID gUID = new GUID(byArray);
            this.searchView.addResultTab(gUID, string);
        } else {
            byArray = GUIMediator.instance().getRouter().query(string, string2, n, mediaType, this.schemaURI);
            GUID gUID = new GUID(byArray);
            LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
            LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(this.schemaURI);
            Assert.that(limeXMLSchema != null, "No valid schema for rich query");
            this.searchView.addResultTab(gUID, string, limeXMLSchema, string2);
        }
        return byArray;
    }

    private class SearchListener
    implements ActionListener {
        private SearchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetaSearchFrame.this.triggerSearch();
        }
    }

    private class CancelListener
    implements ActionListener {
        private CancelListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetaSearchFrame.this.dispose();
        }
    }
}

