/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.limegroup.gnutella.xml.gui.EditingPanel;
import com.limegroup.gnutella.xml.gui.InputPanel;
import com.limegroup.gnutella.xml.gui.OuterEditingPanel;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.List;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class MetaEditorFrame
extends JDialog
implements ActionListener {
    private final String FILE_LABEL = GUIMediator.getStringResource("META_EDITOR_ANNOTATING_FILE");
    private final int WIDTH = 500;
    private final int HEIGHT = 500;
    private final int INIT_X = 100;
    private final int INIT_Y = 100;
    private JPanel filePanel;
    private JLabel fileLabel;
    private JTextField fileField;
    private JPanel buttonPanel;
    private JButton saveButton;
    private JButton cancelButton;
    private JButton deleteButton;
    private JSplitPane splitPane;
    private JPanel upperLeftPanel;
    private JPanel lowerLeftPanel;
    private JList docSchemaList;
    private JLabel editLabel;
    private JLabel addLabel;
    private JList unDocSchemaList;
    private InputPanel innerEditPanel;
    private OuterEditingPanel outerEditPanel;
    private JScrollPane upperLeftScroller;
    private JScrollPane lowerLeftScroller;
    private List noDocSchemas;
    private List docsOfFile;
    private String fileName;
    private String selectedSchemaURI;
    private LimeXMLDocument editedDoc;
    private JSplitPane splitter;
    private JPanel grandPanel;
    private String editFileHashValue;

    public MetaEditorFrame(String string, Frame frame) {
        super(frame, GUIMediator.getStringResource("META_EDITOR_ANNOTATING_FILE") + "\"" + string + "\"", true);
        Object object;
        Object object2;
        this.fileName = string;
        try {
            this.editFileHashValue = new String(LimeXMLUtils.hashFile(new File(string)));
        }
        catch (Exception exception) {
            return;
        }
        this.noDocSchemas = new ArrayList();
        this.docsOfFile = this.getDocs(string);
        this.filePanel = new JPanel(new FlowLayout(0));
        this.fileLabel = new JLabel(this.FILE_LABEL);
        this.fileField = new JTextField();
        this.fileField.setText(string);
        this.fileField.setEditable(false);
        this.filePanel.add(this.fileLabel);
        this.filePanel.add(this.fileField);
        this.buttonPanel = new JPanel();
        this.saveButton = new JButton(GUIMediator.getStringResource("META_EDITOR_SAVE_LABEL"));
        this.cancelButton = new JButton(GUIMediator.getStringResource("META_EDITOR_CANCEL_LABEL"));
        this.deleteButton = new JButton(GUIMediator.getStringResource("META_EDITOR_DELETE_LABEL"));
        this.saveButton.addActionListener(this);
        this.cancelButton.addActionListener(this);
        this.deleteButton.addActionListener(this);
        this.buttonPanel.add(this.saveButton);
        this.buttonPanel.add(this.deleteButton);
        this.buttonPanel.add(this.cancelButton);
        this.upperLeftPanel = new JPanel();
        this.upperLeftPanel.setLayout(new BorderLayout());
        this.lowerLeftPanel = new JPanel();
        this.lowerLeftPanel.setLayout(new BorderLayout());
        this.editLabel = new JLabel(GUIMediator.getStringResource("META_EDITOR_EDITING_LABEL"));
        JPanel jPanel = new JPanel(new FlowLayout(0));
        jPanel.setBackground(Color.white);
        jPanel.add(this.editLabel);
        this.upperLeftPanel.add((Component)jPanel, "North");
        int n = this.docsOfFile.size();
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            object2 = (LimeXMLDocument)this.docsOfFile.get(n2);
            stringArray[n2] = LimeXMLSchema.getDisplayString(((LimeXMLDocument)object2).getSchemaURI());
            ++n2;
        }
        this.docSchemaList = new JList<String>(stringArray);
        this.docSchemaList.setSelectionMode(0);
        this.docSchemaList.addListSelectionListener(new DocListListener());
        this.upperLeftScroller = new JScrollPane(this.docSchemaList);
        this.upperLeftPanel.add((Component)this.upperLeftScroller, "Center");
        this.addLabel = new JLabel(GUIMediator.getStringResource("META_EDITOR_ADDING_LABEL"));
        object2 = new JPanel(new FlowLayout(0));
        ((JComponent)object2).setBackground(Color.white);
        ((Container)object2).add(this.addLabel);
        this.lowerLeftPanel.add((Component)object2, "North");
        int n3 = this.noDocSchemas.size();
        String[] stringArray2 = new String[n3];
        int n4 = 0;
        while (n4 < n3) {
            String string2 = (String)this.noDocSchemas.get(n4);
            stringArray2[n4] = LimeXMLSchema.getDisplayString(string2);
            ++n4;
        }
        this.unDocSchemaList = new JList<String>(stringArray2);
        this.unDocSchemaList.setSelectionMode(0);
        this.unDocSchemaList.addListSelectionListener(new UnDocListListener());
        this.lowerLeftScroller = new JScrollPane(this.unDocSchemaList);
        this.lowerLeftPanel.add((Component)this.lowerLeftScroller, "Center");
        this.splitPane = new JSplitPane(0, this.upperLeftPanel, this.lowerLeftPanel);
        this.splitPane.setDividerLocation(this.splitPane.getMinimumDividerLocation() + 99);
        this.splitPane.setBackground(Color.white);
        int n5 = this.docSchemaList.getSelectedIndex();
        if (n5 > -1) {
            object = (LimeXMLDocument)this.docsOfFile.get(n5);
            String string3 = ((LimeXMLDocument)object).getSchemaURI();
            LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
            LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(string3);
            this.innerEditPanel = new EditingPanel(limeXMLSchema, (LimeXMLDocument)object);
        } else {
            n5 = this.unDocSchemaList.getSelectedIndex();
            if (n5 > -1) {
                object = (String)this.noDocSchemas.get(n5);
                LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
                LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema((String)object);
                this.innerEditPanel = new InputPanel(limeXMLSchema);
            }
        }
        this.outerEditPanel = new OuterEditingPanel(this.innerEditPanel);
        ((Component)this).setSize(500, 500);
        ((Component)this).setLocation(100, 100);
        this.splitter = new JSplitPane(1, this.splitPane, this.outerEditPanel);
        this.splitter.setDividerLocation(this.splitter.getMinimumDividerLocation());
        this.grandPanel = new JPanel();
        this.grandPanel.setLayout(new BorderLayout());
        this.grandPanel.add((Component)this.filePanel, "North");
        this.grandPanel.add((Component)this.splitter, "Center");
        this.grandPanel.add((Component)this.buttonPanel, "South");
        object = this.getContentPane();
        ((Container)object).add((Component)this.grandPanel, "Center");
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource().equals(this.saveButton)) {
            this.saveMeta();
            this.dispose();
        } else if (actionEvent.getSource().equals(this.deleteButton)) {
            this.removeMeta();
            this.dispose();
        } else if (actionEvent.getSource().equals(this.cancelButton)) {
            this.dispose();
        }
    }

    private void removeMeta() {
        InputPanel inputPanel = this.outerEditPanel.getContentPanel();
        if (!(inputPanel instanceof EditingPanel)) {
            GUIMediator.showError("ERROR_DEL_META_USER");
            return;
        }
        String string = this.editedDoc.getSchemaURI();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
        Assert.that(limeXMLReplyCollection != null, "Trying to remove data from a non-existent collection");
        boolean bl = limeXMLReplyCollection.removeDoc(this.editFileHashValue);
        if (bl) {
            this.editedDoc = null;
        } else {
            GUIMediator.showError("ERROR_DEL_META_SYSTEM");
        }
    }

    private void saveMeta() {
        InputPanel inputPanel = this.outerEditPanel.getContentPanel();
        if (inputPanel == null) {
            return;
        }
        String string = inputPanel.getInput();
        string = this.insertIdentifier(string);
        LimeXMLDocument limeXMLDocument = null;
        try {
            limeXMLDocument = new LimeXMLDocument(string);
        }
        catch (Exception exception) {
            GUIMediator.showError("ERROR_SAVE_META_DOC");
            return;
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        String string2 = limeXMLDocument.getSchemaURI();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string2);
        Assert.that(limeXMLReplyCollection != null, "Cant add doc to nonexistent collection");
        if (inputPanel instanceof EditingPanel) {
            limeXMLReplyCollection.replaceDoc(this.editFileHashValue, limeXMLDocument);
        } else if (inputPanel instanceof InputPanel) {
            limeXMLReplyCollection.addReply(this.editFileHashValue, limeXMLDocument);
        } else {
            GUIMediator.showError("ERROR_SAVE_META_ILLEGAL");
        }
        boolean bl = limeXMLReplyCollection.audio ? limeXMLReplyCollection.mp3ToDisk(this.fileName) : limeXMLReplyCollection.toDisk("");
        if (!bl) {
            GUIMediator.showError("ERROR_SAVE_META_DISK");
            return;
        }
    }

    private String insertIdentifier(String string) {
        int n = string.indexOf(">");
        if (n < 0) {
            return string;
        }
        ++n;
        n = string.indexOf(">", n);
        ++n;
        n = string.indexOf(">", n);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String string4 = " identifier=\"" + this.fileName + "\"";
        string = string2 + string4 + string3;
        return string;
    }

    private List getDocs(String string) {
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = stringArray.length;
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(stringArray[n2]);
            if (limeXMLReplyCollection == null || limeXMLReplyCollection.getCount() < 1) {
                this.noDocSchemas.add((Object)stringArray[n2]);
            } else {
                LimeXMLDocument limeXMLDocument = limeXMLReplyCollection.getDocForHash(this.editFileHashValue);
                if (limeXMLDocument == null) {
                    this.noDocSchemas.add((Object)stringArray[n2]);
                } else {
                    arrayList.add((Object)limeXMLDocument);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private class UnDocListListener
    implements ListSelectionListener {
        private UnDocListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = MetaEditorFrame.this.docSchemaList.getSelectedIndex();
            MetaEditorFrame.this.docSchemaList.removeSelectionInterval(n, n);
            int n2 = MetaEditorFrame.this.unDocSchemaList.getSelectedIndex();
            if (n2 > -1) {
                String string = (String)MetaEditorFrame.this.noDocSchemas.get(n2);
                MetaEditorFrame.this.selectedSchemaURI = string;
                MetaEditorFrame.this.editedDoc = null;
                LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
                LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(string);
                MetaEditorFrame.this.innerEditPanel = new InputPanel(limeXMLSchema);
                MetaEditorFrame.this.outerEditPanel.setContent(MetaEditorFrame.this.innerEditPanel);
                MetaEditorFrame.this.outerEditPanel.revalidate();
            }
        }
    }

    private class DocListListener
    implements ListSelectionListener {
        private DocListListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            int n = MetaEditorFrame.this.unDocSchemaList.getSelectedIndex();
            MetaEditorFrame.this.unDocSchemaList.removeSelectionInterval(n, n);
            int n2 = MetaEditorFrame.this.docSchemaList.getSelectedIndex();
            if (n2 > -1) {
                LimeXMLDocument limeXMLDocument = (LimeXMLDocument)MetaEditorFrame.this.docsOfFile.get(n2);
                MetaEditorFrame.this.editedDoc = limeXMLDocument;
                MetaEditorFrame.this.selectedSchemaURI = limeXMLDocument.getSchemaURI();
                LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
                LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(MetaEditorFrame.this.selectedSchemaURI);
                MetaEditorFrame.this.innerEditPanel = new EditingPanel(limeXMLSchema, limeXMLDocument);
                MetaEditorFrame.this.outerEditPanel.setContent(MetaEditorFrame.this.innerEditPanel);
                MetaEditorFrame.this.outerEditPanel.revalidate();
            }
        }
    }
}

