/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.StandardSearchView;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.gui.DisplayPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class MetaDisplayFrame
extends JDialog {
    private StandardSearchView stdSrchView;
    private TableLine line;
    private ResultPanel rp;
    private JButton downloadButton;
    private JButton cancelButton;
    private JButton launchButton;
    private JPanel buttonPanel;
    private DisplayPanel dataPanel;
    private boolean valid;
    private JScrollPane scrollPane;
    private JPanel grandPanel;
    private final int HEIGHT = 500;
    private final int WIDTH = 500;
    private final int INIT_X = 200;
    private final int INIT_Y = 200;
    private String action = "";

    public MetaDisplayFrame(LimeXMLDocument limeXMLDocument, long l, StandardSearchView standardSearchView, TableLine tableLine, ResultPanel resultPanel) {
        super(GUIMediator.getAppFrame(), GUIMediator.getStringResource("META_DISPLAY_TITLE"), true);
        this.stdSrchView = standardSearchView;
        this.rp = resultPanel;
        this.line = tableLine;
        this.valid = true;
        if (limeXMLDocument == null) {
            this.valid = false;
        }
        ((Component)this).setSize(500, 500);
        ((Component)this).setLocation(200, 200);
        this.dataPanel = new DisplayPanel(limeXMLDocument, false);
        this.buttonPanel = new JPanel();
        this.downloadButton = new JButton(GUIMediator.getStringResource("META_DISPLAY_DOWNLOAD_BUTTON_LABEL"));
        this.cancelButton = new JButton(GUIMediator.getStringResource("META_DISPLAY_CANCEL_BUTTON_LABEL"));
        this.launchButton = new JButton(GUIMediator.getStringResource("META_DISPLAY_LAUNCH_BUTTON_LABEL"));
        if (l == 0xFFFFFFFFL) {
            this.downloadButton.setEnabled(false);
        }
        this.action = limeXMLDocument.getAction();
        if (this.action == null || this.action.equals("")) {
            this.launchButton.setEnabled(false);
        }
        this.buttonPanel.add(this.launchButton);
        this.buttonPanel.add(this.downloadButton);
        this.buttonPanel.add(this.cancelButton);
        this.launchButton.addActionListener(new LaunchListener());
        this.downloadButton.addActionListener(new DownloadListener());
        this.cancelButton.addActionListener(new CanListener());
        this.scrollPane = new JScrollPane(this.dataPanel);
        this.grandPanel = new JPanel(new BorderLayout());
        this.grandPanel.add((Component)this.buttonPanel, "South");
        this.grandPanel.add((Component)this.scrollPane, "Center");
        Container container = this.getContentPane();
        container.add((Component)this.grandPanel, "Center");
    }

    public boolean isValid() {
        return this.valid;
    }

    private class LaunchListener
    implements ActionListener {
        private LaunchListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                GUIMediator.instance();
                GUIMediator.openURL(MetaDisplayFrame.this.action);
            }
            catch (IOException iOException) {
                return;
            }
        }
    }

    private class DownloadListener
    implements ActionListener {
        private DownloadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            RemoteFileDesc[] remoteFileDescArray = new RemoteFileDesc[]{MetaDisplayFrame.this.line.toRemoteFileDesc(MetaDisplayFrame.this.rp)};
            MetaDisplayFrame.this.stdSrchView.downloadWithOverwritePrompt(remoteFileDescArray);
            MetaDisplayFrame.this.dispose();
        }
    }

    private class CanListener
    implements ActionListener {
        private CanListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MetaDisplayFrame.this.dispose();
        }
    }
}

