/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml.gui;

import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.List;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Window;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.Serializable;
import java.io.StringReader;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class DisplayPanel
extends JPanel {
    private boolean valid = true;
    private static final int pixels = 12;
    private Box docPanel;
    private boolean editable;
    private final int INIT = -1;

    public DisplayPanel(LimeXMLDocument limeXMLDocument, boolean bl) {
        Object object;
        this.setLayout(new FlowLayout(0));
        this.editable = bl;
        this.docPanel = new Box(1);
        String string = "";
        try {
            string = limeXMLDocument.getXMLString();
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            return;
        }
        InputSource inputSource = new InputSource(new StringReader(string));
        Document document = null;
        try {
            object = new DOMParser();
            object.parse(inputSource);
            document = object.getDocument();
        }
        catch (Exception exception) {
            this.valid = false;
            return;
        }
        if (document == null) {
            this.valid = false;
            return;
        }
        object = document.getDocumentElement();
        this.build((Node)object, -1);
        this.add(this.docPanel);
    }

    private void build(Node node, int n) {
        ++n;
        if (!node.hasChildNodes()) {
            this.buildPanel(node, n);
            return;
        }
        if (n != 0) {
            this.buildPanel(node, n);
        }
        List list = LimeXMLUtils.getElements(node.getChildNodes());
        int n2 = list.size();
        int n3 = 0;
        while (n3 < n2) {
            Node node2 = (Node)list.get(n3);
            this.build(node2, n);
            ++n3;
        }
    }

    private void buildPanel(Node node, int n) {
        JTextField jTextField;
        Component component;
        String string = node.getNodeName();
        Element element = (Element)node;
        String string2 = LimeXMLUtils.getText(element.getChildNodes());
        string2 = string2.trim();
        FlowLayout flowLayout = new FlowLayout(0);
        JPanel jPanel = new JPanel(flowLayout);
        int n2 = 0;
        while (n2 <= n) {
            component = Box.createHorizontalStrut(12);
            jPanel.add(component);
            ++n2;
        }
        component = new JLabel(LimeXMLUtils.capitalizeFirst(string));
        jPanel.add(component);
        if (string2 != null && !string2.equals("")) {
            jTextField = new JTextField();
            jTextField.setText(string2);
            jTextField.setEditable(this.editable);
            jPanel.add(jTextField);
        }
        this.docPanel.add(jPanel);
        jTextField = LimeXMLUtils.getAttributes(node.getAttributes());
        int n3 = jTextField.size();
        int n4 = n + 1;
        int n5 = 0;
        while (n5 < n3) {
            boolean bl;
            Node node2 = (Node)jTextField.get(n5);
            String string3 = node2.getNodeName();
            boolean bl2 = n > 0;
            boolean bl3 = string3.toLowerCase().indexOf("identifier") < 0;
            boolean bl4 = bl = string3.toLowerCase().indexOf("schema") < 0;
            if (bl2 || bl3 && bl) {
                Component component2;
                String string4 = node2.getNodeValue();
                JPanel jPanel2 = new JPanel(flowLayout);
                int n6 = 0;
                while (n6 <= n4) {
                    component2 = Box.createHorizontalStrut(12);
                    jPanel2.add(component2);
                    ++n6;
                }
                component2 = new JLabel(LimeXMLUtils.capitalizeFirst(string3));
                jPanel2.add(component2);
                JTextField jTextField2 = new JTextField();
                jTextField2.setText(string4);
                jTextField2.setEditable(this.editable);
                jPanel2.add(jTextField2);
                this.docPanel.add(jPanel2);
            }
            ++n5;
        }
    }

    public static void main(String[] stringArray) {
        Object object;
        Object object2;
        Serializable serializable;
        LimeXMLDocument limeXMLDocument = null;
        try {
            serializable = new File("c:\\home\\etc\\xml", "pers.xml");
            object2 = "";
            object = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader((File)serializable));
            while (object2 != null) {
                object2 = bufferedReader.readLine();
                if (object2 != null) {
                    object = (String)object + (String)object2;
                }
                object = ((String)object).trim();
            }
            limeXMLDocument = new LimeXMLDocument((String)object);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        serializable = new JFrame();
        object2 = new DisplayPanel(limeXMLDocument, false);
        object = ((JFrame)serializable).getContentPane();
        ((Container)object).add((Component)object2);
        ((Window)serializable).show();
    }
}

