/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public class XMLStringUtils {
    public static final String DELIMITER = "__";
    public static final String MAX_ENDING = "_MAX";
    public static final String MIN_ENDING = "_MIN";
    public static final String XML_DOC_START_IDENTIFIER = "<?xml";
    public static final String XML_VERSION_DELIM = "<?xml version=\"1.0\"?>";
    public static final String AUDIO_SCHEMA_TAG = "audio";
    public static final String VIDEO_SCHEMA_TAG = "video";

    public static List split(String string) {
        LinkedList linkedList = new LinkedList();
        int n = 0;
        int n2 = 0;
        while ((n2 = string.indexOf(DELIMITER, n)) != -1) {
            linkedList.add((Object)string.substring(n, n2));
            n = n2 + DELIMITER.length();
        }
        if (!string.endsWith(DELIMITER)) {
            linkedList.add((Object)string.substring(n));
        }
        return linkedList;
    }

    public static List tokenize(String string, String string2) {
        LinkedList linkedList = new LinkedList();
        int n = string.indexOf(string2);
        while (n != -1) {
            int n2 = string.indexOf(string2, n + 1);
            if (n2 == -1) {
                linkedList.add((Object)string.substring(n).trim());
                break;
            }
            linkedList.add((Object)string.substring(n, n2).trim());
            n = n2;
        }
        System.out.println("finished tokenizing");
        return linkedList;
    }

    public static void saveMetaInfo(LimeXMLDocument limeXMLDocument, String string) {
        File file = null;
        try {
            file = SettingsManager.instance().getSaveDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        String string2 = limeXMLDocument.getSchemaURI();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string2);
        Assert.that(limeXMLReplyCollection != null, "Cant add doc to nonexistent collection");
        File file2 = new File(file, string);
        String string3 = "";
        try {
            string3 = file2.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        limeXMLDocument.setIdentifier(string3);
        String string4 = null;
        try {
            string4 = new String(LimeXMLUtils.hashFile(file2));
        }
        catch (Exception exception) {
            return;
        }
        limeXMLReplyCollection.addReply(string4, limeXMLDocument);
        boolean bl = limeXMLReplyCollection.audio ? limeXMLReplyCollection.mp3ToDisk(string) : limeXMLReplyCollection.toDisk("");
        if (!bl) {
            // empty if block
        }
    }
}

