/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLReplyCollection;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.RichQueryHandler;
import com.limegroup.gnutella.xml.SchemaReplyCollectionMapper;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.HashSet;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;

public class MetaFileManager
extends FileManager {
    Object metaLocker = new Object();
    boolean initialized = false;
    private HashMap mp3FileToHash = new HashMap();
    private HashMap nonMP3FileToHash = new HashMap();

    public synchronized Response[] query(QueryRequest queryRequest) {
        String string = queryRequest.getRichQuery();
        Response[] responseArray = super.query(queryRequest);
        this.addAudioMetadata(responseArray);
        RichQueryHandler richQueryHandler = RichQueryHandler.instance();
        Response[] responseArray2 = richQueryHandler.query(string, this);
        if (responseArray2 == null) {
            return responseArray;
        }
        Response[] responseArray3 = this.union(responseArray, responseArray2);
        return responseArray3;
    }

    public synchronized boolean addFileIfShared(File file, LimeXMLDocument[] limeXMLDocumentArray) {
        boolean bl = super.addFileIfShared(file, limeXMLDocumentArray);
        if (bl && limeXMLDocumentArray != null) {
            String string;
            SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
            try {
                string = new String(LimeXMLUtils.hashFile(file));
                if (string == null) {
                    throw new Exception();
                }
                this.writeToMap(file, string, LimeXMLUtils.isMP3File(file));
            }
            catch (Exception exception) {
                return true;
            }
            int n = 0;
            while (limeXMLDocumentArray != null && n < limeXMLDocumentArray.length) {
                try {
                    LimeXMLDocument limeXMLDocument = limeXMLDocumentArray[n];
                    String string2 = limeXMLDocument.getSchemaURI();
                    LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string2);
                    if (limeXMLReplyCollection != null) {
                        limeXMLReplyCollection.addReplyWithCommit(file, string, limeXMLDocument);
                    }
                }
                catch (Exception exception) {
                    // empty catch block
                }
                ++n;
            }
        }
        return bl;
    }

    private void addAudioMetadata(Response[] responseArray) {
        if (responseArray == null) {
            return;
        }
        String string = "http://www.limewire.com/schemas/audio.xsd";
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
        if (limeXMLReplyCollection == null) {
            return;
        }
        int n = responseArray.length;
        int n2 = 0;
        while (n2 < n) {
            block7: {
                FileDesc fileDesc = this.get((int)responseArray[n2].getIndex());
                File file = new File(fileDesc._path);
                String string2 = this.readFromMap(file, true);
                LimeXMLDocument limeXMLDocument = limeXMLReplyCollection.getDocForHash(string2);
                if (limeXMLDocument != null) {
                    String string3 = "";
                    try {
                        string3 = limeXMLDocument.getXMLString();
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                        break block7;
                    }
                    if (string3 != null && !string3.equals("")) {
                        responseArray[n2].setMetadata(string3);
                    }
                }
            }
            ++n2;
        }
    }

    public String readFromMap(Object object, boolean bl) {
        String string = null;
        if (bl) {
            HashMap hashMap = this.mp3FileToHash;
            synchronized (hashMap) {
                string = (String)this.mp3FileToHash.get(object);
            }
            return string;
        }
        HashMap hashMap = this.nonMP3FileToHash;
        synchronized (hashMap) {
            string = (String)this.nonMP3FileToHash.get(object);
        }
        return string;
    }

    public void writeToMap(Object object, Object object2, boolean bl) {
        if (bl) {
            HashMap hashMap = this.mp3FileToHash;
            synchronized (hashMap) {
                this.mp3FileToHash.put(object, object2);
            }
        }
        HashMap hashMap = this.nonMP3FileToHash;
        synchronized (hashMap) {
            this.nonMP3FileToHash.put(object, object2);
        }
    }

    void handleChangedHash(String string, String string2, LimeXMLReplyCollection limeXMLReplyCollection) {
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            LimeXMLDocument limeXMLDocument;
            LimeXMLReplyCollection limeXMLReplyCollection2 = schemaReplyCollectionMapper.getReplyCollection(stringArray[n2]);
            if (limeXMLReplyCollection2 != limeXMLReplyCollection && (limeXMLDocument = limeXMLReplyCollection2.getDocForHash(string)) != null) {
                limeXMLReplyCollection2.removeDoc(string);
                limeXMLReplyCollection2.addReply(string2, limeXMLDocument);
                limeXMLReplyCollection2.toDisk("");
            }
            ++n2;
        }
    }

    protected void loadSettingsBlocking(boolean bl) {
        super.loadSettingsBlocking(bl);
        if (Thread.currentThread().isInterrupted()) {
            return;
        }
        Object object = this.metaLocker;
        synchronized (object) {
            if (!this.initialized) {
                this.createFileToHashMaps();
                SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
                LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
                int n = stringArray.length;
                int n2 = 0;
                while (n2 < n && !Thread.currentThread().isInterrupted()) {
                    String string = LimeXMLSchema.getDisplayString(stringArray[n2]);
                    LimeXMLReplyCollection limeXMLReplyCollection = string.equalsIgnoreCase("audio") ? new LimeXMLReplyCollection(stringArray[n2], (Map)this.mp3FileToHash, (FileManager)this) : new LimeXMLReplyCollection((Map)this.nonMP3FileToHash, stringArray[n2], (FileManager)this);
                    schemaReplyCollectionMapper.add(stringArray[n2], limeXMLReplyCollection);
                    ++n2;
                }
            }
        }
    }

    private Response[] union(Response[] responseArray, Response[] responseArray2) {
        if (responseArray == null) {
            return responseArray2;
        }
        if (responseArray2 == null) {
            return responseArray;
        }
        HashSet hashSet = new HashSet();
        int n = 0;
        while (n < responseArray2.length) {
            if (responseArray2[n] != null) {
                hashSet.add((Object)responseArray2[n]);
            }
            ++n;
        }
        int n2 = 0;
        while (n2 < responseArray.length) {
            hashSet.add((Object)responseArray[n2]);
            ++n2;
        }
        int n3 = hashSet.size();
        Iterator iterator = hashSet.iterator();
        hashSet = null;
        Response[] responseArray3 = new Response[n3];
        int n4 = 0;
        while (n4 < n3) {
            Response response;
            responseArray3[n4] = response = (Response)iterator.next();
            ++n4;
        }
        return responseArray3;
    }

    private void createFileToHashMaps() {
        SettingsManager settingsManager = SettingsManager.instance();
        ArrayList arrayList = new ArrayList((Collection)Arrays.asList((Object[])settingsManager.getDirectories()));
        int n = 0;
        while (n < arrayList.size()) {
            Object object;
            File file = (File)arrayList.get(n);
            ++n;
            String[] stringArray = file.list();
            int n2 = stringArray.length;
            int n3 = 0;
            while (n3 < n2) {
                object = new File(file, stringArray[n3]);
                if (((File)object).isDirectory()) {
                    arrayList.add(object);
                }
                ++n3;
            }
            object = this.getSharedFiles(file);
            int n4 = ((File[])object).length;
            int n5 = 0;
            while (n5 < n4) {
                block6: {
                    String string = "";
                    String string2 = "";
                    try {
                        string = ((File)object[n5]).getCanonicalPath();
                        string2 = new String(LimeXMLUtils.hashFile((File)object[n5]));
                    }
                    catch (Exception exception) {
                        break block6;
                    }
                    this.writeToMap(object[n5], string2, LimeXMLUtils.isMP3File(string));
                }
                ++n5;
            }
        }
    }

    public List getKeyWords() {
        List list = super.getKeyWords();
        if (list == null) {
            list = new ArrayList();
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(stringArray[n2]);
            if (limeXMLReplyCollection != null) {
                list.addAll((Collection)limeXMLReplyCollection.getKeyWords());
            }
            ++n2;
        }
        return list;
    }

    public List getIndivisibleKeyWords() {
        List list = super.getIndivisibleKeyWords();
        if (list == null) {
            list = new ArrayList();
        }
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                list.add((Object)stringArray[n]);
            }
            ++n;
        }
        return list;
    }

    public LimeXMLDocument getDocument(String string, File file) {
        String string2 = null;
        string2 = this.readFromMap(file, true);
        if (string2 == null) {
            string2 = this.readFromMap(file, false);
        }
        if (string2 == null) {
            return null;
        }
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(string);
        if (limeXMLReplyCollection == null) {
            return null;
        }
        return limeXMLReplyCollection.getDocForHash(string2);
    }

    private void showXMLData() {
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        SchemaReplyCollectionMapper schemaReplyCollectionMapper = SchemaReplyCollectionMapper.instance();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            System.out.println("Schema : " + stringArray[n2]);
            System.out.println("-----------------------");
            LimeXMLReplyCollection limeXMLReplyCollection = schemaReplyCollectionMapper.getReplyCollection(stringArray[n2]);
            if (limeXMLReplyCollection == null || limeXMLReplyCollection.getCount() < 1) {
                System.out.println("No docs corresponding to this schema ");
            } else {
                List list = limeXMLReplyCollection.getCollectionList();
                int n3 = list.size();
                int n4 = 0;
                while (n4 < n3) {
                    System.out.println("Doc number " + n4);
                    System.out.println("-----------------------");
                    LimeXMLDocument limeXMLDocument = (LimeXMLDocument)list.get(n4);
                    List list2 = limeXMLDocument.getNameValueList();
                    int n5 = list2.size();
                    int n6 = 0;
                    while (n6 < n5) {
                        NameValue nameValue = (NameValue)list2.get(n6);
                        System.out.println("Name " + nameValue.getName());
                        System.out.println("Value " + nameValue.getValue());
                        ++n6;
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }
}

