/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.Set;
import java.io.File;
import java.io.IOException;

public class LimeXMLSchemaRepository {
    private Map _uriSchemaMap = new HashMap();
    private static LimeXMLSchemaRepository _instance = new LimeXMLSchemaRepository();

    private LimeXMLSchemaRepository() {
        this.initialize();
    }

    protected void initialize() {
        File[] fileArray = LimeXMLProperties.instance().getAllXMLSchemaFiles();
        if (fileArray != null) {
            int n = 0;
            while (n < fileArray.length) {
                try {
                    LimeXMLSchema limeXMLSchema = new LimeXMLSchema(fileArray[n]);
                    this._uriSchemaMap.put((Object)limeXMLSchema.getSchemaURI(), (Object)limeXMLSchema);
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
                ++n;
            }
        }
    }

    public static LimeXMLSchemaRepository instance() {
        return _instance;
    }

    public LimeXMLSchema getSchema(String string) {
        Map map = this._uriSchemaMap;
        synchronized (map) {
            LimeXMLSchema limeXMLSchema = (LimeXMLSchema)this._uriSchemaMap.get((Object)string);
            return limeXMLSchema;
        }
    }

    public String[] getAvailableSchemaURIs() {
        Object[] objectArray;
        Map map = this._uriSchemaMap;
        synchronized (map) {
            Set set = this._uriSchemaMap.keySet();
            objectArray = (String[])set.toArray((Object[])new String[0]);
        }
        Arrays.sort((Object[])objectArray, (Comparator)new Comparator(){

            public int compare(Object object, Object object2) {
                String string = (String)object;
                String string2 = (String)object2;
                return string.compareTo(string2);
            }

            public boolean equals(Object object) {
                return this.equals(object);
            }
        });
        return objectArray;
    }

    public static void main(String[] stringArray) {
        LimeXMLSchemaRepository.Test();
    }

    private static void Test() {
        String[] stringArray = LimeXMLSchemaRepository.instance().getAvailableSchemaURIs();
        int n = 0;
        while (n < stringArray.length) {
            System.out.println("schema = " + stringArray[n]);
            ++n;
        }
    }
}

