/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.mp3.ID3Editor;
import com.limegroup.gnutella.mp3.ID3Reader;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collection;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Hashtable;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

public class LimeXMLReplyCollection {
    private String schemaURI;
    private HashMap mainMap;
    public boolean audio = false;
    private ID3Editor editor = null;
    private List replyDocs = null;
    private File dataFile = null;
    private int count;
    private Hashtable outMap = null;
    private String changedHash = null;
    private MetaFileManager metaFileManager = null;
    private Object mainMapLock = new Object();

    public LimeXMLReplyCollection(String string, Map map, FileManager fileManager) {
        Object object;
        Object object2;
        Iterator iterator;
        this.audio = true;
        this.schemaURI = string;
        this.metaFileManager = (MetaFileManager)fileManager;
        MapSerializer mapSerializer = this.initialize(string);
        Object object3 = mapSerializer == null ? new HashMap() : mapSerializer.getMap();
        ID3Reader iD3Reader = new ID3Reader();
        Map map2 = map;
        synchronized (map2) {
            iterator = map.keySet().iterator();
            object2 = null;
            while (iterator.hasNext()) {
                boolean bl = false;
                object = (File)iterator.next();
                String string2 = this.metaFileManager.readFromMap(object, this.audio);
                String string3 = (String)object3.remove((Object)string2);
                if (string3 == null || string3.equals("")) {
                    bl = true;
                }
                try {
                    String string4 = iD3Reader.readDocument((File)object, bl);
                    if (!bl) {
                        string4 = this.joinAudioXMLStrings(string4, string3);
                    }
                    object2 = new LimeXMLDocument(string4);
                }
                catch (Exception exception) {
                    continue;
                }
                if (object2 == null) continue;
                this.addReply(string2, (LimeXMLDocument)object2);
            }
        }
        iterator = object3.keySet().iterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            String string5 = (String)object3.get(object2);
            object = null;
            try {
                object = new LimeXMLDocument(string5);
            }
            catch (Exception exception) {
                continue;
            }
            if (object == null) continue;
            this.addReply((String)object2, (LimeXMLDocument)object);
        }
        this.checkDocuments(map, this.audio);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected List getKeyWords() {
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        Object object = this.mainMapLock;
        synchronized (object) {
            iterator = this.mainMap.values().iterator();
        }
        while (iterator.hasNext()) {
            LimeXMLDocument limeXMLDocument = (LimeXMLDocument)iterator.next();
            arrayList.addAll((Collection)limeXMLDocument.getKeyWords());
        }
        return arrayList;
    }

    public LimeXMLReplyCollection(Map map, String string, FileManager fileManager) {
        this.audio = false;
        this.schemaURI = string;
        this.metaFileManager = (MetaFileManager)fileManager;
        MapSerializer mapSerializer = this.initialize(string);
        Object object = mapSerializer == null ? new HashMap() : mapSerializer.getMap();
        Iterator iterator = null;
        if (object != null && object.keySet() != null) {
            iterator = object.keySet().iterator();
        }
        while (iterator != null && iterator.hasNext()) {
            boolean bl = true;
            String string2 = (String)iterator.next();
            String string3 = (String)object.get((Object)string2);
            LimeXMLDocument limeXMLDocument = null;
            try {
                limeXMLDocument = new LimeXMLDocument(string3);
            }
            catch (Exception exception) {
                bl = false;
            }
            if (!bl) continue;
            this.addReply(string2, limeXMLDocument);
        }
        if (map != null) {
            this.checkDocuments(map, false);
        }
    }

    /*
     * Unable to fully structure code
     */
    private void checkDocuments(Map var1_1, boolean var2_2) {
        var3_3 = var1_1;
        synchronized (var3_3) {
            var4_4 = null;
            if (var1_1.keySet() != null) {
                var4_4 = var1_1.keySet().iterator();
            }
            if (var4_4 != null) ** GOTO lbl35
            return;
lbl-1000:
            // 1 sources

            {
                var5_5 = (File)var4_4.next();
                var6_6 = this.metaFileManager.readFromMap(var5_5, var2_2);
                var8_8 = this.mainMapLock;
                synchronized (var8_8) {
                    var7_7 = (LimeXMLDocument)this.mainMap.get((Object)var6_6);
                }
                if (var7_7 == null) continue;
                var9_9 = null;
                try {
                    var9_9 = var5_5.getCanonicalPath();
                }
                catch (IOException var10_12) {
                    var11_13 = this.mainMapLock;
                    synchronized (var11_13) {
                        this.mainMap.remove((Object)var6_6);
                    }
                }
                var10_11 = var7_7.getIdentifier();
                if (var9_9.equalsIgnoreCase(var10_11)) continue;
                var7_7.setIdentifier(var9_9);
lbl35:
                // 4 sources

                ** while (var4_4.hasNext())
            }
lbl36:
            // 1 sources

        }
    }

    private MapSerializer initialize(String string) {
        String string2 = LimeXMLSchema.getDisplayString(string) + ".sxml";
        LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
        String string3 = limeXMLProperties.getXMLDocsDir();
        this.dataFile = new File(string3, string2);
        this.mainMap = new HashMap();
        MapSerializer mapSerializer = null;
        try {
            mapSerializer = new MapSerializer(this.dataFile);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return mapSerializer;
    }

    private String joinAudioXMLStrings(String string, String string2) {
        int n = string2.lastIndexOf("></audio>");
        String string3 = string2.substring(0, n);
        String string4 = string2.substring(n);
        return string3 + string + string4;
    }

    public String getSchemaURI() {
        return this.schemaURI;
    }

    public void addReply(String string, LimeXMLDocument limeXMLDocument) {
        Object object = this.mainMapLock;
        synchronized (object) {
            this.mainMap.put((Object)string, (Object)limeXMLDocument);
        }
        this.replyDocs = null;
        ++this.count;
    }

    public void addReplyWithCommit(File file, String string, LimeXMLDocument limeXMLDocument) {
        String string2 = "";
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        limeXMLDocument.setIdentifier(string2);
        this.addReply(string, limeXMLDocument);
        try {
            if (this.audio) {
                this.mp3ToDisk(file.getCanonicalPath());
            } else {
                this.toDisk("");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public int getCount() {
        return this.count;
    }

    public LimeXMLDocument getDocForHash(String string) {
        Object object = this.mainMapLock;
        synchronized (object) {
            LimeXMLDocument limeXMLDocument = (LimeXMLDocument)this.mainMap.get((Object)string);
            return limeXMLDocument;
        }
    }

    public List getCollectionList() {
        if (this.replyDocs != null) {
            return this.replyDocs;
        }
        this.replyDocs = new ArrayList();
        Object object = this.mainMapLock;
        synchronized (object) {
            Iterator iterator = this.mainMap.keySet().iterator();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                Object object3 = this.mainMap.get(object2);
                this.replyDocs.add(object3);
            }
        }
        return this.replyDocs;
    }

    public List getMatchingReplies(LimeXMLDocument limeXMLDocument) {
        ArrayList arrayList;
        Object object = this.mainMapLock;
        synchronized (object) {
            Iterator iterator = this.mainMap.keySet().iterator();
            arrayList = new ArrayList();
            while (iterator.hasNext()) {
                Object object2 = iterator.next();
                LimeXMLDocument limeXMLDocument2 = (LimeXMLDocument)this.mainMap.get(object2);
                boolean bl = LimeXMLUtils.match(limeXMLDocument2, limeXMLDocument);
                if (!bl) continue;
                arrayList.add((Object)limeXMLDocument2);
                bl = false;
            }
        }
        return arrayList;
    }

    public void replaceDoc(Object object, LimeXMLDocument limeXMLDocument) {
        Object object2 = this.mainMapLock;
        synchronized (object2) {
            this.mainMap.put(object, (Object)limeXMLDocument);
        }
        this.replyDocs = null;
    }

    public boolean removeDoc(String string) {
        boolean bl;
        Object object;
        this.replyDocs = null;
        Object object2 = this.mainMapLock;
        synchronized (object2) {
            object = this.mainMap.remove((Object)string);
            bl = object != null;
        }
        boolean bl2 = false;
        if (bl) {
            bl2 = this.toDisk("");
        }
        if (!bl2 && bl) {
            Object object3 = this.mainMapLock;
            synchronized (object3) {
                this.mainMap.put((Object)string, object);
            }
        } else if (bl && bl2) {
            return true;
        }
        return false;
    }

    public boolean toDisk(String string) {
        this.replyDocs = null;
        Object object = this.mainMapLock;
        synchronized (object) {
            Iterator iterator = this.mainMap.keySet().iterator();
            this.outMap = new Hashtable();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                LimeXMLDocument limeXMLDocument = (LimeXMLDocument)this.mainMap.get((Object)string2);
                String string3 = "";
                try {
                    string3 = limeXMLDocument.getXMLStringWithIdentifier();
                }
                catch (SchemaNotFoundException schemaNotFoundException) {
                    continue;
                }
                if (this.audio) {
                    String string4 = limeXMLDocument.getIdentifier();
                    ID3Editor iD3Editor = new ID3Editor();
                    boolean bl = LimeXMLUtils.isMP3File(string4);
                    if (bl) {
                        string3 = iD3Editor.removeID3Tags(string3);
                        if (string4.equals(string)) {
                            this.editor = iD3Editor;
                            this.changedHash = string2;
                        }
                    }
                }
                this.outMap.put((Object)string2, (Object)string3);
            }
        }
        if (!this.audio) {
            return this.write();
        }
        return true;
    }

    private boolean write() {
        Object object;
        if (this.dataFile == null) {
            object = LimeXMLSchema.getDisplayString(this.schemaURI) + ".sxml";
            LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
            String string = limeXMLProperties.getXMLDocsDir();
            this.dataFile = new File(string, (String)object);
        }
        try {
            object = new MapSerializer(this.dataFile, this.outMap);
            this.outMap = null;
            ((MapSerializer)object).commit();
        }
        catch (Exception exception) {
            return false;
        }
        return true;
    }

    public boolean mp3ToDisk(String string) {
        boolean bl = LimeXMLUtils.isMP3File(string);
        boolean bl2 = false;
        boolean bl3 = false;
        this.toDisk(string);
        if (this.editor != null) {
            Object object;
            bl3 = this.editor.writeID3DataToDisk(string);
            File file = new File(string);
            String string2 = null;
            try {
                string2 = new String(LimeXMLUtils.hashFile(file));
            }
            catch (Exception exception) {
                return false;
            }
            Object object2 = this.mainMapLock;
            synchronized (object2) {
                object = this.mainMap.remove((Object)this.changedHash);
                this.mainMap.put((Object)string2, object);
            }
            this.metaFileManager.writeToMap(file, string2, bl);
            this.metaFileManager.handleChangedHash(this.changedHash, string2, this);
            object = this.outMap.remove((Object)this.changedHash);
            this.outMap.put((Object)string2, object);
        } else {
            bl3 = true;
        }
        bl2 = this.write();
        this.outMap = null;
        this.changedHash = null;
        this.editor = null;
        return bl2 && bl3;
    }

    public static void testMapSerializer(String[] stringArray) throws Exception {
        MapSerializer mapSerializer = new MapSerializer(new File(stringArray[0]));
        Map map = mapSerializer.getMap();
        System.out.println("" + map);
        int n = 1;
        while (n < stringArray.length) {
            try {
                map.put((Object)stringArray[n], (Object)stringArray[n + 1]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            n += 2;
        }
        mapSerializer.commit();
    }

    public static void main(String[] stringArray) throws Exception {
        LimeXMLReplyCollection.testMapSerializer(stringArray);
    }

    public static class MapSerializer {
        private File _backingStoreFile;
        private Hashtable _hashMap;

        public MapSerializer(File file) throws Exception {
            this._backingStoreFile = file;
            if (this._backingStoreFile.isDirectory()) {
                throw new Exception();
            }
            if (this._backingStoreFile.exists()) {
                this.deserializeFromFile();
            } else {
                this._hashMap = new Hashtable();
            }
        }

        public MapSerializer(File file, Hashtable hashtable) throws Exception {
            this._backingStoreFile = file;
            this._hashMap = hashtable;
            if (this._backingStoreFile.isDirectory()) {
                throw new Exception();
            }
        }

        private void deserializeFromFile() throws Exception {
            FileInputStream fileInputStream = new FileInputStream(this._backingStoreFile);
            ObjectInputStream objectInputStream = new ObjectInputStream(fileInputStream);
            this._hashMap = (Hashtable)objectInputStream.readObject();
            fileInputStream.close();
        }

        public void commit() throws Exception {
            this.serializeToFile();
        }

        private void serializeToFile() throws Exception {
            FileOutputStream fileOutputStream = new FileOutputStream(this._backingStoreFile);
            ObjectOutputStream objectOutputStream = new ObjectOutputStream(fileOutputStream);
            objectOutputStream.writeObject(this._hashMap);
            fileOutputStream.close();
        }

        public Map getMap() {
            return this._hashMap;
        }
    }
}

