/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.SettingsManager;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.util.Properties;

public class LimeXMLProperties {
    public static final long DEFAULT_NONFILE_INDEX = 0xFFFFFFFFL;
    private Properties _properties = new Properties();
    private static LimeXMLProperties _instance = new LimeXMLProperties();
    private static final String XML_PROPS_FILENAME = "xml.props";
    private static final String XML_SCHEMA_DIR = "XML_SCHEMA_DIR";
    private static final String XML_IMAGES_DIR = "XML_IMAGES_DIR";
    private static final String XML_DOCS_DIR = "XML_DOCS_DIR";
    private static final String XML_DISPLAY_PROPS_DIR = "XML_DISPLAY_PROPS_DIR";
    private static final String XML_SCHEMA_DIR_DEF = "xml" + File.separator + "schemas" + File.separator;
    private static final String XML_IMAGES_DIR_DEF = "xml" + File.separator + "misc" + File.separator;
    private static final String XML_DOCS_DIR_DEF = "xml" + File.separator + "data" + File.separator;
    private static final String XML_DISPLAY_PROPS_DIR_DEF = "xml" + File.separator + "display" + File.separator;
    private static final String MAX_JDBC_XML_RESULTS = "MAX_JDBC_XML_RESULTS";
    private static final int MAX_JDBC_XML_RESULTS_DEF = 250;
    private static final String SCHEMA_TRANSFORMATION_DATA_MAP_FILE = "SCHEMA_TRANSFORMATION_DATA_MAP_FILE";
    private static final String SCHEMA_TRANSFORMATION_DATA_MAP_FILE_DEF = "STDataMap.dat";
    private static final String HTTP_MAPPING_FILE = "HTTP_MAPPING_FILE";
    private static final String HTTP_MAPPING_FILE_DEF = "httpmapping.xml";
    private static final String DATABASE_MAPPING_FILE = "DATABASE_MAPPING_FILE";
    private static final String DATABASE_MAPPING_FILE_DEF = "databasemapping.xml";
    private static final String FEED_PROPS_FILE = "FEED_PROPS_FILE";
    private static final String FEED_PROPS_FILE_DEF = "feedreceiverprops.xml";
    private static final String DIRECT_MAPPING_FILE = "DIRECT_MAPPING_FILE";
    private static final String DIRECT_MAPPING_FILE_DEF = "directmapping.xml";
    private static final String KEYWORD_LIST_FILE = "KEYWORD_LIST_FILE";
    private static final String KEYWORD_LIST_FILE_DEF = "keywords.list";
    private static final String NUM_QUERY_DISPATCHER_THREADS = "NUM_QUERY_DISPATCHER_THREADS";
    private static final int NUM_QUERY_DISPATCHER_THREADS_DEF = 50;

    private LimeXMLProperties() {
        this.loadProperties();
    }

    protected void loadProperties() {
        try {
            this._properties.load(new FileInputStream(LimeXMLProperties.getPath() + XML_PROPS_FILENAME));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static LimeXMLProperties instance() {
        return _instance;
    }

    public String getXMLSchemaDir() {
        String string = this._properties.getProperty(XML_SCHEMA_DIR, XML_SCHEMA_DIR_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getXMLImagesDir() {
        String string = this._properties.getProperty(XML_IMAGES_DIR, XML_IMAGES_DIR_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getXMLDocsDir() {
        String string = this._properties.getProperty(XML_DOCS_DIR, XML_DOCS_DIR_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getXMLDisplayPropsDir() {
        String string = this._properties.getProperty(XML_DISPLAY_PROPS_DIR, XML_DISPLAY_PROPS_DIR_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getSchemaTransformationDataMapFile() {
        String string = this._properties.getProperty(SCHEMA_TRANSFORMATION_DATA_MAP_FILE, SCHEMA_TRANSFORMATION_DATA_MAP_FILE_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getHTTPMappingFile() {
        String string = this._properties.getProperty(HTTP_MAPPING_FILE, HTTP_MAPPING_FILE_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getDatabaseMappingFile() {
        String string = this._properties.getProperty(DATABASE_MAPPING_FILE, DATABASE_MAPPING_FILE_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getFeedPropsFile() {
        String string = this._properties.getProperty(FEED_PROPS_FILE, FEED_PROPS_FILE_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public int getNumQueryDispatcherThreads() {
        try {
            return Integer.parseInt(this._properties.getProperty(NUM_QUERY_DISPATCHER_THREADS, "50"));
        }
        catch (Exception exception) {
            return 50;
        }
    }

    public String getDirectMappingFile() {
        String string = this._properties.getProperty(DIRECT_MAPPING_FILE, DIRECT_MAPPING_FILE_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public String getKeywordListFile() {
        String string = this._properties.getProperty(KEYWORD_LIST_FILE, KEYWORD_LIST_FILE_DEF);
        return LimeXMLProperties.getPath() + string;
    }

    public int getMaxJDBCXMLResults() {
        String string = this._properties.getProperty(MAX_JDBC_XML_RESULTS, "250 ");
        try {
            return Integer.parseInt(string);
        }
        catch (Exception exception) {
            return 250;
        }
    }

    public File[] getAllXMLSchemaFiles() {
        File file = new File(this.getXMLSchemaDir());
        String[] stringArray = file.list(new FilenameFilter(){

            public boolean accept(File file, String string) {
                return string.endsWith(".xsd");
            }
        });
        if (stringArray == null || stringArray.length == 0) {
            return new File[0];
        }
        int n = stringArray.length;
        File[] fileArray = new File[n];
        int n2 = 0;
        while (n2 < n) {
            fileArray[n2] = new File(file, stringArray[n2]);
            ++n2;
        }
        return fileArray;
    }

    static String getPath() {
        String string = System.getProperty("LIME_HOME");
        if (string == null || string.trim().equals("")) {
            return SettingsManager.instance().getPath() + "lib" + File.separator;
        }
        return string + "lib" + File.separator;
    }
}

