/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.xml;

import com.limegroup.gnutella.util.NameValue;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaNotFoundException;
import com.limegroup.gnutella.xml.XMLStringUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.TreeMap;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.StringTokenizer;
import org.apache.xerces.parsers.DOMParser;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class LimeXMLDocument {
    private Map fieldToValue = new TreeMap(new Comparator(){

        public int compare(Object object, Object object2) {
            String string = (String)object;
            String string2 = (String)object2;
            return string.compareTo(string2);
        }

        public boolean equals(Object object) {
            return this.equals(object);
        }
    });
    protected String schemaUri;
    protected String identifier;
    protected String action = "";

    public void setIdentifier(String string) {
        this.identifier = string;
    }

    public LimeXMLDocument(String string) throws SAXException, SchemaNotFoundException, IOException {
        InputSource inputSource = new InputSource(new StringReader(string));
        this.initialize(inputSource);
    }

    public LimeXMLDocument(Node node, Node node2) {
        try {
            this.grabDocInfo(node2, true);
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        try {
            this.grabDocInfo(node, false);
        }
        catch (SchemaNotFoundException schemaNotFoundException) {
            // empty catch block
        }
        this.createMap(node, node2.getNodeName());
    }

    public LimeXMLDocument(List list, String string) {
        this.schemaUri = string;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            NameValue nameValue = (NameValue)iterator.next();
            this.fieldToValue.put((Object)nameValue.getName().trim(), nameValue.getValue());
        }
    }

    private void initialize(InputSource inputSource) throws SchemaNotFoundException, IOException, SAXException {
        DOMParser dOMParser = new DOMParser();
        Document document = null;
        dOMParser.parse(inputSource);
        document = dOMParser.getDocument();
        Element element = document.getDocumentElement();
        this.grabDocInfo(element, true);
        Node node = element.getFirstChild();
        this.grabDocInfo(node, false);
        this.createMap(element);
    }

    private void grabDocInfo(Node node, boolean bl) throws SchemaNotFoundException {
        List list = LimeXMLUtils.getAttributes(node.getAttributes());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Object object;
            Node node2 = (Node)list.get(n2);
            String string = node2.getNodeName();
            String string2 = string.toLowerCase();
            if (string2.indexOf("schemalocation") >= 0) {
                this.schemaUri = node2.getNodeValue();
            } else if (string2.indexOf("identifier") >= 0) {
                this.identifier = node2.getNodeValue();
                object = (Element)node;
                object.removeAttribute(string);
            } else if (string2.indexOf("action") >= 0) {
                this.action = node2.getNodeValue();
            } else if (string2.indexOf("index") >= 0) {
                object = (Element)node;
                object.removeAttribute(string);
            } else if (bl) {
                object = node.getNodeName() + "__" + node2.getNodeName() + "__";
                this.fieldToValue.put((Object)((String)object).trim(), (Object)node2.getNodeValue().trim());
            }
            ++n2;
        }
        if (this.schemaUri == null) {
            throw new SchemaNotFoundException();
        }
    }

    public List getKeyWords() {
        ArrayList arrayList = new ArrayList();
        Iterator iterator = this.fieldToValue.values().iterator();
        while (iterator.hasNext()) {
            boolean bl = true;
            String string = (String)iterator.next();
            try {
                double d = new Double(string);
            }
            catch (NumberFormatException numberFormatException) {
                bl = false;
            }
            if (bl) continue;
            arrayList.add((Object)string);
        }
        return arrayList;
    }

    private void createMap(Node node) {
        this.doAllChildren(node, "");
    }

    private void createMap(Node node, String string) {
        this.doAllChildren(node, string);
    }

    private void doAllChildren(Node node, String string) {
        if (!node.hasChildNodes()) {
            this.doEntry(node, string);
            return;
        }
        String string2 = this.doEntry(node, string);
        List list = LimeXMLUtils.getElements(node.getChildNodes());
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            Node node2 = (Node)list.get(n2);
            this.doAllChildren(node2, string2);
            ++n2;
        }
    }

    private String doEntry(Node node, String string) {
        String string2 = !string.equals("") ? string + "__" + node.getNodeName() : node.getNodeName();
        Element element = (Element)node;
        String string3 = LimeXMLUtils.getText(element.getChildNodes());
        if (string3 != null && !string3.equals("")) {
            this.fieldToValue.put((Object)string2.trim(), (Object)string3.trim());
        }
        if (!string.equals("")) {
            List list = LimeXMLUtils.getAttributes(node.getAttributes());
            int n = list.size();
            int n2 = 0;
            while (n2 < n) {
                Node node2 = (Node)list.get(n2);
                String string4 = node2.getNodeName();
                String string5 = string2 + "__" + string4 + "__";
                String string6 = node2.getNodeValue();
                this.fieldToValue.put((Object)string5.trim(), (Object)string6.trim());
                ++n2;
            }
        }
        return string2;
    }

    public String getSchemaURI() {
        return this.schemaUri;
    }

    public void setSchemaURI(String string) {
        this.schemaUri = string;
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public String getAction() {
        return this.action;
    }

    public List getNameValueList() {
        int n = this.fieldToValue.size();
        Iterator iterator = this.fieldToValue.keySet().iterator();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            String string = (String)iterator.next();
            String string2 = (String)this.fieldToValue.get((Object)string);
            NameValue nameValue = new NameValue(string, string2);
            arrayList.add((Object)nameValue);
            ++n2;
        }
        return arrayList;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List getOrderedNameValueList() throws SchemaNotFoundException {
        LinkedList linkedList = new LinkedList();
        if (this.schemaUri == null) throw new SchemaNotFoundException();
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        LimeXMLSchema limeXMLSchema = limeXMLSchemaRepository.getSchema(this.schemaUri);
        if (limeXMLSchema == null) throw new SchemaNotFoundException();
        String[] stringArray = limeXMLSchema.getCanonicalizedFieldNames();
        int n = 0;
        while (n < stringArray.length) {
            Object object = this.fieldToValue.get((Object)stringArray[n].trim());
            if (object != null) {
                linkedList.add((Object)new NameValue(stringArray[n].trim(), object));
            }
            ++n;
        }
        return linkedList;
    }

    public String getValue(String string) {
        string = string.trim();
        return (String)this.fieldToValue.get((Object)string);
    }

    public String getXMLString() throws SchemaNotFoundException {
        String string = LimeXMLDocument.constructXML(this.getOrderedNameValueList(), this.schemaUri);
        return string;
    }

    public String getXMLStringWithIdentifier() throws SchemaNotFoundException {
        String string = LimeXMLDocument.constructXML(this.getOrderedNameValueList(), this.schemaUri);
        int n = string.indexOf(">");
        if (n < 0) {
            return string;
        }
        ++n;
        n = string.indexOf(">", n);
        ++n;
        n = string.indexOf(">", n);
        String string2 = string.substring(0, n);
        String string3 = string.substring(n);
        String string4 = " identifier=\"" + this.identifier + "\"";
        string = string2 + string4 + string3;
        return string;
    }

    public static void main(String[] stringArray) {
        String string;
        Runtime runtime = Runtime.getRuntime();
        long l = runtime.totalMemory() - runtime.freeMemory();
        System.out.println("Sumeet : Used memory is " + l);
        File file = new File("C:/home/etc/xml", "junk.xml");
        LimeXMLDocument limeXMLDocument = null;
        try {
            string = "";
            String string2 = "";
            BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
            while (string != null) {
                string = bufferedReader.readLine();
                if (string != null) {
                    string2 = string2 + string;
                }
                string2 = string2.trim();
            }
            limeXMLDocument = new LimeXMLDocument(string2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        string = limeXMLDocument.getNameValueList();
        int n = string.size();
        int n2 = 0;
        while (n2 < n) {
            NameValue nameValue = (NameValue)string.get(n2);
            String string3 = nameValue.getName();
            String string4 = (String)nameValue.getValue();
            System.out.println("Sumeet : name " + string3);
            System.out.println("Sumeet : value " + string4);
            ++n2;
        }
    }

    public static String constructXML(List list, String string) {
        String string2;
        string = LimeXMLUtils.encodeXML(string);
        int n = list.size();
        String string3 = "";
        String string4 = "";
        String string5 = "";
        ArrayList arrayList = new ArrayList();
        boolean bl = false;
        if (list.size() == 0) {
            return "";
        }
        NameValue nameValue = (NameValue)list.get(0);
        String string6 = nameValue.getName();
        boolean bl2 = string6.endsWith("__");
        StringTokenizer stringTokenizer = new StringTokenizer(string6, "__");
        int n2 = stringTokenizer.countTokens();
        boolean bl3 = bl2 && n2 == 2;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            NameValue nameValue2 = (NameValue)list.get(n3);
            String string7 = nameValue2.getName();
            string2 = LimeXMLUtils.encodeXML((String)nameValue2.getValue());
            List list2 = XMLStringUtils.split(string7);
            int n5 = 0;
            List list3 = null;
            boolean bl4 = false;
            if (string7.endsWith("__")) {
                bl4 = true;
            }
            if (bl && !bl4) {
                string3 = string3 + ">";
            }
            if (n3 > 0) {
                list3 = XMLStringUtils.split(string5);
                n5 = LimeXMLDocument.getCommonCount(list2, list3);
            }
            int n6 = list2.size();
            int n7 = arrayList.size();
            if (n5 < n7) {
                n4 = n7 - n5;
                int n8 = n7 - 1;
                int n9 = 0;
                while (n9 < n4) {
                    String string8 = (String)arrayList.remove(n8);
                    --n8;
                    string4 = string4 + "</" + string8 + ">";
                    ++n9;
                }
            }
            if (!string4.equals("")) {
                string3 = string3 + string4;
                string4 = "";
            }
            n4 = n5;
            while (n4 < n6 - 1) {
                String string9 = (String)list2.get(n4);
                string3 = string3 + "<" + string9;
                if (n3 == 0 && n4 == 0 && !bl3) {
                    string3 = string3 + " xsi:noNamespaceSchemaLocation=\"" + string + "\">";
                } else if (n3 == 0 && n4 == 0 && bl3) {
                    string3 = string3 + " xsi:noNamespaceSchemaLocation=\"" + string + "\"";
                }
                if (!(bl4 || n4 <= 0 && n3 <= 0)) {
                    string3 = string3 + ">";
                }
                arrayList.add((Object)string9);
                ++n4;
            }
            String string10 = (String)list2.get(n6 - 1);
            if (!bl4) {
                string3 = string3 + "<" + string10 + ">" + string2 + "</" + string10 + ">";
            } else {
                string3 = string3 + " " + string10 + "=\"" + string2 + "\"";
                if (n3 == n - 1) {
                    string3 = string3 + ">";
                }
            }
            string5 = string7;
            bl = bl4;
            ++n3;
        }
        int n10 = arrayList.size();
        int n11 = n10 - 1;
        while (n11 >= 0) {
            string2 = (String)arrayList.remove(n11);
            string3 = string3 + "</" + string2 + ">";
            --n11;
        }
        string3 = "<?xml version=\"1.0\"?>" + string3;
        return string3;
    }

    private static int getCommonCount(List list, List list2) {
        int n = 0;
        int n2 = list.size() < list2.size() ? list.size() : list2.size();
        int n3 = 0;
        while (n3 < n2) {
            if (!list.get(n3).equals(list2.get(n3))) break;
            ++n;
            ++n3;
        }
        return n;
    }
}

