/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.util.TrieEdge;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;
import com.sun.java.util.collections.Vector;

final class TrieNode {
    private Object value = null;
    private Vector children = new Vector(0);

    public TrieNode() {
    }

    public TrieNode(Object object) {
        this.value = object;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object object) {
        this.value = object;
    }

    private final TrieEdge get(int n) {
        return (TrieEdge)this.children.get(n);
    }

    private final int search(char c, boolean bl) {
        int n = 0;
        int n2 = this.children.size() - 1;
        while (n <= n2) {
            int n3 = (n + n2) / 2;
            char c2 = this.get(n3).getLabelStart();
            if (c2 < c) {
                n = n3 + 1;
                continue;
            }
            if (c < c2) {
                n2 = n3 - 1;
                continue;
            }
            return n3;
        }
        if (bl) {
            return -1;
        }
        return n2;
    }

    public TrieEdge get(char c) {
        int n = this.search(c, true);
        if (n < 0) {
            return null;
        }
        TrieEdge trieEdge = this.get(n);
        Assert.that(trieEdge.getLabelStart() == c);
        return trieEdge;
    }

    public void put(String string, TrieNode trieNode) {
        char c = string.charAt(0);
        int n = this.search(c, false);
        if (n >= 0) {
            Assert.that(this.get(n).getLabelStart() != c, "Precondition of TrieNode.put violated.");
        }
        this.children.add(n + 1, (Object)new TrieEdge(string, trieNode));
    }

    public boolean remove(char c) {
        int n = this.search(c, true);
        if (n == -1) {
            return false;
        }
        Assert.that(this.get(n).getLabelStart() == c);
        this.children.remove(n);
        return true;
    }

    public void trim() {
        this.children.trimToSize();
    }

    public Iterator children() {
        return new ChildrenIterator();
    }

    public Iterator labels() {
        return new LabelIterator();
    }

    public String toString() {
        Object object = this.getValue();
        if (object == null) {
            return "NULL";
        }
        return object.toString();
    }

    private class LabelIterator
    extends UnmodifiableIterator {
        int i = 0;

        private LabelIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieEdge trieEdge = TrieNode.this.get(this.i);
            ++this.i;
            return trieEdge.getLabel();
        }
    }

    private class ChildrenIterator
    extends UnmodifiableIterator {
        int i = 0;

        private ChildrenIterator() {
        }

        public boolean hasNext() {
            return this.i < TrieNode.this.children.size();
        }

        public Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            TrieEdge trieEdge = TrieNode.this.get(this.i);
            ++this.i;
            return trieEdge.getChild();
        }
    }
}

