/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Assert;
import java.io.IOException;
import java.net.Socket;

public class SocketOpener {
    private String host;
    private int port;
    private Socket socket = null;
    private boolean timedOut = false;

    public SocketOpener(String string, int n) {
        this.host = string;
        this.port = n;
    }

    public synchronized Socket connect(int n) throws IOException {
        SocketOpenerThread socketOpenerThread = new SocketOpenerThread();
        socketOpenerThread.start();
        Assert.that(this.socket == null, "Socket already established w.o. lock.");
        try {
            this.wait(n);
        }
        catch (InterruptedException interruptedException) {
            if (this.socket == null) {
                this.timedOut = true;
            } else {
                try {
                    this.socket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new IOException();
        }
        if (this.socket != null) {
            return this.socket;
        }
        this.timedOut = true;
        throw new IOException();
    }

    private class SocketOpenerThread
    extends Thread {
        private SocketOpenerThread() {
        }

        public void run() {
            Socket socket = null;
            try {
                socket = new Socket(SocketOpener.this.host, SocketOpener.this.port);
            }
            catch (IOException iOException) {
                // empty catch block
            }
            SocketOpener socketOpener = SocketOpener.this;
            synchronized (socketOpener) {
                if (SocketOpener.this.timedOut && socket != null) {
                    try {
                        socket.close();
                    }
                    catch (IOException iOException) {}
                } else {
                    SocketOpener.this.socket = socket;
                    SocketOpener.this.notify();
                }
            }
        }
    }
}

