/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;

public final class CommonUtils {
    private static final String LIMEWIRE_VERSION = "2.1.1";
    private static final Properties PROPS = System.getProperties();
    private static boolean _isWindows = false;
    private static boolean _isWindowsNTor2000 = false;
    private static boolean _isWindows95 = false;
    private static boolean _isWindows98 = false;
    private static boolean _supportsTray = false;
    private static boolean _isMacClassic = false;
    private static boolean _isMacOSX = false;
    private static boolean _isLinux = false;
    private static boolean _isSolaris = false;

    private CommonUtils() {
    }

    public static String getLimeWireVersion() {
        return LIMEWIRE_VERSION;
    }

    public static String getVendor() {
        return "LimeWire 2.1.1";
    }

    public static String getJavaVersion() {
        return PROPS.getProperty("java.version");
    }

    public static String getOS() {
        return PROPS.getProperty("os.name");
    }

    public static String getCurrentDirectory() {
        return PROPS.getProperty("user.dir");
    }

    public static boolean supportsTray() {
        return _supportsTray;
    }

    public static boolean isSupernodeOS() {
        return !_isWindows98 && !_isWindows95 && !_isMacClassic;
    }

    public static boolean isWindows() {
        return _isWindows;
    }

    public static boolean isWindowsNTor2000() {
        return _isWindowsNTor2000;
    }

    public static boolean isMacClassic() {
        return _isMacClassic;
    }

    public static boolean isMacOSX() {
        return _isMacOSX;
    }

    public static boolean isAnyMac() {
        return _isMacClassic || _isMacOSX;
    }

    public static boolean isSolaris() {
        return _isSolaris;
    }

    public static boolean isLinux() {
        return _isLinux;
    }

    public static boolean isUnix() {
        return _isLinux || _isSolaris;
    }

    /*
     * Loose catch block
     */
    public static int copy(File file, int n, File file2) {
        int n2;
        block24: {
            IOException iOException2222;
            OutputStream outputStream;
            BufferedInputStream bufferedInputStream;
            block21: {
                n2 = n;
                boolean bl = true;
                bufferedInputStream = null;
                outputStream = null;
                bufferedInputStream = new BufferedInputStream(new FileInputStream(file));
                outputStream = new BufferedOutputStream(new FileOutputStream(file2));
                byte[] byArray = new byte[1024];
                while (n2 > 0) {
                    int n3 = ((InputStream)bufferedInputStream).read(byArray, 0, Math.min(1024, n2));
                    if (n3 == -1) break;
                    n2 -= n3;
                    outputStream.write(byArray, 0, n3);
                }
                Object var11_10 = null;
                if (bufferedInputStream == null) break block21;
                try {
                    ((InputStream)bufferedInputStream).close();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
            }
            if (outputStream != null) {
                try {
                    outputStream.flush();
                }
                catch (IOException iOException2222) {
                    // empty catch block
                }
                try {
                    outputStream.close();
                }
                catch (IOException iOException2222) {}
            }
            break block24;
            {
                catch (IOException iOException3) {
                    IOException iOException42222;
                    Object var11_11 = null;
                    if (bufferedInputStream != null) {
                        try {
                            ((InputStream)bufferedInputStream).close();
                        }
                        catch (IOException iOException42222) {
                            // empty catch block
                        }
                    }
                    if (outputStream == null) break block24;
                    try {
                        outputStream.flush();
                    }
                    catch (IOException iOException42222) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException42222) {}
                }
            }
            catch (Throwable throwable) {
                IOException iOException52222;
                Object var11_12 = null;
                if (bufferedInputStream != null) {
                    try {
                        ((InputStream)bufferedInputStream).close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                if (outputStream != null) {
                    try {
                        outputStream.flush();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                    try {
                        outputStream.close();
                    }
                    catch (IOException iOException52222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return n - n2;
    }

    public static boolean copy(File file, File file2) {
        long l = file.length();
        return (long)CommonUtils.copy(file, (int)l, file2) == l;
    }

    static {
        String string = System.getProperty("os.name");
        boolean bl = _isWindows = string.indexOf("Windows") != -1;
        if (string.indexOf("Windows NT") != -1 || string.indexOf("Windows 2000") != -1) {
            _isWindowsNTor2000 = true;
        }
        if (string.indexOf("Windows 95") != -1) {
            _isWindows95 = true;
        }
        if (string.indexOf("Windows 98") != -1) {
            _isWindows98 = true;
        }
        if (_isWindows) {
            _supportsTray = true;
        }
        _isSolaris = string.indexOf("Solaris") != -1;
        boolean bl2 = _isLinux = string.indexOf("Linux") != -1;
        if (string.startsWith("Mac OS")) {
            if (string.endsWith("X")) {
                _isMacOSX = true;
            } else {
                _isMacClassic = true;
            }
        }
    }
}

