/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.util;

import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.util.Buffer;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.NoSuchElementException;

public class BucketQueue
implements Cloneable {
    private Buffer[] buckets;

    public BucketQueue(int[] nArray) {
        this.buckets = new Buffer[nArray.length];
        int n = 0;
        while (n < this.buckets.length) {
            this.buckets[n] = new Buffer(nArray[n]);
            ++n;
        }
    }

    public BucketQueue(BucketQueue bucketQueue) {
        this.buckets = new Buffer[bucketQueue.buckets.length];
        int n = 0;
        while (n < this.buckets.length) {
            this.buckets[n] = new Buffer(bucketQueue.buckets[n]);
            ++n;
        }
    }

    public void clear() {
        int n = 0;
        while (n < this.buckets.length) {
            this.buckets[n].clear();
            ++n;
        }
    }

    public Endpoint insert(Endpoint endpoint) {
        int n = endpoint.getWeight();
        return (Endpoint)this.buckets[n].addFirst(endpoint);
    }

    public boolean removeAll(Endpoint endpoint) {
        boolean bl = false;
        int n = 0;
        while (n < this.buckets.length) {
            bl |= this.buckets[n].removeAll(endpoint);
            ++n;
        }
        return bl;
    }

    public Endpoint extractMax() throws NoSuchElementException {
        int n = this.buckets.length - 1;
        while (n >= 0) {
            if (!this.buckets[n].isEmpty()) {
                return (Endpoint)this.buckets[n].removeFirst();
            }
            --n;
        }
        throw new NoSuchElementException();
    }

    public Endpoint getMax() throws NoSuchElementException {
        int n = this.buckets.length - 1;
        while (n >= 0) {
            if (!this.buckets[n].isEmpty()) {
                return (Endpoint)this.buckets[n].first();
            }
            --n;
        }
        throw new NoSuchElementException();
    }

    public int size() {
        int n = 0;
        int n2 = 0;
        while (n2 < this.buckets.length) {
            n += this.buckets[n2].getSize();
            ++n2;
        }
        return n;
    }

    public int size(int n) {
        return this.buckets[n].getSize();
    }

    public boolean isEmpty() {
        return this.size() == 0;
    }

    public Iterator iterator() {
        return new BucketQueueIterator(this.buckets.length - 1, this.size());
    }

    public Iterator iterator(int n, int n2) {
        return new BucketQueueIterator(n, n2);
    }

    public Object clone() {
        return new BucketQueue(this);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("[");
        int n = this.buckets.length - 1;
        while (n >= 0) {
            if (n != this.buckets.length - 1) {
                stringBuffer.append(", ");
            }
            stringBuffer.append(this.buckets[n].toString());
            --n;
        }
        stringBuffer.append("]");
        return stringBuffer.toString();
    }

    private class BucketQueueIterator
    extends UnmodifiableIterator {
        private Iterator currentIterator;
        private int currentBucket;
        private int left;

        public BucketQueueIterator(int n, int n2) {
            this.currentBucket = n;
            this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
            this.left = n2;
        }

        public synchronized boolean hasNext() {
            if (this.left <= 0) {
                return false;
            }
            if (this.currentIterator.hasNext()) {
                return true;
            }
            if (this.currentBucket < 0) {
                return false;
            }
            --this.currentBucket;
            while (this.currentBucket >= 0) {
                this.currentIterator = BucketQueue.this.buckets[this.currentBucket].iterator();
                if (this.currentIterator.hasNext()) {
                    return true;
                }
                --this.currentBucket;
            }
            return false;
        }

        public synchronized Object next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            --this.left;
            return this.currentIterator.next();
        }
    }
}

