/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.uploader.HTTPUploader;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.SocketException;

public class NormalUploadState
implements UploadState {
    public static final int CYCLE_TIME = 1000;
    private HTTPUploader _uploader;
    private OutputStream _ostream;
    private int _index;
    private String _filename;
    private int _fileSize;
    private InputStream _fis;
    private int _amountRead;
    private int _uploadBegin;

    public void doUpload(HTTPUploader hTTPUploader) throws IOException {
        this._uploader = hTTPUploader;
        this._uploader.setState(3);
        this._ostream = this._uploader.getOutputStream();
        this._index = this._uploader.getIndex();
        this._filename = this._uploader.getFileName();
        this._fileSize = this._uploader.getFileSize();
        this._fis = this._uploader.getInputStream();
        this._amountRead = this._uploader.amountUploaded();
        this._uploadBegin = this._uploader.getUploadBegin();
        this.writeHeader();
        int n = -1;
        boolean bl = false;
        byte[] byArray = new byte[1024];
        long l = this._fis.skip(this._uploadBegin);
        this._amountRead = (int)((long)this._amountRead + l);
        this._uploader.setAmountUploaded(this._amountRead);
        SettingsManager settingsManager = SettingsManager.instance();
        int n2 = settingsManager.getUploadSpeed();
        if (n2 == 100) {
            while ((n = this._fis.read(byArray)) != -1) {
                try {
                    this._ostream.write(byArray, 0, n);
                }
                catch (SocketException socketException) {
                    throw new IOException();
                }
                this._amountRead += n;
                this._uploader.setAmountUploaded(this._amountRead);
            }
        } else {
            block7: while (true) {
                int n3 = this._uploader.getManager().calculateBandwidth();
                int n4 = n3 * 1000;
                int n5 = 0;
                long l2 = System.currentTimeMillis();
                while (n5 < n4) {
                    n = this._fis.read(byArray);
                    if (n == -1) break block7;
                    try {
                        this._ostream.write(byArray, 0, n);
                    }
                    catch (SocketException socketException) {
                        throw new IOException();
                    }
                    this._amountRead += n;
                    this._uploader.setAmountUploaded(this._amountRead);
                    n5 += n;
                }
                long l3 = System.currentTimeMillis();
                int n6 = (int)(l3 - l2);
                int n7 = 1000 - n6;
                if (n7 <= 0) continue;
                try {
                    Thread.currentThread();
                    Thread.sleep(n7);
                }
                catch (InterruptedException interruptedException) {
                    throw new IOException();
                }
            }
        }
        this._uploader.setState(4);
        this._ostream.close();
    }

    private String getMimeType() {
        String string = "application/binary";
        return string;
    }

    private void writeHeader() throws IOException {
        String string = "HTTP 200 OK \r\n";
        this._ostream.write(string.getBytes());
        string = "Server: " + CommonUtils.getVendor() + "\r\n";
        this._ostream.write(string.getBytes());
        String string2 = this.getMimeType();
        string = "Content-type:" + string2 + "\r\n";
        this._ostream.write(string.getBytes());
        string = "Content-length:" + (this._fileSize - this._uploadBegin) + "\r\n";
        this._ostream.write(string.getBytes());
        if (this._uploadBegin != 0) {
            string = "Content-range: bytes " + this._uploadBegin + "-" + (this._fileSize - 1) + "/" + this._fileSize + "\r\n";
            this._ostream.write(string.getBytes());
        }
        string = "\r\n";
        this._ostream.write(string.getBytes());
    }
}

