/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.uploader;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BandwidthTrackerImpl;
import com.limegroup.gnutella.ByteReader;
import com.limegroup.gnutella.FileDesc;
import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.UploadManager;
import com.limegroup.gnutella.Uploader;
import com.limegroup.gnutella.uploader.FileNotFoundUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadState;
import com.limegroup.gnutella.uploader.FreeloaderUploadingException;
import com.limegroup.gnutella.uploader.LimitReachedUploadState;
import com.limegroup.gnutella.uploader.NormalUploadState;
import com.limegroup.gnutella.uploader.PushFailedUploadState;
import com.limegroup.gnutella.uploader.UploadState;
import com.limegroup.gnutella.util.StringUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;

public class HTTPUploader
implements Uploader {
    protected OutputStream _ostream;
    protected InputStream _fis;
    protected Socket _socket;
    protected int _amountRead;
    protected int _uploadBegin;
    protected int _uploadEnd;
    protected int _fileSize;
    protected int _index;
    protected String _filename;
    protected String _hostName;
    protected String _guid;
    protected int _port;
    protected int _stateNum = 0;
    private UploadState _state;
    private UploadManager _manager;
    private boolean _chatEnabled;
    private String _chatHost;
    private int _chatPort;
    private FileManager _fileManager;
    private BandwidthTrackerImpl bandwidthTracker = new BandwidthTrackerImpl();

    public HTTPUploader(String string, Socket socket, int n, UploadManager uploadManager, FileManager fileManager) {
        this._socket = socket;
        this._hostName = this._socket.getInetAddress().getHostAddress();
        this._filename = string;
        this._manager = uploadManager;
        this._index = n;
        this._amountRead = 0;
        this._fileManager = fileManager;
        boolean bl = false;
        boolean bl2 = false;
        try {
            this._ostream = this._socket.getOutputStream();
            FileDesc fileDesc = this._fileManager.get(this._index);
            this._fileSize = fileDesc._size;
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            bl = true;
        }
        catch (IOException iOException) {
            bl2 = true;
        }
        if (bl) {
            this.setState(7);
        } else if (bl2) {
            this.setState(5);
        } else {
            this.setState(0);
        }
    }

    public HTTPUploader(String string, String string2, int n, int n2, String string3, UploadManager uploadManager, FileManager fileManager) {
        this._filename = string;
        this._manager = uploadManager;
        this._index = n2;
        this._uploadBegin = 0;
        this._amountRead = 0;
        this._hostName = string2;
        this._guid = string3;
        this._port = n;
        this._fileManager = fileManager;
        try {
            FileDesc fileDesc = this._fileManager.get(this._index);
            this._fileSize = fileDesc._size;
            this.setState(0);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setState(6);
        }
    }

    public void connect() throws IOException {
        if (this._socket != null) {
            return;
        }
        try {
            this._socket = new Socket(this._hostName, this._port);
            this._ostream = this._socket.getOutputStream();
            Assert.that(this._filename != null);
            Assert.that(this._filename != "");
            String string = "GIV " + this._index + ":" + this._guid + "/" + this._filename + "\n\n";
            this._ostream.write(string.getBytes());
            this._ostream.flush();
            InputStream inputStream = this._socket.getInputStream();
            ByteReader byteReader = new ByteReader(inputStream);
            int n = SettingsManager.instance().getTimeout();
            this._socket.setSoTimeout(n);
            String string2 = byteReader.readLine();
            this._socket.setSoTimeout(0);
            if (string2 == null) {
                throw new IOException();
            }
            if (!string2.startsWith("GET")) {
                throw new IOException();
            }
            String string3 = string2.substring(4, string2.length());
            String[] stringArray = StringUtils.split(string3, '/');
            if (stringArray.length != 4) {
                throw new IOException();
            }
            if (!stringArray[0].equals("get")) {
                throw new IOException();
            }
            int n2 = stringArray[2].lastIndexOf("HTTP") - 1;
            String string4 = stringArray[2].substring(0, n2);
            if (!string4.equals(this._filename)) {
                throw new IOException();
            }
            int n3 = Integer.parseInt(stringArray[1]);
            if (n3 != this._index) {
                throw new IOException();
            }
        }
        catch (SecurityException securityException) {
            this.setState(6);
            throw new IOException();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            this.setState(6);
            throw new IOException();
        }
        catch (NumberFormatException numberFormatException) {
            this.setState(6);
            throw new IOException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            this.setState(6);
            throw new IOException();
        }
        catch (IOException iOException) {
            this.setState(6);
            throw new IOException();
        }
    }

    public void start() {
        try {
            this.prepareFile();
        }
        catch (IOException iOException) {
            this.setState(7);
        }
        try {
            this.readHeader();
            this._state.doUpload(this);
        }
        catch (FreeloaderUploadingException freeloaderUploadingException) {
            this.setState(1);
            try {
                this._state.doUpload(this);
            }
            catch (IOException iOException) {}
        }
        catch (IOException iOException) {
            this.setState(5);
        }
        this.stop();
    }

    public void stop() {
        try {
            if (this._ostream != null) {
                this._ostream.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this._fis != null) {
                this._fis.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        try {
            if (this._socket != null) {
                this._socket.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void setState(int n) {
        this._stateNum = n;
        switch (n) {
            case 0: {
                this._state = new NormalUploadState();
                break;
            }
            case 2: {
                this._state = new LimitReachedUploadState();
                break;
            }
            case 6: {
                this._state = new PushFailedUploadState();
                break;
            }
            case 1: {
                this._state = new FreeloaderUploadState();
                break;
            }
            case 7: {
                this._state = new FileNotFoundUploadState();
            }
        }
    }

    public OutputStream getOutputStream() {
        return this._ostream;
    }

    public int getIndex() {
        return this._index;
    }

    public String getFileName() {
        return this._filename;
    }

    public int getFileSize() {
        return this._fileSize;
    }

    public InputStream getInputStream() {
        return this._fis;
    }

    public int amountUploaded() {
        return this._amountRead;
    }

    public void setAmountUploaded(int n) {
        this._amountRead = n;
    }

    public int getUploadBegin() {
        return this._uploadBegin;
    }

    public int getState() {
        return this._stateNum;
    }

    public String getHost() {
        return this._hostName;
    }

    public UploadManager getManager() {
        return this._manager;
    }

    public String getThisHost() {
        return this._manager.getThisHost();
    }

    public int getThisPort() {
        return this._manager.getThisPort();
    }

    public boolean chatEnabled() {
        return this._chatEnabled;
    }

    public String getChatHost() {
        return this._chatHost;
    }

    public int getChatPort() {
        return this._chatPort;
    }

    private void readHeader() throws IOException {
        String string = " ";
        this._uploadBegin = 0;
        this._uploadEnd = 0;
        InputStream inputStream = this._socket.getInputStream();
        ByteReader byteReader = new ByteReader(inputStream);
        while ((string = byteReader.readLine()) != null && !string.equals("")) {
            String string2;
            if (string.toUpperCase().indexOf("CHAT:") != -1) {
                int n;
                try {
                    string2 = string.substring(5);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IOException();
                }
                string2 = string2.trim();
                int n2 = string2.indexOf(":");
                String string3 = string2.substring(0, n2);
                string3 = string3.trim();
                String string4 = string2.substring(n2 + 1);
                string4 = string4.trim();
                try {
                    n = Integer.parseInt(string4);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException();
                }
                this._chatEnabled = true;
                this._chatHost = string3;
                this._chatPort = n;
            }
            if (this.indexOfIgnoreCase(string, "Range: bytes=") != -1 || this.indexOfIgnoreCase(string, "Range: bytes ") != -1) {
                String string5;
                String string6;
                char c;
                try {
                    string2 = string.substring(13);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IOException();
                }
                string2 = string2.trim();
                try {
                    c = string2.charAt(0);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IOException();
                }
                if (c == '-') {
                    String string7;
                    try {
                        string7 = string2.substring(1);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        throw new IOException();
                    }
                    string7 = string7.trim();
                    try {
                        this._uploadEnd = Integer.parseInt(string7);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException();
                    }
                }
                int n = string2.indexOf("-");
                try {
                    string6 = string2.substring(0, n);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IOException();
                }
                string6 = string6.trim();
                try {
                    this._uploadBegin = Integer.parseInt(string6);
                }
                catch (NumberFormatException numberFormatException) {
                    throw new IOException();
                }
                try {
                    string5 = string2.substring(n + 1);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    throw new IOException();
                }
                string5 = string5.trim();
                if (!string5.equals("")) {
                    try {
                        this._uploadEnd = Integer.parseInt(string5);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new IOException();
                    }
                }
            }
            if (this.indexOfIgnoreCase(string, "User-Agent:") == -1) continue;
            if (!(SettingsManager.instance().getAllowBrowser() || string.indexOf("Mozilla") == -1 && string.indexOf("DA") == -1 && string.indexOf("Download") == -1 && string.indexOf("FlashGet") == -1 && string.indexOf("GetRight") == -1 && string.indexOf("Go!Zilla") == -1 && string.indexOf("Inet") == -1 && string.indexOf("MIIxpc") == -1 && string.indexOf("MSProxy") == -1 && string.indexOf("Mass") == -1 && string.indexOf("MyGetRight") == -1 && string.indexOf("NetAnts") == -1 && string.indexOf("NetZip") == -1 && string.indexOf("RealDownload") == -1 && string.indexOf("SmartDownload") == -1 && string.indexOf("Teleport") == -1 && string.indexOf("WebDownloader") == -1)) {
                throw new FreeloaderUploadingException();
            }
            String string8 = string.substring(11).trim();
        }
        if (this._uploadEnd == 0) {
            this._uploadEnd = this._fileSize;
        }
    }

    private int indexOfIgnoreCase(String string, String string2) {
        String string3 = string.toLowerCase();
        String string4 = string2.toLowerCase();
        return string3.indexOf(string4);
    }

    private void prepareFile() throws IOException {
        FileDesc fileDesc;
        try {
            fileDesc = this._fileManager.get(this._index);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            throw new IOException();
        }
        String string = fileDesc._name;
        if (this._filename == null) {
            this._filename = string;
        } else if (!string.equals(this._filename)) {
            throw new IOException();
        }
        this._fileSize = fileDesc._size;
        this._fis = this._fileManager.getInputStream(fileDesc);
    }

    public void measureBandwidth() {
        this.bandwidthTracker.measureBandwidth(this.amountUploaded());
    }

    public float getMeasuredBandwidth() {
        return this.bandwidthTracker.getMeasuredBandwidth();
    }
}

