/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.update.UpdateManager;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;

public final class UpdateGUIHandler {
    private static final UpdateGUIHandler INSTANCE = new UpdateGUIHandler();
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private ProgressWindow _progressWindow;

    static final synchronized UpdateGUIHandler instance() {
        return INSTANCE;
    }

    private UpdateGUIHandler() {
    }

    final boolean showUpdatePrompt(String string) {
        UpdatePanel updatePanel = new UpdatePanel(string);
        int n = JOptionPane.showConfirmDialog(null, updatePanel, "Update", 0);
        return n == 0;
    }

    final void showProgressWindow() {
        this._progressWindow = new ProgressWindow();
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((Component)UpdateGUIHandler.this._progressWindow).setVisible(true);
            }
        });
    }

    final void setDownloadFile(String string) {
        this._progressWindow.setDownloadFile(string);
    }

    final void setDownloadSize(int n) {
        this._progressWindow.setDownloadSize(n);
    }

    final void hideProgressWindow() {
        ((Component)this._progressWindow).setVisible(false);
        this._progressWindow.dispose();
    }

    final void updateProgressWindow(int n) {
        this._progressWindow.setAmountRead(n);
        SwingUtilities.invokeLater(this._progressWindow);
    }

    final void displayErrorMessage(String string) {
        String string2 = "UPDATE_ERROR_MESSAGE_START";
        String string3 = "UPDATE_ERROR_MESSAGE_END";
        GUIMediator.showError(string2, string, string3);
    }

    final void displayMessage(String string) {
        GUIMediator.showMessage(string);
    }

    static /* synthetic */ SettingsManager access$600(UpdateGUIHandler updateGUIHandler) {
        return updateGUIHandler.SETTINGS;
    }

    private class ProgressWindow
    extends JDialog
    implements Runnable {
        private final JProgressBar _progressBar;
        private double _downloadSize;
        private double _amountRead;
        private JLabel _label;

        public ProgressWindow() {
            ((Component)this).setSize(460, 140);
            this.addWindowListener(new WindowAdapter(this){
                private final /* synthetic */ ProgressWindow this$1;
                {
                    this.this$1 = progressWindow;
                }

                public void windowClosing(WindowEvent windowEvent) {
                    ProgressWindow.access$700(this.this$1);
                }
            });
            Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
            ((Component)this).setLocation((dimension.width - 350) / 2, (dimension.height - 140) / 2);
            JPanel jPanel = new JPanel();
            JPanel jPanel2 = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 1));
            jPanel2.setLayout(new BoxLayout(jPanel2, 0));
            Border border = BorderFactory.createEmptyBorder(12, 12, 12, 12);
            jPanel.setBorder(border);
            this._progressBar = new JProgressBar();
            this._progressBar.setStringPainted(true);
            this._progressBar.setString("0%");
            this._label = new JLabel("Contacting the LimeWire server...");
            jPanel2.add(this._label);
            jPanel2.add(Box.createHorizontalGlue());
            this._downloadSize = 1000.0;
            this._amountRead = 0.0;
            String[] stringArray = new String[]{"UPDATE_CANCEL_BUTTON_LABEL"};
            String[] stringArray2 = new String[]{"UPDATE_CANCEL_BUTTON_TIP"};
            ActionListener actionListener = new ActionListener(this){
                private final /* synthetic */ ProgressWindow this$1;
                {
                    this.this$1 = progressWindow;
                }

                public void actionPerformed(ActionEvent actionEvent) {
                    ProgressWindow.access$700(this.this$1);
                }
            };
            ActionListener[] actionListenerArray = new ActionListener[]{actionListener};
            ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray);
            jPanel.add(jPanel2);
            jPanel.add(Box.createVerticalStrut(6));
            jPanel.add(this._progressBar);
            jPanel.add(Box.createVerticalStrut(6));
            jPanel.add(buttonRow);
            this.getContentPane().add(jPanel);
        }

        public void run() {
            int n = (int)(100.0 * (this._amountRead / this._downloadSize));
            this._progressBar.setValue(n);
            this._progressBar.setString(Integer.toString(n) + "%");
        }

        private void setDownloadFile(String string) {
            this._label.setText("Downloading: " + string + "...");
        }

        private void setAmountRead(int n) {
            this._amountRead = n;
        }

        private void setDownloadSize(int n) {
            this._downloadSize = n;
        }

        private void cancelUpdate() {
            UpdateManager.instance().cancelUpdate();
        }

        static /* synthetic */ void access$700(ProgressWindow progressWindow) {
            progressWindow.cancelUpdate();
        }
    }

    private class UpdatePanel
    extends JPanel {
        private UpdatePanel(String string) {
            MultiLineLabel multiLineLabel = GUIUtils.getSizedLabel(string);
            String string2 = "Don't inform me of updates.";
            JCheckBox jCheckBox = new JCheckBox(string2);
            jCheckBox.setForeground((Color)UIManager.get("Label.foreground"));
            jCheckBox.addItemListener(new ItemListener(this, jCheckBox){
                private final /* synthetic */ JCheckBox val$checkBox;
                private final /* synthetic */ UpdatePanel this$1;
                {
                    this.this$1 = updatePanel;
                    this.val$checkBox = jCheckBox;
                }

                public void itemStateChanged(ItemEvent itemEvent) {
                    UpdateGUIHandler.access$600(UpdatePanel.access$500(this.this$1)).setCheckAgain(!this.val$checkBox.isSelected());
                }
            });
            JPanel jPanel = new JPanel();
            jPanel.add(jCheckBox);
            jPanel.add(Box.createHorizontalGlue());
            this.setLayout(new BoxLayout(this, 1));
            this.add(multiLineLabel);
            this.add(Box.createVerticalStrut(6));
            this.add(jPanel);
        }

        static /* synthetic */ UpdateGUIHandler access$500(UpdatePanel updatePanel) {
            return updatePanel.UpdateGUIHandler.this;
        }
    }
}

