/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.update.AbstractRemoteUpdateInfo;
import com.limegroup.gnutella.update.ServletLocalUpdateInfo;
import java.io.IOException;
import java.net.URLEncoder;

public final class ServletRemoteUpdateInfo
extends AbstractRemoteUpdateInfo {
    private final boolean UPDATE_ACTIVE = false;
    private final String LIMEWIRE_VERSION_ON_SERVER = "1.9";
    private final String AD_VERSION_ON_SERVER = "2";
    private final String UPDATE_MESSAGE = "Version 1.9 of LimeWire is currently available. Would you like to update now?";
    private final String DISPLAY_MESSAGE_UPDATE_MESSAGE = "Version 1.9 of LimeWire is currently available from www.limewire.com. Would you like to start your old version now?";
    private final String JAR_TEST_MESSAGE = "This is a test of the LimeWire update procedure. Would you like to test your jar update now?";
    private final String WEB_UPDATE_URL = "http://www.limewire.com/index.jsp/update";
    private final String MAC_CLASSIC_UPDATE_URL = "http://version.limewire.com/updates/mac_classic/LimeWire16b.jar";
    private final String JAR_TEST_URL = "http://version.limewire.com/updates/LimeWire14.jar;http://version.limewire.com/updates/collections.jar";
    private final String AD_URL = "http://version.limewire.com/updates/ads.war";
    private final String MAIN_CLASS = "";
    private String _directive = "NO_UPDATE";
    private String _url = "";
    private String _message = "";
    private String _classpath = "";

    public ServletRemoteUpdateInfo(ServletLocalUpdateInfo servletLocalUpdateInfo) throws IOException {
        String string = servletLocalUpdateInfo.getLimeWireVersion();
        String string2 = servletLocalUpdateInfo.getOS();
        String string3 = servletLocalUpdateInfo.getAdVersion();
        if (string == null || string.equals("")) {
            throw new IOException("invalid version");
        }
        if (string2 == null || string2.equals("")) {
            throw new IOException("invalid operating system");
        }
        if (!string.equals("TEST")) {
            return;
        }
        if ((string = string.substring(0, 3)).length() < 3) {
            throw new IOException("invalid version length");
        }
        String string4 = "1.9".substring(0, 3);
        if (string.compareTo(string4) < 0) {
            this.setValuesForVersionUpdate(string, string2);
            return;
        }
        if (string3 == null) {
            return;
        }
        if (!string3.equals("2")) {
            this.setValuesForAdUpdate(string, string2);
        }
    }

    private void setValuesForAdUpdate(String string, String string2) {
        if (string.startsWith("1.")) {
            return;
        }
        this._directive = "UPDATE_ADS_STRING";
        this._url = "http://version.limewire.com/updates/ads.war";
    }

    private void setValuesForVersionUpdate(String string, String string2) {
        if (string2.indexOf("Win") != -1) {
            this._directive = "OPEN_WEB_PAGE";
            this._url = "http://www.limewire.com/index.jsp/update";
            this._message = "Version 1.9 of LimeWire is currently available. Would you like to update now?";
        } else if (string2.indexOf("Sol") != -1) {
            this._directive = "DISPLAY_MESSAGE";
            this._message = "Version 1.9 of LimeWire is currently available from www.limewire.com. Would you like to start your old version now?";
        } else if (string2.indexOf("Lin") != -1) {
            this._directive = "DISPLAY_MESSAGE";
            this._message = "Version 1.9 of LimeWire is currently available from www.limewire.com. Would you like to start your old version now?";
        } else if (string2.startsWith("Mac")) {
            if (string2.endsWith("X")) {
                this._directive = "OPEN_WEB_PAGE";
                this._url = "http://www.limewire.com/index.jsp/update";
                this._message = "Version 1.9 of LimeWire is currently available. Would you like to update now?";
            } else {
                this._directive = "OPEN_WEB_PAGE";
                this._url = "http://www.limewire.com/index.jsp/update";
                this._message = "Version 1.9 of LimeWire is currently available. Would you like to update now?";
            }
        } else {
            this._directive = "DISPLAY_MESSAGE";
            this._message = "Version 1.9 of LimeWire is currently available from www.limewire.com. Would you like to start your old version now?";
        }
    }

    public String getURLEncodedString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("DIRECTIVE");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._directive));
        stringBuffer.append("&");
        stringBuffer.append("UPDATE_URL");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._url));
        stringBuffer.append("&");
        stringBuffer.append("MESSAGE_TO_DISPLAY");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._message));
        stringBuffer.append("&");
        stringBuffer.append("UPDATE_CLASSPATH");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(this._classpath));
        stringBuffer.append("&");
        stringBuffer.append("UPDATE_MAIN_CLASS");
        stringBuffer.append("=");
        stringBuffer.append(URLEncoder.encode(""));
        return stringBuffer.toString();
    }
}

