/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.update;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.update.AbstractUpdator;
import com.limegroup.gnutella.update.FileDownloadException;
import com.limegroup.gnutella.update.FileDownloader;
import com.limegroup.gnutella.update.LaxFileUpdateException;
import com.limegroup.gnutella.update.gui.UpdateCallback;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;
import java.util.StringTokenizer;

final class MultipleFileUpdator
extends AbstractUpdator
implements Runnable {
    private final String LAX_FILE_NAME = "LimeWire.lax";
    private volatile boolean _updateCancelled = false;
    private FileDownloader _fileDownloader;

    MultipleFileUpdator() {
        this._updateType = "MultipleFileUpdator";
        this._fileDownloader = new FileDownloader();
    }

    public synchronized void cancelUpdate() {
        this._updateCancelled = true;
        this._fileDownloader.stopDownload();
        UpdateCallback.hideProgressWindow();
        this.notifyAll();
    }

    public void doUpdate() {
        boolean bl = UpdateCallback.showUpdatePrompt(this._message);
        if (!bl) {
            return;
        }
        MultipleFileUpdator multipleFileUpdator = this;
        synchronized (multipleFileUpdator) {
            Thread thread = new Thread(this);
            thread.setDaemon(true);
            thread.start();
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public void run() {
        StringTokenizer stringTokenizer = new StringTokenizer(this._url, ";");
        String string = "";
        String string2 = "";
        UpdateCallback.showProgressWindow();
        while (stringTokenizer.hasMoreTokens() && !this._updateCancelled) {
            string = stringTokenizer.nextToken();
            string2 = this.getNewFileName(string);
            try {
                String string3 = this.getNewFileName(string);
                String string4 = this.getNewFilePath(string3);
                this._fileDownloader.downloadFile(string, string4);
            }
            catch (FileDownloadException fileDownloadException) {
                this.displayErrorAndExit(fileDownloadException.getMessage());
            }
        }
        if (!this._updateCancelled) {
            this.applyUpdateSettings();
            this.displayUpdateSucceededMessage();
            GUIMediator.shutdown();
        }
    }

    private void displayUpdateSucceededMessage() {
        UpdateCallback.hideProgressWindow();
        String string = "UPDATE_SUCCEEDED_MESSAGE";
        UpdateCallback.displayMessage(string);
    }

    private void applyUpdateSettings() {
        if (CommonUtils.isMacClassic()) {
            try {
                this.applyLaxSettings();
            }
            catch (LaxFileUpdateException laxFileUpdateException) {
                this.displayErrorAndExit(laxFileUpdateException.getMessage());
            }
        } else {
            this.applyStandardSettings();
        }
    }

    private void applyStandardSettings() {
        SettingsManager.instance().setClassPath(this._classpath);
        SettingsManager.instance().setMainClass(this._mainClass);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void applyLaxSettings() throws LaxFileUpdateException {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        FileOutputStream fileOutputStream = null;
        try {
            try {
                File file = new File("LimeWire.lax");
                fileInputStream = new FileInputStream(file);
                properties.load(fileInputStream);
                ((Hashtable)properties).put("lax.class.path", this._classpath);
                ((Hashtable)properties).put("lax.main.class", this._mainClass);
                fileInputStream.close();
                fileOutputStream = new FileOutputStream(file);
                properties.save(fileOutputStream, "");
                fileOutputStream.close();
            }
            catch (FileNotFoundException fileNotFoundException) {
                String string = "UPDATE_ERROR_LAX_FILE_NOT_FOUND";
                throw new LaxFileUpdateException(string);
            }
            catch (SecurityException securityException) {
                String string = "UPDATE_ERROR_LAX_SECURITY";
                throw new LaxFileUpdateException(string);
            }
            catch (IOException iOException) {
                String string = "UPDATE_ERROR_LAX_IO";
                throw new LaxFileUpdateException(string);
            }
            Object var9_6 = null;
        }
        catch (Throwable throwable) {
            Object var9_7 = null;
            try {
                if (fileInputStream != null) {
                    fileInputStream.close();
                }
                if (fileOutputStream == null) throw throwable;
                fileOutputStream.close();
                throw throwable;
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException iOException) {}
        if (fileInputStream != null) {
            fileInputStream.close();
        }
        if (fileOutputStream == null) return;
        fileOutputStream.close();
        return;
    }

    private void displayErrorAndExit(String string) {
        UpdateCallback.displayErrorMessage(string);
        GUIMediator.shutdown();
    }

    private String getNewFileName(String string) {
        int n = string.lastIndexOf("/") + 1;
        return string.substring(n);
    }

    private String getNewFilePath(String string) {
        return new File(string).getAbsolutePath();
    }
}

