/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Message;
import com.limegroup.gnutella.routing.RouteTableMessage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class ResetTableMessage
extends RouteTableMessage {
    private int tableSize;
    private byte infinity;

    public ResetTableMessage(int n, byte by) {
        super((byte)1, 6, (byte)0);
        if (n < 1 || by < 1) {
            throw new IllegalArgumentException("Argument too small: " + n + ", " + by);
        }
        this.tableSize = n;
        this.infinity = by;
    }

    protected void writePayloadData(OutputStream outputStream) throws IOException {
        byte[] byArray = new byte[5];
        ByteOrder.int2leb(this.tableSize, byArray, 0);
        byArray[4] = this.infinity;
        outputStream.write(byArray);
    }

    protected ResetTableMessage(byte[] byArray, byte by, byte by2, byte[] byArray2) throws BadPacketException {
        super(byArray, by, by2, byArray2.length, (byte)0);
        this.tableSize = ByteOrder.leb2int(byArray2, 1);
        this.infinity = byArray2[5];
    }

    public byte getInfinity() {
        return this.infinity;
    }

    public int getTableSize() {
        return this.tableSize;
    }

    public String toString() {
        return "{RESET, tableSize: " + this.getTableSize() + ", Infinity: " + this.getInfinity() + "}";
    }

    public static void main(String[] stringArray) {
        ResetTableMessage resetTableMessage = new ResetTableMessage(1024, 10);
        Assert.that(resetTableMessage.getVariant() == 0);
        Assert.that(resetTableMessage.getTTL() == 1);
        Assert.that(resetTableMessage.getTableSize() == 1024);
        Assert.that(resetTableMessage.getInfinity() == 10);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            resetTableMessage.write(byteArrayOutputStream);
            byteArrayOutputStream.flush();
        }
        catch (IOException iOException) {
            Assert.that(false);
        }
        resetTableMessage = ResetTableMessage.read(byteArrayOutputStream.toByteArray());
        Assert.that(resetTableMessage.getVariant() == 0);
        Assert.that(resetTableMessage.getTTL() == 1);
        Assert.that(resetTableMessage.getTableSize() == 1024);
        Assert.that(resetTableMessage.getInfinity() == 10);
        byte[] byArray = new byte[29];
        byArray[16] = 48;
        byArray[17] = 3;
        byArray[19] = 6;
        byArray[23] = 0;
        byArray[25] = 1;
        byArray[28] = 10;
        resetTableMessage = ResetTableMessage.read(byArray);
        Assert.that(resetTableMessage.getVariant() == 0);
        Assert.that(resetTableMessage.getInfinity() == 10);
        Assert.that(resetTableMessage.getTableSize() == 256);
    }

    static ResetTableMessage read(byte[] byArray) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(byArray);
        try {
            return (ResetTableMessage)Message.read(byteArrayInputStream);
        }
        catch (Exception exception) {
            Assert.that(false, "Bad message: " + exception);
            return null;
        }
    }
}

