/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.routing;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.QueryRequest;
import com.limegroup.gnutella.routing.HashFunction;
import com.limegroup.gnutella.routing.PatchTableMessage;
import com.limegroup.gnutella.routing.ResetTableMessage;
import com.limegroup.gnutella.routing.RouteTableMessage;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.zip.DataFormatException;
import java.util.zip.DeflaterOutputStream;
import java.util.zip.Inflater;

public class QueryRouteTable {
    public static final int DEFAULT_TABLE_SIZE = 16384;
    public static final byte DEFAULT_INFINITY = 7;
    public static final int MAX_PATCH_SIZE = 1024;
    private byte[] table;
    private byte infinity;
    private int entries;
    private int sequenceNumber;
    private int sequenceSize;
    private int nextPatch;
    private Inflater uncompressor;

    public QueryRouteTable() {
        this(16384, 7);
    }

    public QueryRouteTable(int n, byte by) {
        this.initialize(n, by);
    }

    private void initialize(int n, byte by) {
        this.table = new byte[n];
        Arrays.fill((byte[])this.table, (byte)by);
        this.infinity = by;
        this.entries = 0;
        this.sequenceNumber = -1;
        this.sequenceSize = -1;
        this.nextPatch = 0;
    }

    public boolean contains(QueryRequest queryRequest) {
        int n;
        int n2;
        byte by = queryRequest.getTTL();
        byte by2 = QueryRouteTable.log2(this.table.length);
        String string = queryRequest.getQuery();
        int n3 = 0;
        while ((n2 = HashFunction.keywordStart(string, n3)) >= 0) {
            int n4 = HashFunction.keywordEnd(string, n2);
            int n5 = HashFunction.hash(string, n2, n4, by2);
            if (!this.contains(n5, by)) {
                return false;
            }
            n3 = n4 + 1;
        }
        String string2 = queryRequest.getRichQuery();
        if (string2.equals("")) {
            return true;
        }
        LimeXMLDocument limeXMLDocument = null;
        try {
            limeXMLDocument = new LimeXMLDocument(string2);
            String string3 = limeXMLDocument.getSchemaURI();
            n = HashFunction.hash(string3, by2);
            if (!this.contains(n, by)) {
                return false;
            }
        }
        catch (Exception exception) {
            return true;
        }
        int n6 = 0;
        n = 0;
        Iterator iterator = limeXMLDocument.getKeyWords().iterator();
        while (iterator.hasNext()) {
            int n7;
            String string4 = (String)iterator.next();
            int n8 = 0;
            while ((n7 = HashFunction.keywordStart(string4, n8)) >= 0) {
                int n9 = HashFunction.keywordEnd(string4, n7);
                int n10 = HashFunction.hash(string4, n7, n9, by2);
                if (this.contains(n10, by)) {
                    ++n;
                }
                ++n6;
                n8 = n9 + 1;
            }
        }
        if (n6 < 3) {
            return n6 == n;
        }
        return (double)((float)n / (float)n6) > 0.67;
    }

    private final boolean contains(int n, int n2) {
        return this.table[n] <= n2 && this.table[n] < this.infinity;
    }

    private static byte log2(int n) {
        return (byte)(Math.log(n) / Math.log(2.0));
    }

    public void add(String string) {
        this.add(string, 1);
    }

    public void add(String string, int n) {
        String[] stringArray = HashFunction.keywords(string);
        String[] stringArray2 = HashFunction.getPrefixes(stringArray);
        int n2 = 0;
        while (n2 < stringArray2.length) {
            int n3 = HashFunction.hash(stringArray2[n2], QueryRouteTable.log2(this.table.length));
            if (n < this.table[n3]) {
                if (this.table[n3] >= this.infinity) {
                    ++this.entries;
                }
                this.table[n3] = (byte)n;
            }
            ++n2;
        }
    }

    public void addIndivisible(String string) {
        int n = HashFunction.hash(string, QueryRouteTable.log2(this.table.length));
        if (1 < this.table[n]) {
            if (this.table[n] >= this.infinity) {
                ++this.entries;
            }
            this.table[n] = 1;
        }
    }

    public void addAll(QueryRouteTable queryRouteTable) {
        int n = queryRouteTable.table.length;
        int n2 = this.table.length;
        double d = (double)n2 / (double)n;
        int n3 = 0;
        while (n3 < n) {
            int n4 = (int)Math.floor((double)n3 * d);
            int n5 = (int)Math.ceil((double)(n3 + 1) * d);
            Assert.that(n4 >= 0 && n4 < n2, "Low value " + n4 + " for " + n3 + " incompatible with " + n2);
            Assert.that(n5 >= 0 && n5 <= n2, "High value " + n5 + " for " + n3 + " incompatible with " + n2);
            int n6 = n4;
            while (n6 < n5) {
                byte by = queryRouteTable.table[n3] >= queryRouteTable.infinity ? this.infinity : (byte)(queryRouteTable.table[n3] + 1);
                if (by < this.table[n6]) {
                    if (this.table[n6] >= this.infinity) {
                        ++this.entries;
                    }
                    this.table[n6] = by;
                }
                ++n6;
            }
            ++n3;
        }
    }

    public int entries() {
        return this.entries;
    }

    public boolean equals(Object object) {
        if (!(object instanceof QueryRouteTable)) {
            return false;
        }
        QueryRouteTable queryRouteTable = (QueryRouteTable)object;
        if (this.table.length != queryRouteTable.table.length) {
            return false;
        }
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] != queryRouteTable.table[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("{");
        int n = 0;
        while (n < this.table.length) {
            if (this.table[n] < this.infinity) {
                stringBuffer.append(n + "/" + this.table[n] + ", ");
            }
            ++n;
        }
        stringBuffer.append("}");
        return stringBuffer.toString();
    }

    public void update(RouteTableMessage routeTableMessage) throws BadPacketException {
        switch (routeTableMessage.getVariant()) {
            case 0: {
                ResetTableMessage resetTableMessage = (ResetTableMessage)routeTableMessage;
                this.initialize(resetTableMessage.getTableSize(), resetTableMessage.getInfinity());
                return;
            }
            case 1: {
                PatchTableMessage patchTableMessage = (PatchTableMessage)routeTableMessage;
                this.handlePatch(patchTableMessage);
                return;
            }
        }
    }

    private void handlePatch(PatchTableMessage patchTableMessage) throws BadPacketException {
        if (this.sequenceSize != -1 && this.sequenceSize != patchTableMessage.getSequenceSize()) {
            throw new BadPacketException("Inconsistent seq size: " + patchTableMessage.getSequenceSize() + " vs. " + this.sequenceSize);
        }
        if (this.sequenceNumber != -1 && this.sequenceNumber + 1 != patchTableMessage.getSequenceNumber()) {
            throw new BadPacketException("Inconsistent seq number: " + patchTableMessage.getSequenceNumber() + " vs. " + this.sequenceNumber);
        }
        byte[] byArray = patchTableMessage.getData();
        if (patchTableMessage.getCompressor() == 1) {
            try {
                if (patchTableMessage.getSequenceNumber() == 1) {
                    this.uncompressor = new Inflater();
                }
                Assert.that(this.uncompressor != null, "Null uncompressor");
                byArray = this.uncompress(byArray);
            }
            catch (IOException iOException) {
                throw new BadPacketException("Couldn't uncompress data: " + iOException);
            }
        } else if (patchTableMessage.getCompressor() != 0) {
            throw new BadPacketException("Unknown compressor");
        }
        if (patchTableMessage.getEntryBits() == 4) {
            byArray = QueryRouteTable.unhalve(byArray);
        } else if (patchTableMessage.getEntryBits() != 8) {
            throw new BadPacketException("Unknown value for entry bits");
        }
        int n = 0;
        while (n < byArray.length) {
            try {
                boolean bl;
                boolean bl2 = this.table[this.nextPatch] >= this.infinity;
                int n2 = this.nextPatch;
                this.table[n2] = (byte)(this.table[n2] + byArray[n]);
                boolean bl3 = bl = this.table[this.nextPatch] >= this.infinity;
                if (bl2 && !bl) {
                    ++this.entries;
                } else if (!bl2 && bl) {
                    --this.entries;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new BadPacketException("Tried to patch " + this.nextPatch + " of an " + byArray.length + " element array.");
            }
            ++this.nextPatch;
            ++n;
        }
        if (patchTableMessage.getSequenceNumber() != patchTableMessage.getSequenceSize()) {
            this.sequenceNumber = patchTableMessage.getSequenceNumber();
        } else {
            this.sequenceNumber = -1;
            this.sequenceSize = -1;
            this.nextPatch = 0;
        }
    }

    public Iterator encode(QueryRouteTable queryRouteTable) {
        LinkedList linkedList = new LinkedList();
        if (queryRouteTable == null) {
            linkedList.add((Object)new ResetTableMessage(this.table.length, this.infinity));
        } else {
            Assert.that(queryRouteTable.table.length == this.table.length, "TODO: can't deal with tables of different lengths");
        }
        byte[] byArray = new byte[this.table.length];
        boolean bl = false;
        boolean bl2 = false;
        int n = 0;
        while (n < byArray.length) {
            byArray[n] = queryRouteTable != null ? (byte)(this.table[n] - queryRouteTable.table[n]) : (byte)(this.table[n] - this.infinity);
            if (byArray[n] != 0) {
                bl = true;
            }
            if (byArray[n] < -8 || byArray[n] > 7) {
                bl2 = true;
            }
            ++n;
        }
        if (!bl) {
            return linkedList.iterator();
        }
        byte by = 8;
        if (!bl2) {
            byArray = QueryRouteTable.halve(byArray);
            by = 4;
        }
        byte[] byArray2 = this.compress(byArray);
        byte by2 = 0;
        if (byArray2.length < byArray.length) {
            byArray = byArray2;
            by2 = 1;
        }
        int n2 = (int)Math.ceil((float)byArray.length / 1024.0f);
        int n3 = 1;
        int n4 = 0;
        while (n4 < byArray.length) {
            int n5 = Math.min(n4 + 1024, byArray.length);
            linkedList.add((Object)new PatchTableMessage((short)n3, (short)n2, by2, by, byArray, n4, n5));
            ++n3;
            n4 += 1024;
        }
        return linkedList.iterator();
    }

    private byte[] compress(byte[] byArray) {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            DeflaterOutputStream deflaterOutputStream = new DeflaterOutputStream(byteArrayOutputStream);
            deflaterOutputStream.write(byArray, 0, byArray.length);
            deflaterOutputStream.close();
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException iOException) {
            Assert.that(false, "Couldn't write to byte stream");
            return null;
        }
    }

    private byte[] uncompress(byte[] byArray) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        this.uncompressor.setInput(byArray);
        try {
            int n;
            byte[] byArray2 = new byte[1024];
            while ((n = this.uncompressor.inflate(byArray2)) != 0) {
                byteArrayOutputStream.write(byArray2, 0, n);
            }
            byteArrayOutputStream.flush();
            return byteArrayOutputStream.toByteArray();
        }
        catch (DataFormatException dataFormatException) {
            throw new IOException("Bad deflate format");
        }
    }

    private static byte[] halve(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length / 2];
        int n = 0;
        while (n < byArray2.length) {
            byArray2[n] = (byte)(byArray[2 * n] << 4 | byArray[2 * n + 1] & 0xF);
            ++n;
        }
        return byArray2;
    }

    private static byte[] unhalve(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length * 2];
        int n = 0;
        while (n < byArray.length) {
            byArray2[2 * n] = (byte)(byArray[n] >> 4);
            byArray2[2 * n + 1] = QueryRouteTable.extendNibble((byte)(byArray[n] & 0xF));
            ++n;
        }
        return byArray2;
    }

    private static byte extendNibble(byte by) {
        if ((by & 8) != 0) {
            return (byte)(0xF0 | by);
        }
        return by;
    }
}

