/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class MP3Info {
    private final int MAX_KBS_TO_CHECK = 204800;
    private final int HEADER_SIZE_IN_BYTES = 4;
    private final int VBITRATE_SIZE_IN_BYTES = 12;
    private final boolean DEBUG = false;
    private String _fileName;
    private long _fileSize;
    private MP3Header _header = new MP3Header();
    private VBitRate _vBitRate;
    private boolean _isVariableBitRate = false;

    public long getFileSize() {
        return this._fileSize;
    }

    public MP3Info(String string) throws IOException {
        this._fileName = string;
        RandomAccessFile randomAccessFile = new RandomAccessFile(this._fileName, "r");
        this._fileSize = randomAccessFile.length();
        long l = 0L;
        byte[] byArray = new byte[4];
        randomAccessFile.seek(l);
        while (l < 204800L && l < this._fileSize) {
            randomAccessFile.readFully(byArray);
            this._header.loadHeader(byArray);
            if (this._header.isValidHeader()) break;
            randomAccessFile.seek(++l);
        }
        this.debug("MP3Info(): found valid header at position " + l);
        if (!this._header.isValidHeader()) {
            throw new IOException("Invalid MP3 File!");
        }
        l += 4L;
        l = this._header.getVersionIndex() == 3 ? (this._header.getModeIndex() == 3 ? (l += 17L) : (l += 32L)) : (this._header.getModeIndex() == 3 ? (l += 9L) : (l += 17L));
        this.debug("MP3Info(): in attempt to find Variable bit rate, position = " + l);
        randomAccessFile.seek(l);
        byte[] byArray2 = new byte[12];
        randomAccessFile.readFully(byArray2);
        this._vBitRate = new VBitRate();
        this._isVariableBitRate = this._vBitRate.loadHeader(byArray2);
        this.debug("MP3Info(): is this a Variable bit rate? " + this._isVariableBitRate);
        randomAccessFile.close();
    }

    public boolean hasVariableBitRate() {
        return this._isVariableBitRate;
    }

    public long getLengthInSeconds() {
        return this.getFileSize() / (long)(this.getBitRate() * 1000 / 8);
    }

    public int getBitRate() {
        int n = 0;
        if (this._isVariableBitRate) {
            double d = (double)this._fileSize / (double)this.getNumberOfFrames();
            this.debug("MP3Info.getBitRate(): _fileSize = " + this._fileSize);
            this.debug("MP3Info.getBitRate(): medFrameSize = " + d);
            double d2 = d * (double)this._header.getFrequency();
            double d3 = 1000.0;
            d3 = this._header.getLayerIndex() == 3 ? (d3 *= 12.0) : (d3 *= 144.0);
            double d4 = d2 / d3;
            this.debug("MP3Info.getBitRate(): tempVal = " + d4);
            n = (int)d4;
        }
        if (n < 1) {
            n = this._header.getBitRate();
        }
        return n;
    }

    public int getNumberOfFrames() {
        if (!this._isVariableBitRate) {
            double d = (this._header.getLayerIndex() == 3 ? 12.0 : 144.0) * (1000.0 * (double)this._header.getBitRate() / (double)this._header.getFrequency());
            return (int)((double)this._fileSize / d);
        }
        return (int)this._vBitRate.getNumberOfFrames();
    }

    public void debug(String string) {
    }

    private class VBitRate {
        public final int FRAMES_FLAG = 1;
        public final int BYTES_FLAG = 2;
        public final int TOC_FLAG = 4;
        public final int VBR_SCALE_FLAG = 8;
        private long _frames;

        public long getNumberOfFrames() {
            MP3Info.this.debug("VBitRate.getNumberOfFrames(): returning " + this._frames);
            return this._frames;
        }

        public boolean loadHeader(byte[] byArray) {
            boolean bl = false;
            if (new String(byArray, 0, 4).equals("Xing")) {
                long l;
                this._frames = -1L;
                long l2 = l = (long)ByteOrder.ubyte2int(byArray[11]);
                l = ByteOrder.ubyte2int(byArray[10]);
                long l3 = l << 8;
                l = ByteOrder.ubyte2int(byArray[9]);
                long l4 = l << 16;
                l = ByteOrder.ubyte2int(byArray[8]);
                long l5 = l << 24;
                this._frames = l2 | l3 | l4 | l5;
                bl = true;
            } else {
                long l;
                long l6 = l = (long)ByteOrder.ubyte2int(byArray[7]);
                l = ByteOrder.ubyte2int(byArray[6]);
                long l7 = l << 8;
                l = ByteOrder.ubyte2int(byArray[5]);
                long l8 = l << 16;
                long l9 = (l = (long)ByteOrder.ubyte2int(byArray[4])) << 24;
                long l10 = l6 | l7 | l8 | l9;
                if ((l10 & 1L) != 0L) {
                    l6 = l = (long)ByteOrder.ubyte2int(byArray[11]);
                    l = ByteOrder.ubyte2int(byArray[10]);
                    l7 = l << 8;
                    l = ByteOrder.ubyte2int(byArray[9]);
                    l8 = l << 16;
                    l = ByteOrder.ubyte2int(byArray[8]);
                    l9 = l << 24;
                    this._frames = l6 | l7 | l8 | l9;
                    bl = false;
                } else {
                    this._frames = -1L;
                    bl = false;
                }
            }
            return bl;
        }
    }

    private class MP3Header {
        private long _intHeader;

        private long getHeader() {
            return this._intHeader;
        }

        private MP3Header() {
        }

        public boolean loadHeader(byte[] byArray) {
            long l;
            long l2 = l = (long)ByteOrder.ubyte2int(byArray[3]);
            l = ByteOrder.ubyte2int(byArray[2]);
            long l3 = l << 8;
            l = ByteOrder.ubyte2int(byArray[1]);
            long l4 = l << 16;
            l = ByteOrder.ubyte2int(byArray[0]);
            long l5 = l << 24;
            this._intHeader = l2 | l3 | l4 | l5;
            return this.isValidHeader();
        }

        public boolean isValidHeader() {
            return (this.getFrameSync() & 0x7FF) == 2047 && (this.getVersionIndex() & 3) != 1 && (this.getLayerIndex() & 3) != 0 && (this.getBitrateIndex() & 0xF) != 0 && (this.getBitrateIndex() & 0xF) != 15 && (this.getFrequencyIndex() & 3) != 3 && (this.getEmphasisIndex() & 3) != 2;
        }

        public double getVersion() {
            double[] dArray = new double[]{2.5, 0.0, 2.0, 1.0};
            return dArray[this.getVersionIndex()];
        }

        public int getLayer() {
            return 4 - this.getLayerIndex();
        }

        public int getFrequency() {
            int[][] nArrayArray = new int[][]{{32000, 16000, 8000}, {0, 0, 0}, {22050, 24000, 16000}, {44100, 48000, 32000}};
            MP3Info.this.debug("MP3Header.getFrequency():" + nArrayArray[this.getVersionIndex()][this.getFrequencyIndex()]);
            return nArrayArray[this.getVersionIndex()][this.getFrequencyIndex()];
        }

        public String getMode() {
            String string = null;
            switch (this.getModeIndex()) {
                default: {
                    string = "Stereo";
                    break;
                }
                case 1: {
                    string = "Joint Stereo";
                    break;
                }
                case 2: {
                    string = "Dual Channel";
                    break;
                }
                case 3: {
                    string = "Single Channel";
                }
            }
            return string;
        }

        public int getFrameSync() {
            return (int)(this.getHeader() >> 21 & 0x7FFL);
        }

        public int getVersionIndex() {
            return (int)(this.getHeader() >> 19 & 3L);
        }

        public int getLayerIndex() {
            return (int)(this.getHeader() >> 17 & 3L);
        }

        public int getProtectionBit() {
            return (int)(this.getHeader() >> 16 & 1L);
        }

        public int getBitrateIndex() {
            return (int)(this.getHeader() >> 12 & 0xFL);
        }

        public int getFrequencyIndex() {
            return (int)(this.getHeader() >> 10 & 3L);
        }

        public int getPaddingBit() {
            return (int)(this.getHeader() >> 9 & 1L);
        }

        public int getPrivateBit() {
            return (int)(this.getHeader() >> 8 & 1L);
        }

        public int getModeIndex() {
            return (int)(this.getHeader() >> 6 & 3L);
        }

        public int getModeExtIndex() {
            return (int)(this.getHeader() >> 4 & 3L);
        }

        public int getCoprightBit() {
            return (int)(this.getHeader() >> 3 & 1L);
        }

        public int getOrginalBit() {
            return (int)(this.getHeader() >> 2 & 1L);
        }

        public int getEmphasisIndex() {
            return (int)(this.getHeader() & 3L);
        }

        public int getBitRate() {
            int n = 0;
            int[][][] nArrayArray = new int[][][]{new int[][]{{0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 0}, {0, 8, 16, 24, 32, 40, 48, 56, 64, 80, 96, 112, 128, 144, 160, 0}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 144, 160, 176, 192, 224, 256, 0}}, new int[][]{{0, 32, 40, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 0}, {0, 32, 48, 56, 64, 80, 96, 112, 128, 160, 192, 224, 256, 320, 384, 0}, {0, 32, 64, 96, 128, 160, 192, 224, 256, 288, 320, 352, 384, 416, 448, 0}}};
            n = nArrayArray[this.getVersionIndex() & 1][this.getLayerIndex() - 1][this.getBitrateIndex()];
            return n;
        }
    }
}

