/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.mp3;

import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.mp3.MP3Info;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public final class ID3Reader {
    private static final String schemaURI = "http://www.limewire.com/schemas/audio.xsd";

    public String readDocument(File file, boolean bl) throws IOException {
        String string;
        int n;
        short s;
        RandomAccessFile randomAccessFile = new RandomAccessFile(file, "r");
        long l = randomAccessFile.length();
        if (l < 128L) {
            return null;
        }
        randomAccessFile.seek(l - 128L);
        byte[] byArray = new byte[30];
        randomAccessFile.readFully(byArray, 0, 3);
        String string2 = new String(byArray, 0, 3);
        if (!string2.equals("TAG")) {
            return null;
        }
        randomAccessFile.readFully(byArray, 0, 30);
        String string3 = new String(byArray, 0, ID3Reader.getTrimmedLength(byArray, 30));
        randomAccessFile.readFully(byArray, 0, 30);
        String string4 = new String(byArray, 0, ID3Reader.getTrimmedLength(byArray, 30));
        randomAccessFile.readFully(byArray, 0, 30);
        String string5 = new String(byArray, 0, ID3Reader.getTrimmedLength(byArray, 30));
        randomAccessFile.readFully(byArray, 0, 4);
        String string6 = new String(byArray, 0, ID3Reader.getTrimmedLength(byArray, 4));
        randomAccessFile.readFully(byArray, 0, 30);
        if (byArray[28] == 0) {
            s = (short)ByteOrder.ubyte2int(byArray[29]);
            n = 28;
        } else {
            s = 0;
            n = 30;
        }
        String string7 = new String(byArray, 0, ID3Reader.getTrimmedLength(byArray, n));
        randomAccessFile.readFully(byArray, 0, 1);
        short s2 = (short)ByteOrder.ubyte2int(byArray[0]);
        int n2 = new MP3Info(file.getCanonicalPath()).getBitRate();
        String string8 = "";
        if (bl) {
            string8 = string8 + "<audios noNamespaceSchemaLocation=\"" + schemaURI;
            string8 = string8 + "\"";
            string8 = string8 + "><audio ";
            string = file.getCanonicalPath();
            string8 = string8 + " identifier=\"" + string + "\"";
        }
        if (!string3.equals("")) {
            string8 = string8 + " title=\"" + string3 + "\"";
        }
        if (!string4.equals("")) {
            string8 = string8 + " artist=\"" + string4 + "\"";
        }
        if (!string5.equals("")) {
            string8 = string8 + " album=\"" + string5 + "\"";
        }
        if (s > 0) {
            string8 = string8 + " track=\"" + s + "\"";
        }
        if (!(string = this.getGenreString(s2)).equals("")) {
            string8 = string8 + " genre=\"" + string + "\"";
        }
        if (!string6.equals("")) {
            string8 = string8 + " year=\"" + string6 + "\"";
        }
        if (!string7.equals("")) {
            string8 = string8 + " comments=\"" + string7 + "\"";
        }
        if (n2 > 0) {
            string8 = string8 + " bitrate=\"" + n2 + "\"";
        }
        if (bl) {
            string8 = string8 + "/>";
            string8 = string8 + "</audios>";
        }
        randomAccessFile.close();
        return string8;
    }

    private static int getTrimmedLength(byte[] byArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0 && (byArray[n2] == 0 || byArray[n2] == 32)) {
            --n2;
        }
        return n2 + 1;
    }

    private String getGenreString(short s) {
        switch (s) {
            case 0: {
                return "Blues";
            }
            case 1: {
                return "Classic Rock";
            }
            case 2: {
                return "Country";
            }
            case 3: {
                return "Dance";
            }
            case 4: {
                return "Disco";
            }
            case 5: {
                return "Funk";
            }
            case 6: {
                return "Grunge";
            }
            case 7: {
                return "Hip-Hop";
            }
            case 8: {
                return "Jazz";
            }
            case 9: {
                return "Metal";
            }
            case 10: {
                return "New Age";
            }
            case 11: {
                return "Oldies";
            }
            case 12: {
                return "Other";
            }
            case 13: {
                return "Pop";
            }
            case 14: {
                return "R &amp; B";
            }
            case 15: {
                return "Rap";
            }
            case 16: {
                return "Reggae";
            }
            case 17: {
                return "Rock";
            }
            case 18: {
                return "Techno";
            }
            case 19: {
                return "Industrial";
            }
            case 20: {
                return "Alternative";
            }
            case 21: {
                return "Ska";
            }
            case 22: {
                return "Death Metal";
            }
            case 23: {
                return "Pranks";
            }
            case 24: {
                return "Soundtrack";
            }
            case 25: {
                return "Euro-Techno";
            }
            case 26: {
                return "Ambient";
            }
            case 27: {
                return "Trip-Hop";
            }
            case 28: {
                return "Vocal";
            }
            case 29: {
                return "Jazz+Funk";
            }
            case 30: {
                return "Fusion";
            }
            case 31: {
                return "Trance";
            }
            case 32: {
                return "Classical";
            }
            case 33: {
                return "Instrumental";
            }
            case 34: {
                return "Acid";
            }
            case 35: {
                return "House";
            }
            case 36: {
                return "Game";
            }
            case 37: {
                return "Sound Clip";
            }
            case 38: {
                return "Gospel";
            }
            case 39: {
                return "Noise";
            }
            case 40: {
                return "AlternRock";
            }
            case 41: {
                return "Bass";
            }
            case 42: {
                return "Soul";
            }
            case 43: {
                return "Punk";
            }
            case 44: {
                return "Space";
            }
            case 45: {
                return "Meditative";
            }
            case 46: {
                return "Instrumental Pop";
            }
            case 47: {
                return "Instrumental Rock";
            }
            case 48: {
                return "Ethnic";
            }
            case 49: {
                return "Gothic";
            }
            case 50: {
                return "Darkwave";
            }
            case 51: {
                return "Techno-Industrial";
            }
            case 52: {
                return "Electronic";
            }
            case 53: {
                return "Pop-Folk";
            }
            case 54: {
                return "Eurodance";
            }
            case 55: {
                return "Dream";
            }
            case 56: {
                return "Southern Rock";
            }
            case 57: {
                return "Comedy";
            }
            case 58: {
                return "Cult";
            }
            case 59: {
                return "Gangsta";
            }
            case 60: {
                return "Top 40";
            }
            case 61: {
                return "Christian Rap";
            }
            case 62: {
                return "Pop/Funk";
            }
            case 63: {
                return "Jungle";
            }
            case 64: {
                return "Native American";
            }
            case 65: {
                return "Cabaret";
            }
            case 66: {
                return "New Wave";
            }
            case 67: {
                return "Psychadelic";
            }
            case 68: {
                return "Rave";
            }
            case 69: {
                return "Showtunes";
            }
            case 70: {
                return "Trailer";
            }
            case 71: {
                return "Lo-Fi";
            }
            case 72: {
                return "Tribal";
            }
            case 73: {
                return "Acid Punk";
            }
            case 74: {
                return "Acid Jazz";
            }
            case 75: {
                return "Polka";
            }
            case 76: {
                return "Retro";
            }
            case 77: {
                return "Musical";
            }
            case 78: {
                return "Rock &amp; Roll";
            }
            case 79: {
                return "Hard Rock";
            }
            case 80: {
                return "Folk";
            }
            case 81: {
                return "Folk-Rock";
            }
            case 82: {
                return "National Folk";
            }
            case 83: {
                return "Swing";
            }
            case 84: {
                return "Fast Fusion";
            }
            case 85: {
                return "Bebob";
            }
            case 86: {
                return "Latin";
            }
            case 87: {
                return "Revival";
            }
            case 88: {
                return "Celtic";
            }
            case 89: {
                return "Bluegrass";
            }
            case 90: {
                return "Avantgarde";
            }
            case 91: {
                return "Gothic Rock";
            }
            case 92: {
                return "Progressive Rock";
            }
            case 93: {
                return "Psychedelic Rock";
            }
            case 94: {
                return "Symphonic Rock";
            }
            case 95: {
                return "Slow Rock";
            }
            case 96: {
                return "Big Band";
            }
            case 97: {
                return "Chorus";
            }
            case 98: {
                return "Easy Listening";
            }
            case 99: {
                return "Acoustic";
            }
            case 100: {
                return "Humour";
            }
            case 101: {
                return "Speech";
            }
            case 102: {
                return "Chanson";
            }
            case 103: {
                return "Opera";
            }
            case 104: {
                return "Chamber Music";
            }
            case 105: {
                return "Sonata";
            }
            case 106: {
                return "Symphony";
            }
            case 107: {
                return "Booty Bass";
            }
            case 108: {
                return "Primus";
            }
            case 109: {
                return "Porn Groove";
            }
            case 110: {
                return "Satire";
            }
            case 111: {
                return "Slow Jam";
            }
            case 112: {
                return "Club";
            }
            case 113: {
                return "Tango";
            }
            case 114: {
                return "Samba";
            }
            case 115: {
                return "Folklore";
            }
            case 116: {
                return "Ballad";
            }
            case 117: {
                return "Power Ballad";
            }
            case 118: {
                return "Rhythmic Soul";
            }
            case 119: {
                return "Freestyle";
            }
            case 120: {
                return "Duet";
            }
            case 121: {
                return "Punk Rock";
            }
            case 122: {
                return "Drum Solo";
            }
            case 123: {
                return "A capella";
            }
            case 124: {
                return "Euro-House";
            }
            case 125: {
                return "Dance Hall";
            }
        }
        return "";
    }
}

