/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.XMLTableLineComparator;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.util.StringTokenizer;

public class XMLTableLine
extends TableLine {
    private LimeXMLDocument doc;
    private LimeXMLSchema schema;
    private ResultPanel rp;

    public XMLTableLine(String string, Integer n, Integer n2, String string2, Integer n3, byte[] byArray, Long l, Integer n4, Integer n5, boolean bl, boolean bl2, LimeXMLDocument limeXMLDocument, LimeXMLSchema limeXMLSchema, ResultPanel resultPanel) {
        super(string, n, n2, string2, n3, byArray, l, n4, n5, bl, bl2);
        this.doc = limeXMLDocument;
        this.schema = limeXMLSchema;
        this.rp = resultPanel;
    }

    public TableLine createClone() {
        return new XMLTableLine(this.getFilename(), this.size, new Integer(this.speed.intValue()), this.location.getHostname(), new Integer(this.location.getPort()), this.clientGUID, this.index, this.quality, this.score, this.speed.isMeasured(), this.chatEnabled, this.doc, this.schema, this.rp);
    }

    public LimeXMLDocument getDocument() {
        return this.doc;
    }

    public LimeXMLSchema getSchema() {
        return this.schema;
    }

    public Object getValue(int n) {
        List list = this.schema.getCanonicalizedFields();
        if (n >= list.size()) {
            return "";
        }
        SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)list.get(n);
        String string = schemaFieldInfo.getCanonicalizedFieldName();
        String string2 = this.doc.getValue(string);
        if (string2 == null) {
            return "";
        }
        return string2;
    }

    public String getRequest() {
        String string = LimeXMLSchema.getDisplayString(this.doc.getSchemaURI());
        String string2 = "&mode=music";
        String string3 = "";
        if (string.equals("audio")) {
            Object object;
            String string4 = this.doc.getValue("audios__audio__artist__");
            if (string4 != null) {
                object = new StringTokenizer(string4);
                while (((StringTokenizer)object).hasMoreTokens()) {
                    string3 = string3 + "%20" + ((StringTokenizer)object).nextToken();
                }
            }
            if ((object = this.doc.getValue("audios__audio__album__")) != null) {
                string3 = string3 + "+";
                StringTokenizer stringTokenizer = new StringTokenizer((String)object);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + "%20" + stringTokenizer.nextToken();
                }
            }
            if (!string3.equals("")) {
                return string3 + string2;
            }
        } else if (string.equals("video")) {
            string2 = "&mode=vhs";
            String string5 = this.doc.getValue("videos__video__title__");
            if (string5 != null) {
                StringTokenizer stringTokenizer = new StringTokenizer(string5);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + "%20" + stringTokenizer.nextToken();
                }
            }
            if (!string3.equals("")) {
                return string3 + string2;
            }
        }
        return super.getRequest();
    }

    static Comparator newComparator(int n, boolean bl, LimeXMLSchema limeXMLSchema) {
        return new XMLTableLineComparator(n, bl, limeXMLSchema);
    }

    public RemoteFileDesc toRemoteFileDesc(ResultPanel resultPanel) {
        LimeXMLDocument[] limeXMLDocumentArray = new LimeXMLDocument[]{this.doc};
        return new RemoteFileDesc(this.location.getHostname(), this.location.getPort(), this.index, this.getFilename(), this.size, this.clientGUID, this.speed.intValue(), this.chatEnabled, this.getQuality(), limeXMLDocumentArray);
    }

    public int match(TableLine tableLine, ApproximateMatcher approximateMatcher) {
        if (!(tableLine instanceof XMLTableLine)) {
            return 3;
        }
        XMLTableLine xMLTableLine = (XMLTableLine)tableLine;
        if (xMLTableLine.getSchema() != this.schema) {
            return 3;
        }
        return super.matchInternal(tableLine, approximateMatcher);
    }

    public String toString() {
        return (String)this.getValue(this.rp.getFirstIndex());
    }
}

