/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.util.StringUtils;
import com.sun.java.util.collections.Comparator;

class TableLineComparator
implements Comparator {
    int field;
    boolean ascending;

    TableLineComparator(int n, boolean bl) {
        this.field = n;
        this.ascending = bl;
    }

    public int compare(Object object, Object object2) {
        TableLine tableLine = (TableLine)object;
        TableLine tableLine2 = (TableLine)object2;
        int n = this.ascending ? 1 : -1;
        switch (this.field) {
            case 1: {
                return n * StringUtils.compareIgnoreCase(tableLine.filenameWithoutExtension, tableLine2.filenameWithoutExtension);
            }
            case 2: {
                return n * StringUtils.compareIgnoreCase(tableLine.extension, tableLine2.extension);
            }
            case 3: {
                return n * -(tableLine.size - tableLine2.size);
            }
            case 4: {
                return n * -tableLine.speed.compareTo(tableLine2.speed);
            }
            case 5: {
                return n * -(tableLine.score - tableLine2.score);
            }
            case 0: {
                return n * -(tableLine.quality - tableLine2.quality);
            }
            case 6: {
                boolean bl = tableLine.chatEnabled;
                boolean bl2 = tableLine2.chatEnabled;
                if (bl == bl2) {
                    return 0;
                }
                if (bl && !bl2) {
                    return -n;
                }
                if (!bl && bl2) {
                    return n;
                }
            }
            case 7: {
                boolean bl;
                CachingEndpoint cachingEndpoint = tableLine.location;
                CachingEndpoint cachingEndpoint2 = tableLine2.location;
                int n2 = n * (cachingEndpoint2.numLocations() - cachingEndpoint.numLocations());
                if (n2 != 0) {
                    return n2;
                }
                boolean bl3 = cachingEndpoint.isPrivateAddress();
                if (bl3 != (bl = cachingEndpoint2.isPrivateAddress())) {
                    return n * (bl3 ? 1 : -1);
                }
                return n * StringUtils.compareIgnoreCase(tableLine.location.getHostname(), tableLine2.location.getHostname());
            }
        }
        return 0;
    }

    public boolean equals(Object object) {
        return false;
    }
}

