/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.TableLineComparator;
import com.limegroup.gnutella.gui.search.XMLTableLine;
import com.limegroup.gnutella.util.ApproximateMatcher;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.List;
import java.util.StringTokenizer;

public class TableLine {
    Integer size;
    byte[] clientGUID;
    Long index;
    private String processedFilename = null;
    volatile List children;
    int childName = 0;
    String filenameWithoutExtension;
    String extension;
    String sizeString;
    ResultSpeed speed;
    Integer score;
    Integer quality;
    CachingEndpoint location;
    Boolean chatEnabled;

    TableLine() {
        this.children = new ArrayList();
    }

    TableLine(String string, Integer n, Integer n2, String string2, Integer n3, byte[] byArray, Long l, Integer n4, Integer n5, boolean bl, boolean bl2) {
        this.speed = new ResultSpeed(n2, bl);
        this.size = n;
        this.clientGUID = byArray;
        this.index = l;
        this.children = null;
        this.score = n5;
        this.quality = n4;
        this.chatEnabled = new Boolean(bl2);
        int n6 = string.lastIndexOf(46);
        if (n6 == -1) {
            this.filenameWithoutExtension = string;
            this.extension = "";
        } else {
            this.filenameWithoutExtension = string.substring(0, n6);
            this.extension = string.substring(n6 + 1);
        }
        this.sizeString = GUIUtils.toKilobytes(n);
        this.location = new CachingEndpoint(string2, (int)n3);
    }

    TableLine createClone() {
        return new TableLine(this.getFilename(), this.size, new Integer(this.speed.intValue()), this.location.getHostname(), new Integer(this.location.getPort()), this.clientGUID, this.index, this.quality, this.score, this.speed.isMeasured(), this.chatEnabled);
    }

    static Comparator newComparator(int n, boolean bl) {
        return new TableLineComparator(n, bl);
    }

    void setSpeed(ResultSpeed resultSpeed) {
        this.speed = resultSpeed;
    }

    ResultSpeed getSpeed() {
        return this.speed;
    }

    void setQuality(int n) {
        this.quality = new Integer(n);
    }

    int getQuality() {
        return this.quality;
    }

    final boolean getChatEnabled() {
        return this.chatEnabled;
    }

    final void setChatEnabled(boolean bl) {
        this.chatEnabled = new Boolean(bl);
    }

    String getFilename() {
        if (this.extension.equals("")) {
            return this.filenameWithoutExtension;
        }
        return this.filenameWithoutExtension + "." + this.extension;
    }

    public Object getValue(int n) {
        switch (n) {
            case 1: {
                return this.filenameWithoutExtension;
            }
            case 2: {
                return this.extension;
            }
            case 3: {
                return this.sizeString;
            }
            case 4: {
                return this.getSpeed();
            }
            case 5: {
                return this.score;
            }
            case 7: {
                return this.location;
            }
            case 0: {
                return this.quality;
            }
            case 6: {
                return this.chatEnabled;
            }
        }
        Assert.that(false, "Bad column in table");
        return null;
    }

    String getRequest() {
        String string = "-_*~ ";
        StringTokenizer stringTokenizer = new StringTokenizer(this.filenameWithoutExtension, string);
        String string2 = "";
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + "%20" + stringTokenizer.nextToken();
        }
        return string2 + "&mode=music";
    }

    void unMutate() {
        if (this.children != null) {
            TableLine tableLine = (TableLine)this.children.get(0);
            this.location = tableLine.location;
            this.speed = tableLine.speed;
            this.quality = tableLine.quality;
        }
        this.children = null;
    }

    int match(TableLine tableLine, ApproximateMatcher approximateMatcher) {
        if (tableLine instanceof XMLTableLine) {
            return 3;
        }
        return this.matchInternal(tableLine, approximateMatcher);
    }

    protected int matchInternal(TableLine tableLine, ApproximateMatcher approximateMatcher) {
        float f;
        if (this.processedFilename == null) {
            this.processedFilename = approximateMatcher.process(this.filenameWithoutExtension);
        }
        if (tableLine.processedFilename == null) {
            tableLine.processedFilename = approximateMatcher.process(tableLine.filenameWithoutExtension);
        }
        if (!this.extension.equals(tableLine.extension)) {
            return 1;
        }
        float f2 = this.size.intValue();
        if (f2 == (f = (float)tableLine.size.intValue()) && f2 > 1000000.0f) {
            return 0;
        }
        float f3 = Math.abs(f2 - f);
        if (f3 > 60000.0f) {
            return 2;
        }
        int n = Math.round(Math.min(0.1f * (float)this.filenameWithoutExtension.length(), 0.1f * (float)tableLine.filenameWithoutExtension.length()));
        if (!approximateMatcher.matches(this.processedFilename, tableLine.processedFilename, n = Math.min(n, 4))) {
            return 3;
        }
        return 0;
    }

    public RemoteFileDesc toRemoteFileDesc(ResultPanel resultPanel) {
        LimeXMLDocument[] limeXMLDocumentArray = resultPanel.getCorrespondingDocs(this.clientGUID, this.index);
        return new RemoteFileDesc(this.location.getHostname(), this.location.getPort(), this.index, this.getFilename(), this.size, this.clientGUID, this.speed.intValue(), this.chatEnabled, this.getQuality(), limeXMLDocumentArray);
    }

    public String toString() {
        return this.filenameWithoutExtension;
    }

    final boolean hasChildren() {
        return this.children != null;
    }

    final void doChat() {
        if (!this.getChatEnabled()) {
            return;
        }
        String string = this.getChatEnabledHost();
        if (string == null) {
            return;
        }
        int n = this.getChatEnabledPort();
        if (n == -1) {
            return;
        }
        RouterService routerService = GUIMediator.instance().getRouter();
        routerService.createChat(string, n);
    }

    private final String getChatEnabledHost() {
        if (!this.getChatEnabled()) {
            return null;
        }
        if (!this.hasChildren()) {
            return this.location.getHostname();
        }
        int n = 0;
        while (n < this.children.size()) {
            TableLine tableLine = (TableLine)this.children.get(n);
            if (tableLine.getChatEnabled()) {
                return tableLine.location.getHostname();
            }
            ++n;
        }
        return null;
    }

    private final int getChatEnabledPort() {
        if (!this.getChatEnabled()) {
            return -1;
        }
        if (!this.hasChildren()) {
            return this.location.getPort();
        }
        int n = 0;
        while (n < this.children.size()) {
            TableLine tableLine = (TableLine)this.children.get(n);
            if (tableLine.getChatEnabled()) {
                return tableLine.location.getPort();
            }
            ++n;
        }
        return -1;
    }
}

