/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.RemoteFileDesc;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.downloader.AlreadyDownloadingException;
import com.limegroup.gnutella.downloader.FileExistsException;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.GUIUtils;
import com.limegroup.gnutella.gui.MultiLineLabel;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.search.BuyListener;
import com.limegroup.gnutella.gui.search.CancelSearchIconProxy;
import com.limegroup.gnutella.gui.search.DownloadAllAction;
import com.limegroup.gnutella.gui.search.DownloadAnyAction;
import com.limegroup.gnutella.gui.search.NamedMediaType;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.TabbedPaneMouseListener;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.XMLTableLine;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.gui.MetaDisplayFrame;
import com.limegroup.gnutella.xml.gui.MetaSearchFrame;
import com.limegroup.gnutella.xml.gui.ViewChooserDialog;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import com.sun.java.util.collections.Map;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class StandardSearchView
extends PaddedPanel {
    private JButton searchButton;
    private JTextField searchField;
    private JButton stopButton;
    private JButton closeButton;
    private JComboBox searchMediaBox;
    private JLabel searchIconLabel;
    private ImageIcon searchingIcon;
    private ImageIcon notsearchingIcon;
    private CancelSearchIconProxy killIcon;
    private Timer animationStopper;
    private JLabel searchLabel;
    private JTextField minConnSpeed;
    private JButton downloadAnyButton;
    static final String DOWNLOAD_ANY_STRING = GUIMediator.getStringResource("SEARCH_DOWNLOAD_ANY_BUTTON_LABEL");
    private JButton downloadAllButton;
    static final String DOWNLOAD_ALL_STRING = GUIMediator.getStringResource("SEARCH_DOWNLOAD_ALL_BUTTON_LABEL");
    private JButton killButton;
    static final String KILL_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_KILL_STRING");
    static final String STOP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_STOP_STRING");
    static final String VIEW_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_VIEW_STRING");
    private JCheckBox groupBox;
    static final String GROUP_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_GROUP_STRING");
    static final String SHOW_META_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_SHOW_META_STRING");
    static final String BROWSE_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_BROWSE_STRING");
    static final String CHAT_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_CHAT_STRING");
    static final String REPEAT_SEARCH_STRING = GUIMediator.getStringResource("SEARCH_PUBLIC_REPEAT_SEARCH_STRING");
    private static final GUID stoppedGUID = new GUID(GUID.makeGuid());
    protected final List entries = new LinkedList();
    private static final int LABEL_SIZE = 10;
    private JTabbedPane tabbedPane;
    JPanel results;
    CardLayout switcher;
    private JPopupMenu menu;
    private HashMap itemsToSchemaURI;
    private Properties imageProps;
    private HashMap dispStrsToIcons;
    private ButtonRow rowSpecificButtonRow;
    private ButtonRow generalButtonRow;
    static final int DOWNLOAD_ANY_BUTTON_INDEX = 0;
    static final int DOWNLOAD_ALL_BUTTON_INDEX = 1;
    static final int CHAT_BUTTON_INDEX = 2;
    static final int BUY_BUTTON_INDEX = 3;
    static final int CHANGE_BUTTON_INDEX = 0;

    StandardSearchView() {
        super(GUIMediator.getStringResource("SEARCH_TITLE"));
        Object object;
        Accessible accessible;
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        JPanel jPanel2 = new JPanel();
        FlowLayout flowLayout = new FlowLayout();
        jPanel2.setLayout(flowLayout);
        this.searchField = new JTextField(18);
        this.itemsToSchemaURI = new HashMap();
        this.imageProps = new Properties();
        LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
        String string = limeXMLProperties.getXMLImagesDir();
        try {
            this.imageProps.load(new FileInputStream(new File(string, "image.props")));
            this.dispStrsToIcons = new HashMap();
        }
        catch (IOException iOException) {
            this.imageProps = new Properties();
        }
        this.searchMediaBox = new JComboBox<NamedMediaType>(NamedMediaType.convertMediaTypes(MediaType.getDefaultMediaTypes()));
        LimeXMLSchemaRepository limeXMLSchemaRepository = LimeXMLSchemaRepository.instance();
        String[] stringArray = limeXMLSchemaRepository.getAvailableSchemaURIs();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object object2;
            String string2 = stringArray[n2];
            String string3 = LimeXMLSchema.getDisplayString(string2);
            if (this.dispStrsToIcons != null) {
                object2 = this.imageProps.getProperty(string3);
                accessible = null;
                if (object2 != null) {
                    accessible = GUIMediator.getImageResource((String)object2);
                }
                if (accessible != null) {
                    object = new CancelSearchIconProxy((Icon)((Object)accessible));
                    this.dispStrsToIcons.put((Object)string3, object);
                }
            }
            string3 = LimeXMLUtils.capitalizeFirst(string3) + "...";
            object2 = new MediaType(string3, null);
            this.searchMediaBox.addItem(new NamedMediaType((MediaType)object2));
            this.itemsToSchemaURI.put((Object)string3, (Object)string2);
            ++n2;
        }
        this.searchButton = new JButton(GUIMediator.getStringResource("SEARCH_SEARCH_BUTTON_LABEL"));
        this.stopButton = new JButton(GUIMediator.getStringResource("SEARCH_STOP_BUTTON_LABEL"));
        this.stopButton.setToolTipText(GUIMediator.getStringResource("SEARCH_STOP_BUTTON_TIP"));
        int n3 = this.searchMediaBox.getPreferredSize().width;
        int n4 = this.searchButton.getPreferredSize().height;
        this.searchMediaBox.setPreferredSize(new Dimension(n3, n4));
        this.searchButton.setToolTipText(GUIMediator.getStringResource("SEARCH_SEARCH_BUTTON_TIP"));
        jPanel2.add(this.searchField);
        jPanel2.add(this.searchMediaBox);
        jPanel2.add(this.searchButton);
        jPanel2.add(this.stopButton);
        jPanel.add((Component)jPanel2, "West");
        this.searchingIcon = GUIMediator.getImageResource("searching.gif");
        this.notsearchingIcon = GUIMediator.getImageResource("notsearching.gif");
        this.killIcon = new CancelSearchIconProxy();
        this.searchIconLabel = new JLabel(this.notsearchingIcon);
        this.searchIconLabel.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 14));
        jPanel.add((Component)this.searchIconLabel, "East");
        this.add(jPanel);
        int n5 = 20000;
        this.animationStopper = new Timer(n5, new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                JLabel jLabel = StandardSearchView.this.searchIconLabel;
                synchronized (jLabel) {
                    StandardSearchView.this.searchIconLabel.setIcon(StandardSearchView.this.notsearchingIcon);
                }
            }
        });
        this.animationStopper.setRepeats(false);
        accessible = new JPanel();
        ((Container)((Object)accessible)).setLayout(new BorderLayout());
        this.searchLabel = new JLabel("                  ");
        ((Container)((Object)accessible)).add(this.searchLabel, "West");
        object = new JPanel();
        ((Container)object).setLayout(new FlowLayout());
        JLabel jLabel = new JLabel("Minimum connection speed (kbps)");
        this.minConnSpeed = new JTextField("0", 3);
        ((Container)object).add(jLabel);
        ((Container)object).add(this.minConnSpeed);
        ((Container)((Object)accessible)).add((Component)object, "East");
        this.results = new JPanel();
        this.results.setPreferredSize(new Dimension(10000, 10000));
        this.switcher = new CardLayout();
        this.results.setLayout(this.switcher);
        JPanel jPanel3 = new JPanel();
        jPanel3.setLayout(new BorderLayout());
        JLabel jLabel2 = new JLabel(GUIMediator.getStringResource("SEARCH_RESULT_TABLE_LABEL"));
        jLabel2.setBorder(BorderFactory.createEmptyBorder(10, 0, 0, 0));
        jPanel3.add((Component)jLabel2, "North");
        jPanel3.add((Component)new ResultPanel(this, new GUID(new byte[16]), "", null, true, null, null), "Center");
        this.results.add("dummy", jPanel3);
        this.tabbedPane = new JTabbedPane();
        this.results.add("tabbedPane", this.tabbedPane);
        this.switcher.first(this.results);
        this.add(this.results);
        this.tabbedPane.addMouseListener(new TabbedPaneMouseListener(this));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                JTabbedPane jTabbedPane = (JTabbedPane)changeEvent.getSource();
                int n = jTabbedPane.getTabCount();
                ResultPanel resultPanel = (ResultPanel)jTabbedPane.getSelectedComponent();
                if (resultPanel != null && resultPanel.getRowsSelected()) {
                    resultPanel.handlePanelSelection();
                } else {
                    StandardSearchView.this.setHostButtonsEnabled(false);
                }
            }
        });
        String[] stringArray2 = new String[]{"SEARCH_DOWNLOAD_ANY_BUTTON_LABEL", "SEARCH_DOWNLOAD_ALL_BUTTON_LABEL", "SEARCH_CHAT_BUTTON_LABEL", "SEARCH_BUY_CD_LABEL"};
        String[] stringArray3 = new String[]{"SEARCH_DOWNLOAD_ANY_BUTTON_TIP", "SEARCH_DOWNLOAD_ALL_BUTTON_TIP", "SEARCH_CHAT_BUTTON_TIP", "SEARCH_BUY_CD_TIP"};
        String[] stringArray4 = new String[]{"SEARCH_CHANGE_VIEW_BUTTON_LABEL"};
        String[] stringArray5 = new String[]{"SEARCH_CHANGE_VIEW_BUTTON_TIP"};
        DownloadAnyAction downloadAnyAction = new DownloadAnyAction(this);
        DownloadAllAction downloadAllAction = new DownloadAllAction(this);
        ActionListener actionListener = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel resultPanel = StandardSearchView.this.getActiveResultPanel();
                if (resultPanel == null) {
                    return;
                }
                String string = resultPanel.getCurrentSchemaString().toLowerCase();
                Map map = resultPanel.getDisplayToSchemaMap();
                ViewChooserDialog viewChooserDialog = new ViewChooserDialog(resultPanel, map, string);
                viewChooserDialog.show();
            }
        };
        ActionListener actionListener2 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardSearchView.this.doChat();
            }
        };
        BuyListener buyListener = new BuyListener(this);
        ActionListener[] actionListenerArray = new ActionListener[]{downloadAnyAction, downloadAllAction, actionListener2, buyListener};
        ActionListener[] actionListenerArray2 = new ActionListener[]{actionListener};
        this.rowSpecificButtonRow = new ButtonRow(stringArray2, stringArray3, actionListenerArray);
        this.generalButtonRow = new ButtonRow(stringArray4, stringArray5, actionListenerArray2);
        this.setHostButtonsEnabled(false);
        JPanel jPanel4 = new JPanel();
        jPanel4.add(this.rowSpecificButtonRow);
        jPanel4.add(Box.createHorizontalStrut(15));
        jPanel4.add(this.generalButtonRow);
        this.groupBox = new JCheckBox(GROUP_STRING, true);
        this.groupBox.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                StandardSearchView.this.setGrouped(StandardSearchView.this.groupBox.isSelected());
            }
        });
        jPanel4.add(this.groupBox);
        this.add(jPanel4);
        this.searchButton.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                StandardSearchView.this.triggerSearch();
            }
        });
        this.searchField.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                StandardSearchView.this.triggerSearch();
            }
        });
        ActionListener actionListener3 = new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                StandardSearchView.this.stopSearch();
            }
        };
        this.stopButton.addActionListener(actionListener3);
        this.searchMediaBox.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                String string = ((NamedMediaType)StandardSearchView.this.searchMediaBox.getSelectedItem()).toString();
                if (string.endsWith("...")) {
                    String string2 = (String)StandardSearchView.this.itemsToSchemaURI.get((Object)string);
                    StandardSearchView.this.searchMediaBox.setSelectedIndex(0);
                    StandardSearchView.this.metaLauncher(string2);
                }
            }
        });
    }

    final void showMenu(int n, int n2) {
        ResultPanel resultPanel;
        List list = this.entries;
        synchronized (list) {
            int n3 = this.tabbedPane.getSelectedIndex();
            if (n3 == -1) {
                return;
            }
            try {
                resultPanel = (ResultPanel)this.entries.get(n3);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                return;
            }
        }
        this.menu = resultPanel.getPopup();
        this.menu.show(this.tabbedPane, n, n2);
    }

    final Icon getSelectedIcon() {
        return this.tabbedPane.getIconAt(this.tabbedPane.getSelectedIndex());
    }

    private void metaLauncher(String string) {
        MetaSearchFrame metaSearchFrame = new MetaSearchFrame(this, string);
        metaSearchFrame.show();
    }

    final boolean isSelectedPanel(ResultPanel resultPanel) {
        Component component = this.tabbedPane.getSelectedComponent();
        return component.equals(resultPanel);
    }

    final void setHostButtonsEnabled(boolean bl) {
        this.setBuyButtonEnabled(bl);
        this.setChatButtonEnabled(bl);
        this.setDownloadAnyButtonEnabled(bl);
        this.setDownloadAllButtonEnabled(bl);
        this.setViewChangeButtonEnabled();
    }

    final void setButtonEnabled(int n, boolean bl) {
        this.rowSpecificButtonRow.setButtonEnabled(n, bl);
    }

    final void setBuyButtonEnabled(boolean bl) {
        this.rowSpecificButtonRow.setButtonEnabled(3, bl);
    }

    final void setViewChangeButtonEnabled() {
        int n;
        boolean bl = false;
        ResultPanel resultPanel = (ResultPanel)this.tabbedPane.getSelectedComponent();
        bl = resultPanel == null ? false : ((n = resultPanel.getViewCount()) >= 2 ? true : resultPanel.getSchema() != null && n == 1);
        this.generalButtonRow.setButtonEnabled(0, bl);
    }

    final void setChatButtonEnabled(boolean bl) {
        this.rowSpecificButtonRow.setButtonEnabled(2, bl);
    }

    final void setDownloadAnyButtonEnabled(boolean bl) {
        this.rowSpecificButtonRow.setButtonEnabled(0, bl);
    }

    final void setDownloadAllButtonEnabled(boolean bl) {
        this.rowSpecificButtonRow.setButtonEnabled(1, bl);
    }

    void showMetaResult() {
        ResultPanel resultPanel;
        List list = this.entries;
        synchronized (list) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n < 0) {
                return;
            }
            resultPanel = (ResultPanel)this.entries.get(n);
            if (!resultPanel.hasValidSchema()) {
                return;
            }
        }
        ResultPanel resultPanel2 = resultPanel;
        synchronized (resultPanel2) {
            Iterator iterator = resultPanel.getSelectedRows();
            XMLTableLine xMLTableLine = null;
            while (iterator.hasNext()) {
                xMLTableLine = (XMLTableLine)iterator.next();
            }
            if (xMLTableLine == null) {
                return;
            }
            long l = xMLTableLine.index;
            LimeXMLDocument limeXMLDocument = xMLTableLine.getDocument();
            MetaDisplayFrame metaDisplayFrame = new MetaDisplayFrame(limeXMLDocument, l, this, xMLTableLine, resultPanel);
            if (metaDisplayFrame.isValid()) {
                metaDisplayFrame.show();
            }
        }
    }

    byte[] repeatSearch(MediaType mediaType, String string, String string2, String string3) {
        if (string.equals("")) {
            return null;
        }
        if (!this.validateQueryString(string)) {
            return null;
        }
        int n = 0;
        byte[] byArray = string2 == null ? GUIMediator.instance().getRouter().query(string, n, mediaType) : GUIMediator.instance().getRouter().query(string, string2, n, mediaType, string3);
        final GUID gUID = new GUID(byArray);
        Runnable runnable = new Runnable(){

            public void run() {
                StandardSearchView.this.setHostButtonsEnabled(false);
                StandardSearchView.this.searchLabel.setText(GUIMediator.getStringResource("SEARCH_SEARCHING_LABEL"));
                StandardSearchView.this.searchField.setText("");
                JTabbedPane jTabbedPane = StandardSearchView.this.tabbedPane;
                synchronized (jTabbedPane) {
                    ResultPanel resultPanel = (ResultPanel)StandardSearchView.this.tabbedPane.getSelectedComponent();
                    resultPanel.setGUID(gUID);
                    JLabel jLabel = StandardSearchView.this.searchIconLabel;
                    synchronized (jLabel) {
                        StandardSearchView.this.searchIconLabel.setIcon(StandardSearchView.this.searchingIcon);
                    }
                    StandardSearchView.this.animationStopper.restart();
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
        return byArray;
    }

    byte[] triggerSearch(String string) {
        this.searchField.setText(string);
        return this.triggerSearch();
    }

    private static boolean isGreedy(String string) {
        if (string.equals("*.*")) {
            return true;
        }
        String string2 = string.toLowerCase().replace('*', ' ').replace('.', ' ').trim();
        return string2.equals("mp3") || string2.equals("mpg") || string2.equals("asf") || string2.equals("jpg") || string2.equals("mpeg") || string2.equals("gif");
    }

    byte[] triggerSearch() {
        String string = this.searchField.getText().trim();
        if (string.equals("")) {
            return null;
        }
        if (!this.validateQueryString(string)) {
            return null;
        }
        int n = 0;
        NamedMediaType namedMediaType = (NamedMediaType)this.searchMediaBox.getSelectedItem();
        MediaType mediaType = namedMediaType.getUnderLyingMediaType();
        byte[] byArray = GUIMediator.instance().getRouter().query(string, n, mediaType);
        GUID gUID = new GUID(byArray);
        this.addResultTab(gUID, string);
        this.setHostButtonsEnabled(false);
        return byArray;
    }

    private boolean validateQueryString(String string) {
        if (string.length() <= 2 && !"U2".equals(string) && !"u2".equals(string)) {
            GUIMediator.showError("ERROR_THREE_CHARACTER_SEARCH");
            return false;
        }
        if (StandardSearchView.isGreedy(string)) {
            boolean bl = false;
            String string2 = "ERROR_NETWORK_FLOODING";
            int n = GUIMediator.showYesNoMessage(string2);
            if (n != 101) {
                return false;
            }
        }
        return true;
    }

    public ResultPanel addResultTab(GUID gUID, String string) {
        return this.addResultTab(gUID, string, null, null);
    }

    void changeViewIcon(LimeXMLSchema limeXMLSchema, ResultPanel resultPanel) {
        Object object;
        int n = -1;
        List list = this.entries;
        synchronized (list) {
            int n2 = 0;
            while (n2 < this.entries.size()) {
                object = this.entries.get(n2);
                if (object == resultPanel) {
                    n = n2;
                    break;
                }
                ++n2;
            }
        }
        if (n == -1) {
            return;
        }
        CancelSearchIconProxy cancelSearchIconProxy = null;
        if (limeXMLSchema == null) {
            cancelSearchIconProxy = new CancelSearchIconProxy();
        } else {
            object = LimeXMLSchema.getDisplayString(limeXMLSchema.getSchemaURI());
            cancelSearchIconProxy = (CancelSearchIconProxy)this.dispStrsToIcons.get(object);
        }
        if (cancelSearchIconProxy == null) {
            cancelSearchIconProxy = new CancelSearchIconProxy();
        }
        this.killIcon = cancelSearchIconProxy;
        this.tabbedPane.setIconAt(n, this.killIcon);
    }

    public ResultPanel addResultTab(GUID gUID, String string, LimeXMLSchema limeXMLSchema, String string2) {
        Object object;
        CancelSearchIconProxy cancelSearchIconProxy;
        NamedMediaType namedMediaType = (NamedMediaType)this.searchMediaBox.getSelectedItem();
        MediaType mediaType = namedMediaType.getUnderLyingMediaType();
        final String string3 = string;
        final ResultPanel resultPanel = new ResultPanel(this, gUID, string, mediaType, this.groupBox.isSelected(), limeXMLSchema, string2);
        this.killIcon = limeXMLSchema != null ? ((cancelSearchIconProxy = (CancelSearchIconProxy)this.dispStrsToIcons.get(object = LimeXMLSchema.getDisplayString(limeXMLSchema.getSchemaURI()))) != null ? cancelSearchIconProxy : new CancelSearchIconProxy()) : new CancelSearchIconProxy();
        object = new Runnable(){

            public void run() {
                StandardSearchView.this.searchLabel.setText(GUIMediator.getStringResource("SEARCH_SEARCHING_LABEL"));
                StandardSearchView.this.searchField.setText("");
                List list = StandardSearchView.this.entries;
                synchronized (list) {
                    StandardSearchView.this.entries.add((Object)resultPanel);
                    StandardSearchView.this.tabbedPane.addTab(string3, StandardSearchView.this.killIcon, resultPanel);
                    StandardSearchView.this.tabbedPane.setSelectedIndex(StandardSearchView.this.entries.size() - 1);
                    if (StandardSearchView.this.entries.size() > SettingsManager.instance().getParallelSearchMax()) {
                        StandardSearchView.this.entries.remove(0);
                        StandardSearchView.this.tabbedPane.removeTabAt(0);
                    }
                }
                JLabel jLabel = StandardSearchView.this.searchIconLabel;
                synchronized (jLabel) {
                    StandardSearchView.this.searchIconLabel.setIcon(StandardSearchView.this.searchingIcon);
                }
                StandardSearchView.this.animationStopper.restart();
                StandardSearchView.this.switcher.last(StandardSearchView.this.results);
                StandardSearchView.this.revalidate();
            }
        };
        SwingUtilities.invokeLater((Runnable)object);
        return resultPanel;
    }

    void addQueryReply(TableLine tableLine, TableLine tableLine2, ResultPanel resultPanel, int n) {
        ResultPanel resultPanel2 = resultPanel;
        synchronized (resultPanel2) {
            resultPanel.addLine(tableLine, tableLine2);
        }
        List list = this.entries;
        synchronized (list) {
            try {
                if (this.entries.get(n) != resultPanel) {
                    n = -1;
                }
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                n = -1;
            }
            if (n == -1) {
                int n2 = 0;
                while (n2 < this.entries.size()) {
                    Object object = this.entries.get(n2);
                    if (object == resultPanel) {
                        n = n2;
                        break;
                    }
                    ++n2;
                }
            }
            if (n == -1) {
                return;
            }
            this.tabbedPane.setTitleAt(n, resultPanel.getQuery() + " (" + resultPanel.numResults() + ")");
        }
        this.animationStopper.restart();
    }

    void doDownload(boolean bl) {
        ResultPanel resultPanel;
        List list = this.entries;
        synchronized (list) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n < 0) {
                return;
            }
            resultPanel = (ResultPanel)this.entries.get(n);
        }
        if (bl) {
            this.downloadAny(resultPanel);
        } else {
            this.downloadAll(resultPanel);
        }
    }

    private void downloadAny(ResultPanel resultPanel) {
        Object[] objectArray;
        ArrayList arrayList = new ArrayList();
        ResultPanel resultPanel2 = resultPanel;
        synchronized (resultPanel2) {
            objectArray = resultPanel.getSelectedRows();
            while (objectArray.hasNext()) {
                TableLine tableLine = (TableLine)objectArray.next();
                if (tableLine.children != null) {
                    int n = 0;
                    while (n < tableLine.children.size()) {
                        TableLine tableLine2 = (TableLine)tableLine.children.get(n);
                        RemoteFileDesc remoteFileDesc = tableLine2.toRemoteFileDesc(resultPanel);
                        if (!arrayList.contains((Object)remoteFileDesc)) {
                            arrayList.add((Object)remoteFileDesc);
                        }
                        ++n;
                    }
                    continue;
                }
                RemoteFileDesc remoteFileDesc = tableLine.toRemoteFileDesc(resultPanel);
                if (arrayList.contains((Object)remoteFileDesc)) continue;
                arrayList.add((Object)remoteFileDesc);
            }
        }
        objectArray = new RemoteFileDesc[arrayList.size()];
        arrayList.toArray(objectArray);
        this.downloadWithOverwritePrompt((RemoteFileDesc[])objectArray);
    }

    void buyCD() {
        Object object;
        TableLine tableLine = null;
        List list = this.entries;
        synchronized (list) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n < 0) {
                return;
            }
            ResultPanel resultPanel = (ResultPanel)this.entries.get(n);
            object = resultPanel.getSelectedRows();
            if (!object.hasNext()) {
                return;
            }
            tableLine = (TableLine)object.next();
        }
        String string = tableLine.getRequest();
        object = "http://www.limewire.com/buystuff?tag=wwwlimewireco-20&keyword=";
        String string2 = (String)object + string;
        try {
            GUIMediator.instance();
            GUIMediator.openURL(string2);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    final void doChat() {
        ResultPanel resultPanel = (ResultPanel)this.tabbedPane.getSelectedComponent();
        if (resultPanel == null) {
            return;
        }
        if (!resultPanel.getRowsSelected()) {
            return;
        }
        TableLine tableLine = resultPanel.getFirstSelectedTableLine();
        if (tableLine == null) {
            return;
        }
        tableLine.doChat();
    }

    private void downloadAll(ResultPanel resultPanel) {
        Iterator iterator;
        ArrayList arrayList = new ArrayList();
        ResultPanel resultPanel2 = resultPanel;
        synchronized (resultPanel2) {
            iterator = resultPanel.getSelectedRows();
            while (iterator.hasNext()) {
                Object object;
                int n;
                RemoteFileDesc[] remoteFileDescArray;
                TableLine tableLine = (TableLine)iterator.next();
                if (tableLine.children != null) {
                    remoteFileDescArray = new RemoteFileDesc[tableLine.children.size()];
                    n = 0;
                    while (n < remoteFileDescArray.length) {
                        RemoteFileDesc remoteFileDesc;
                        object = (TableLine)tableLine.children.get(n);
                        remoteFileDescArray[n] = remoteFileDesc = ((TableLine)object).toRemoteFileDesc(resultPanel);
                        ++n;
                    }
                    arrayList.add((Object)remoteFileDescArray);
                    continue;
                }
                remoteFileDescArray = tableLine.toRemoteFileDesc(resultPanel);
                n = 0;
                if (!arrayList.isEmpty()) {
                    object = (RemoteFileDesc[])arrayList.get(arrayList.size() - 1);
                    int n2 = 0;
                    while (n2 < ((Object)object).length) {
                        if (((RemoteFileDesc)object[n2]).equals(remoteFileDescArray)) {
                            n = 1;
                            break;
                        }
                        ++n2;
                    }
                }
                if (n != 0) continue;
                arrayList.add((Object)new RemoteFileDesc[]{remoteFileDescArray});
            }
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            this.downloadWithOverwritePrompt((RemoteFileDesc[])iterator.next());
        }
    }

    public void downloadWithOverwritePrompt(RemoteFileDesc[] remoteFileDescArray) {
        String string;
        LimeXMLDocument[] limeXMLDocumentArray;
        if (remoteFileDescArray.length < 1) {
            return;
        }
        if (this.containsExe(remoteFileDescArray) && !this.userWantsExeDownload()) {
            return;
        }
        int n = 0;
        boolean bl = false;
        while (n < remoteFileDescArray.length) {
            if (remoteFileDescArray[n].getIndex() == 0xFFFFFFFFL) {
                bl = true;
                break;
            }
            ++n;
        }
        if (bl) {
            limeXMLDocumentArray = remoteFileDescArray[n].getXMLDocs();
            int n2 = 0;
            while (n2 < limeXMLDocumentArray.length) {
                string = limeXMLDocumentArray[n2].getAction();
                if (string != null && !string.equals("")) {
                    try {
                        GUIMediator.instance();
                        GUIMediator.openURL(string);
                    }
                    catch (IOException iOException) {
                        return;
                    }
                    return;
                }
                ++n2;
            }
        }
        limeXMLDocumentArray = GUIMediator.instance().getRouter();
        try {
            try {
                limeXMLDocumentArray.download(remoteFileDescArray, false);
            }
            catch (FileExistsException fileExistsException) {
                string = fileExistsException.getFileName();
                String string2 = "MESSAGE_OVERWRITE_EXISTING_FILE";
                String string3 = "(" + string + ")?";
                int n3 = GUIMediator.showYesNoMessage(string2, string3);
                if (n3 != 101) {
                    return;
                }
                try {
                    limeXMLDocumentArray.download(remoteFileDescArray, true);
                }
                catch (FileExistsException fileExistsException2) {
                    Assert.that(false, "download(rfd, true) threw unexpected exception");
                }
            }
        }
        catch (AlreadyDownloadingException alreadyDownloadingException) {
            GUIMediator.showError("ERROR_ALREADY_DOWNLOADING", "\"" + alreadyDownloadingException.getFilename() + "\".");
        }
        catch (FileNotFoundException fileNotFoundException) {
            GUIMediator.showError("ERROR_ACCESSING_SAVE_DIRECTORY");
        }
    }

    private boolean containsExe(RemoteFileDesc[] remoteFileDescArray) {
        int n = 0;
        while (n < remoteFileDescArray.length) {
            if (remoteFileDescArray[n].getFileName().toLowerCase().endsWith("exe")) {
                return true;
            }
            ++n;
        }
        return false;
    }

    private boolean userWantsExeDownload() {
        SettingsManager settingsManager = SettingsManager.instance();
        if (!settingsManager.getPromptExeDownload()) {
            return true;
        }
        String string = GUIMediator.getStringResource("SEARCH_VIRUS_MSG_ONE") + " " + GUIMediator.getStringResource("SEARCH_VIRUS_MSG_TWO") + " " + GUIMediator.getStringResource("SEARCH_VIRUS_MSG_THREE");
        MultiLineLabel multiLineLabel = GUIUtils.getSizedLabel(string);
        JCheckBox jCheckBox = new JCheckBox(GUIMediator.getStringResource("SEARCH_SHOW_MESSAGE_MSG"), false);
        jCheckBox.setForeground((Color)UIManager.get("Label.foreground"));
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)multiLineLabel, "Center");
        jPanel.add((Component)jCheckBox, "South");
        int n = JOptionPane.showConfirmDialog(this, jPanel, GUIMediator.getStringResource("SEARCH_DOWNLOAD_DIALOG_CONFIRM"), 0);
        SettingsManager.instance().setPromptExeDownload(!jCheckBox.isSelected());
        return n == 0;
    }

    void setTabDisplayCount(ResultPanel resultPanel) {
        int n = 0;
        boolean bl = false;
        List list = this.entries;
        synchronized (list) {
            while (n < this.entries.size()) {
                Object object = this.entries.get(n);
                if (object == resultPanel) {
                    bl = true;
                    break;
                }
                ++n;
            }
            if (bl) {
                this.tabbedPane.setTitleAt(n, resultPanel.getQuery() + " (" + resultPanel.numResults() + ")");
            }
        }
    }

    private void setGrouped(boolean bl) {
        List list = this.entries;
        synchronized (list) {
            int n = 0;
            while (n < this.entries.size()) {
                ResultPanel resultPanel = (ResultPanel)this.entries.get(n);
                resultPanel.setGrouped(bl);
                ++n;
            }
        }
    }

    private ResultPanel getActiveResultPanel() {
        ResultPanel resultPanel;
        List list = this.entries;
        synchronized (list) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n == -1) {
                ResultPanel resultPanel2 = null;
                return resultPanel2;
            }
            try {
                resultPanel = (ResultPanel)this.entries.get(n);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                ResultPanel resultPanel3 = null;
                return resultPanel3;
            }
        }
        return resultPanel;
    }

    void killSearch() {
        List list = this.entries;
        synchronized (list) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n == -1) {
                return;
            }
            this.entries.remove(n);
            this.tabbedPane.removeTabAt(n);
            if (this.entries.size() == 0) {
                this.switcher.first(this.results);
                JLabel jLabel = this.searchIconLabel;
                synchronized (jLabel) {
                    this.searchIconLabel.setIcon(this.notsearchingIcon);
                }
            } else {
                this.checkToStopLime();
            }
        }
    }

    void stopSearch() {
        List list = this.entries;
        synchronized (list) {
            int n = this.tabbedPane.getSelectedIndex();
            if (n == -1) {
                return;
            }
            ResultPanel resultPanel = (ResultPanel)this.entries.get(n);
            resultPanel.setGUID(stoppedGUID);
            this.checkToStopLime();
        }
    }

    private void checkToStopLime() {
        boolean bl = true;
        int n = 0;
        while (n < this.entries.size()) {
            ResultPanel resultPanel = (ResultPanel)this.entries.get(n);
            bl &= resultPanel.matches(stoppedGUID);
            ++n;
        }
        if (bl) {
            JLabel jLabel = this.searchIconLabel;
            synchronized (jLabel) {
                this.searchIconLabel.setIcon(this.notsearchingIcon);
            }
        }
    }

    final ResultPanel getPanelAtIndex(int n) {
        List list = this.entries;
        synchronized (list) {
            ResultPanel resultPanel = (ResultPanel)this.entries.get(n);
            return resultPanel;
        }
    }

    final int getIndexForGUID(GUID gUID) {
        List list = this.entries;
        synchronized (list) {
            int n = 0;
            while (n < this.entries.size()) {
                ResultPanel resultPanel = (ResultPanel)this.entries.get(n);
                if (resultPanel.matches(gUID)) {
                    int n2 = n;
                    return n2;
                }
                ++n;
            }
        }
        return -1;
    }

    final void setConnected(boolean bl) {
        this.searchButton.setEnabled(bl);
    }
}

