/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.BadPacketException;
import com.limegroup.gnutella.ByteOrder;
import com.limegroup.gnutella.Endpoint;
import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.QueryReply;
import com.limegroup.gnutella.Response;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.search.ResultPanel;
import com.limegroup.gnutella.gui.search.StandardSearchView;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.gui.search.XMLTableLine;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLDocumentHelper;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLSchemaRepository;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.LinkedList;
import com.sun.java.util.collections.List;
import java.awt.Component;
import javax.swing.SwingUtilities;

public final class SearchView {
    private final StandardSearchView STANDARD_VIEW = new StandardSearchView();
    private static final int BUFFER_SIZE = 2000;
    private static final int MAX_RATE = 200;
    private static final int DELAY_TIME = 5;
    private static int PlatformSpecificNumRows = 3000;
    private LinkedList buffer = new LinkedList();
    private long lastTime;
    private static final int YES = 1;
    private static final int NO = 2;
    private static final int MAYBE = 3;
    private final boolean debugOn = false;

    public SearchView() {
        SearchViewRunner searchViewRunner = new SearchViewRunner();
        searchViewRunner.setDaemon(true);
        searchViewRunner.start();
    }

    public void handleQueryReply(QueryReply queryReply) {
        LinkedList linkedList = this.buffer;
        synchronized (linkedList) {
            this.parseQHD(queryReply);
            this.buffer.addLast((Object)queryReply);
            if (this.buffer.size() > 2000) {
                this.buffer.removeFirst();
            }
            this.buffer.notify();
        }
    }

    private boolean handleQueryReplyInternal(QueryReply queryReply) {
        Object object;
        int n = this.STANDARD_VIEW.getIndexForGUID(new GUID(queryReply.getGUID()));
        if (n == -1) {
            return false;
        }
        ResultPanel resultPanel = this.STANDARD_VIEW.getPanelAtIndex(n);
        if (resultPanel == null) {
            return false;
        }
        byte[] byArray = queryReply.getClientGUID();
        byte[] byArray2 = queryReply.getGUID();
        List list = null;
        try {
            list = queryReply.getResultsAsList();
        }
        catch (BadPacketException badPacketException) {
            return false;
        }
        TableLineGrouper tableLineGrouper = resultPanel.getGrouper();
        RouterService routerService = GUIMediator.instance().getRouter();
        SettingsManager settingsManager = SettingsManager.instance();
        String string = "";
        try {
            this.debug("Trying to do uncompress.....");
            object = queryReply.getXMLBytes();
            if (((byte[])object).length > 1) {
                byte[] byArray3 = LimeXMLUtils.uncompress(object);
                string = new String(byArray3);
            }
        }
        catch (Exception exception) {
            string = "";
        }
        this.debug("xmlCollectionString = " + string);
        object = new LimeXMLDocumentHelper().getDocuments(string, list.size());
        int n2 = object.size();
        boolean bl = false;
        if (string == null || string.equals("")) {
            bl = true;
            n2 = 1;
        }
        int n3 = -1;
        while (n3 < n2) {
            LimeXMLDocument[] limeXMLDocumentArray = null;
            if (n3 >= 0 && !bl) {
                limeXMLDocumentArray = (LimeXMLDocument[])object.get(n3);
            }
            int n4 = list.size();
            if (limeXMLDocumentArray == null) {
                limeXMLDocumentArray = new LimeXMLDocument[n4];
            }
            int n5 = 0;
            while (n5 < n4) {
                block24: {
                    Object object2;
                    Object object3;
                    TableLine tableLine;
                    block26: {
                        int n6;
                        boolean bl2;
                        boolean bl3;
                        int n7;
                        long l;
                        long l2;
                        Response response;
                        block28: {
                            Object object4;
                            block27: {
                                block25: {
                                    response = (Response)list.get(n5);
                                    if (resultPanel.numResults() >= PlatformSpecificNumRows) {
                                        return false;
                                    }
                                    if (!routerService.matchesType(byArray2, response) || routerService.isMandragoreWorm(byArray2, response)) break block24;
                                    l2 = response.getSize();
                                    l = response.getIndex();
                                    long l3 = 0xFFFFFFFFL;
                                    if (l2 > Integer.MAX_VALUE || l > l3) break block24;
                                    n7 = ByteOrder.long2int(queryReply.getSpeed());
                                    bl3 = false;
                                    try {
                                        bl3 = queryReply.getIsMeasuredSpeed();
                                    }
                                    catch (BadPacketException badPacketException) {
                                        // empty catch block
                                    }
                                    bl2 = false;
                                    try {
                                        bl2 = queryReply.getSupportsChat() && !queryReply.getNeedsPush();
                                    }
                                    catch (BadPacketException badPacketException) {
                                        // empty catch block
                                    }
                                    n6 = routerService.score(byArray2, response);
                                    int n8 = this.calculateQualityOfService(queryReply);
                                    if (n8 < settingsManager.getMinimumSearchQuality() || n7 < settingsManager.getMinimumSearchSpeed()) break block24;
                                    if (n3 != -1) break block25;
                                    tableLine = new TableLine(response.getName(), new Integer((int)l2), new Integer(n7), queryReply.getIP(), new Integer(queryReply.getPort()), byArray, new Long(l), new Integer(this.calculateQualityOfService(queryReply)), new Integer(n6), bl3, bl2);
                                    break block26;
                                }
                                if (bl) break block27;
                                object3 = limeXMLDocumentArray[n5];
                                if (object3 != null && (object2 = ((LimeXMLSchemaRepository)(object4 = LimeXMLSchemaRepository.instance())).getSchema(((LimeXMLDocument)object3).getSchemaURI())) != null) break block28;
                                break block24;
                            }
                            try {
                                object4 = response.getMetadata();
                                object3 = new LimeXMLDocument((String)object4);
                            }
                            catch (Exception exception) {
                                break block24;
                            }
                            object4 = LimeXMLSchemaRepository.instance();
                            object2 = ((LimeXMLSchemaRepository)object4).getSchema(((LimeXMLDocument)object3).getSchemaURI());
                            if (object2 == null) break block24;
                        }
                        tableLine = new XMLTableLine(response.getName(), new Integer((int)l2), new Integer(n7), queryReply.getIP(), new Integer(queryReply.getPort()), byArray, new Long(l), new Integer(this.calculateQualityOfService(queryReply)), new Integer(n6), bl3, bl2, (LimeXMLDocument)object3, (LimeXMLSchema)object2, resultPanel);
                    }
                    object3 = tableLineGrouper.match(tableLine);
                    if (object3 == null) {
                        tableLineGrouper.add(tableLine);
                    }
                    object2 = resultPanel;
                    SwingUtilities.invokeLater(new Runnable((TableLine)object3, (ResultPanel)object2, n){
                        private final /* synthetic */ TableLine val$group;
                        private final /* synthetic */ ResultPanel val$copyOfRP;
                        private final /* synthetic */ int val$i;
                        {
                            this.val$group = tableLine2;
                            this.val$copyOfRP = resultPanel;
                            this.val$i = n;
                        }

                        public void run() {
                            SearchView.this.STANDARD_VIEW.addQueryReply(tableLine, this.val$group, this.val$copyOfRP, this.val$i);
                        }
                    });
                }
                ++n5;
            }
            ++n3;
        }
        return true;
    }

    private void parseQHD(QueryReply queryReply) {
        this.parseBusy(queryReply);
        this.parseIncoming(queryReply);
    }

    private int parseBusy(QueryReply queryReply) {
        boolean bl;
        try {
            bl = queryReply.getIsBusy();
        }
        catch (BadPacketException badPacketException) {
            return 3;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    private int parseIncoming(QueryReply queryReply) {
        boolean bl;
        try {
            bl = queryReply.getNeedsPush();
        }
        catch (BadPacketException badPacketException) {
            return 3;
        }
        if (bl) {
            return 1;
        }
        return 2;
    }

    private int calculateQualityOfService(QueryReply queryReply) {
        boolean bl;
        int n;
        int n2;
        Endpoint endpoint = new Endpoint(queryReply.getIP(), queryReply.getPort());
        try {
            n2 = queryReply.getIsBusy() ? 1 : -1;
        }
        catch (BadPacketException badPacketException) {
            n2 = 0;
        }
        if (endpoint.isPrivateAddress()) {
            n = 1;
        } else {
            try {
                n = queryReply.getNeedsPush() ? 1 : -1;
            }
            catch (BadPacketException badPacketException) {
                n = 0;
            }
        }
        boolean bl2 = bl = !GUIMediator.instance().getRouter().acceptedIncomingConnection();
        if (n == -1 && n2 == -1) {
            return 3;
        }
        if (n2 == 1) {
            return 0;
        }
        if (bl && n == 1) {
            return 0;
        }
        if (!bl && n2 == -1) {
            return 2;
        }
        return 1;
    }

    private void debug(String string) {
    }

    public void triggerSearch(String string) {
        this.STANDARD_VIEW.triggerSearch(string);
    }

    public Component getComponent() {
        return this.STANDARD_VIEW;
    }

    public void setConnected(boolean bl) {
        this.STANDARD_VIEW.setConnected(bl);
    }

    static {
        if (CommonUtils.isMacClassic()) {
            PlatformSpecificNumRows = 1000;
        }
    }

    private class SearchViewRunner
    extends Thread {
        private SearchViewRunner() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void run() {
            while (true) {
                boolean bl;
                QueryReply queryReply = null;
                LinkedList linkedList = SearchView.this.buffer;
                synchronized (linkedList) {
                    while (SearchView.this.buffer.isEmpty()) {
                        try {
                            SearchView.this.buffer.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                    queryReply = (QueryReply)SearchView.this.buffer.removeLast();
                }
                long l = System.currentTimeMillis();
                long l2 = l - SearchView.this.lastTime;
                long l3 = (long)(5 * queryReply.getResultCount()) - l2;
                if (l3 > 0L) {
                    try {
                        Thread.sleep(l3);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                if (!(bl = SearchView.this.handleQueryReplyInternal(queryReply))) continue;
                SearchView.this.lastTime = System.currentTimeMillis();
            }
        }
    }
}

