/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.AbstractTreeTableModel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.TreeTableModel;
import com.limegroup.gnutella.gui.search.CachingEndpoint;
import com.limegroup.gnutella.gui.search.ResultSpeed;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.XMLTableLine;
import com.limegroup.gnutella.xml.LimeXMLProperties;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.SchemaFieldInfo;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Collections;
import com.sun.java.util.collections.Comparator;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.List;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Properties;

final class ResultPanelModel
extends AbstractTreeTableModel
implements TreeTableModel {
    private final String[] names = new String[]{GUIMediator.getStringResource("RESULT_PANEL_QUALITY"), GUIMediator.getStringResource("RESULT_PANEL_NAME"), GUIMediator.getStringResource("RESULT_PANEL_TYPE"), GUIMediator.getStringResource("RESULT_PANEL_SIZE"), GUIMediator.getStringResource("RESULT_PANEL_SPEED"), GUIMediator.getStringResource("RESULT_PANEL_SCORE"), GUIMediator.getStringResource("RESULT_PANEL_CHAT"), GUIMediator.getStringResource("RESULT_PANEL_LOCATION")};
    private final TableLine fakeGroupedRoot = new TableLine();
    private int leaves = 0;
    private LimeXMLSchema schema;
    int firstIndex = 0;
    private Properties props;
    private boolean hasProperties = false;
    private int[] displayIndices;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$TreeTableModel;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$ResultSpeed;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$CachingEndpoint;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$QualityHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ChatHolder;

    ResultPanelModel(TableLine tableLine, boolean bl, LimeXMLSchema limeXMLSchema) {
        super(tableLine);
        File file;
        this.schema = limeXMLSchema;
        if (bl) {
            this.fakeGroupedRoot.children = tableLine.children;
        }
        this.props = new Properties();
        if (limeXMLSchema == null) {
            return;
        }
        String string = LimeXMLSchema.getDisplayString(limeXMLSchema.getSchemaURI());
        LimeXMLProperties limeXMLProperties = LimeXMLProperties.instance();
        String string2 = limeXMLProperties.getXMLDisplayPropsDir();
        try {
            file = new File(string2 + string + ".props");
            FileInputStream fileInputStream = new FileInputStream(file);
            this.props.load(fileInputStream);
        }
        catch (IOException iOException) {
            return;
        }
        this.displayIndices = new int[((Hashtable)this.props).size()];
        file = limeXMLSchema.getCanonicalizedFields().iterator();
        int n = -1;
        int n2 = 0;
        while (file.hasNext()) {
            ++n;
            SchemaFieldInfo schemaFieldInfo = (SchemaFieldInfo)file.next();
            String string3 = schemaFieldInfo.getCanonicalizedFieldName();
            String string4 = this.props.getProperty(string3, "null");
            if (string4.equals("null")) continue;
            this.displayIndices[n2] = n;
            ++n2;
        }
        this.firstIndex = this.displayIndices[0];
        this.hasProperties = true;
    }

    public int getColumnCount() {
        if (this.schema == null) {
            return this.names.length;
        }
        if (this.hasProperties) {
            return ((Hashtable)this.props).size();
        }
        List list = this.schema.getCanonicalizedFields();
        return list.size();
    }

    public String getColumnName(int n) {
        if (this.schema == null) {
            return this.names[n];
        }
        List list = this.schema.getCanonicalizedFields();
        int n2 = n;
        if (this.hasProperties) {
            n2 = this.displayIndices[n];
        }
        String string = ((SchemaFieldInfo)list.get(n2)).getCanonicalizedFieldName();
        if (this.hasProperties) {
            string = this.props.getProperty(string, string);
            string = ResultPanelModel.extractNameFromProp(string);
        }
        return LimeXMLUtils.processColName(string);
    }

    public Class getColumnClass(int n) {
        if (this.schema == null) {
            switch (n) {
                case 1: {
                    return class$com$limegroup$gnutella$gui$TreeTableModel == null ? (class$com$limegroup$gnutella$gui$TreeTableModel = ResultPanelModel.class$("com.limegroup.gnutella.gui.TreeTableModel")) : class$com$limegroup$gnutella$gui$TreeTableModel;
                }
                case 2: {
                    return class$java$lang$String == null ? (class$java$lang$String = ResultPanelModel.class$("java.lang.String")) : class$java$lang$String;
                }
                case 3: {
                    return class$java$lang$String == null ? (class$java$lang$String = ResultPanelModel.class$("java.lang.String")) : class$java$lang$String;
                }
                case 4: {
                    return class$com$limegroup$gnutella$gui$search$ResultSpeed == null ? (class$com$limegroup$gnutella$gui$search$ResultSpeed = ResultPanelModel.class$("com.limegroup.gnutella.gui.search.ResultSpeed")) : class$com$limegroup$gnutella$gui$search$ResultSpeed;
                }
                case 5: {
                    return class$java$lang$Integer == null ? (class$java$lang$Integer = ResultPanelModel.class$("java.lang.Integer")) : class$java$lang$Integer;
                }
                case 7: {
                    return class$com$limegroup$gnutella$gui$search$CachingEndpoint == null ? (class$com$limegroup$gnutella$gui$search$CachingEndpoint = ResultPanelModel.class$("com.limegroup.gnutella.gui.search.CachingEndpoint")) : class$com$limegroup$gnutella$gui$search$CachingEndpoint;
                }
                case 0: {
                    return class$com$limegroup$gnutella$gui$search$QualityHolder == null ? (class$com$limegroup$gnutella$gui$search$QualityHolder = ResultPanelModel.class$("com.limegroup.gnutella.gui.search.QualityHolder")) : class$com$limegroup$gnutella$gui$search$QualityHolder;
                }
                case 6: {
                    return class$com$limegroup$gnutella$gui$ChatHolder == null ? (class$com$limegroup$gnutella$gui$ChatHolder = ResultPanelModel.class$("com.limegroup.gnutella.gui.ChatHolder")) : class$com$limegroup$gnutella$gui$ChatHolder;
                }
            }
            Assert.that(false, "Bad column in table");
            return null;
        }
        if (n == 0) {
            return class$com$limegroup$gnutella$gui$TreeTableModel == null ? (class$com$limegroup$gnutella$gui$TreeTableModel = ResultPanelModel.class$("com.limegroup.gnutella.gui.TreeTableModel")) : class$com$limegroup$gnutella$gui$TreeTableModel;
        }
        return class$java$lang$String == null ? (class$java$lang$String = ResultPanelModel.class$("java.lang.String")) : class$java$lang$String;
    }

    public boolean isCellEditable(int n, int n2) {
        return false;
    }

    public void setValueAt(Object object, int n, int n2) {
        Assert.that(false, "Table not editable!");
    }

    public Object getValueAt(Object object, int n) {
        int n2 = n;
        if (this.hasProperties) {
            n2 = this.displayIndices[n];
        }
        TableLine tableLine = (TableLine)object;
        return tableLine.getValue(n2);
    }

    public int getChildCount(Object object) {
        return ((TableLine)object).children.size();
    }

    public Object getChild(Object object, int n) {
        return ((TableLine)object).children.get(n);
    }

    public boolean isLeaf(Object object) {
        return ((TableLine)object).children == null;
    }

    private void add(TableLine tableLine, TableLine tableLine2) {
        if (tableLine.children == null) {
            tableLine.children = new ArrayList();
        }
        tableLine.children.add((Object)tableLine2);
        tableLine2.childName = tableLine.children.size() - 1;
    }

    int getColumnWidth(int n) {
        if (this.schema == null || !this.hasProperties) {
            return -1;
        }
        List list = this.schema.getCanonicalizedFields();
        int n2 = this.displayIndices[n];
        String string = ((SchemaFieldInfo)list.get(n2)).getCanonicalizedFieldName();
        string = this.props.getProperty(string, string);
        int n3 = ResultPanelModel.extractSizeFromProp(string);
        return n3;
    }

    private TableLine setChildAt(TableLine tableLine, int n, TableLine tableLine2) {
        Assert.that(tableLine.children != null);
        TableLine tableLine3 = (TableLine)tableLine.children.get(n);
        tableLine.children.set(n, (Object)tableLine2);
        tableLine2.childName = n;
        return tableLine3;
    }

    void addLine(TableLine tableLine, TableLine tableLine2, boolean bl) {
        if (bl) {
            Assert.that(((TableLine)this.getRoot()).children == this.fakeGroupedRoot.children, "No aliasing of fakedGroupedRoot's children.");
            this.addLineInternal((TableLine)this.getRoot(), tableLine, tableLine2, true);
        } else {
            Assert.that(((TableLine)this.getRoot()).children != this.fakeGroupedRoot.children, "Aliasing of fakedGroupedRoot's children.");
            this.addLineInternal(this.fakeGroupedRoot, tableLine, tableLine2, false);
            this.addLineInternal((TableLine)this.getRoot(), tableLine.createClone(), null, true);
        }
        ++this.leaves;
    }

    private void addLineInternal(TableLine tableLine, TableLine tableLine2, TableLine tableLine3, boolean bl) {
        if (tableLine3 != null) {
            try {
                Assert.that(this.getChild(tableLine, tableLine3.childName) == tableLine3, "Group is not the " + tableLine3.childName + "'th child of root");
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                Assert.that(false, "Group is not the " + tableLine3.childName + "'th child of root");
            }
        }
        if (tableLine3 != null) {
            int n = tableLine3.childName;
            if (!this.isLeaf(tableLine3)) {
                this.add(tableLine3, tableLine2);
                if (bl) {
                    this.fireTreeNodesInserted(this, new Object[]{tableLine, tableLine3}, new int[]{this.getChildCount(tableLine3) - 1}, new Object[]{tableLine2});
                }
                if (tableLine3.getSpeed().compareTo(tableLine2.getSpeed()) < 0) {
                    tableLine3.setSpeed(tableLine2.getSpeed());
                    if (bl) {
                        this.fireTreeNodesChanged(this, new Object[]{tableLine, tableLine3}, null, null);
                    }
                }
                if (tableLine3.getQuality() < tableLine2.getQuality()) {
                    tableLine3.setQuality(tableLine2.getQuality());
                    if (bl) {
                        this.fireTreeNodesChanged(this, new Object[]{tableLine, tableLine3}, null, null);
                    }
                }
                if (!tableLine3.getChatEnabled() && tableLine2.getChatEnabled()) {
                    tableLine3.setChatEnabled(true);
                    if (bl) {
                        this.fireTreeNodesChanged(this, new Object[]{tableLine, tableLine3}, null, null);
                    }
                }
            } else {
                TableLine tableLine4 = tableLine3.createClone();
                tableLine3.location = new CachingEndpoint(this, tableLine3);
                tableLine3.setSpeed(ResultSpeed.max(tableLine3.getSpeed(), tableLine2.getSpeed()));
                tableLine3.setQuality(Math.max(tableLine3.getQuality(), tableLine2.getQuality()));
                tableLine3.setChatEnabled(tableLine3.getChatEnabled() || tableLine2.getChatEnabled());
                this.add(tableLine3, tableLine4);
                this.add(tableLine3, tableLine2);
                if (bl) {
                    this.fireTreeNodesRemoved(this, new Object[]{tableLine}, new int[]{n}, new Object[]{tableLine3});
                    this.fireTreeNodesInserted(this, new Object[]{tableLine}, new int[]{n}, new Object[]{tableLine3});
                }
            }
        } else {
            this.add(tableLine, tableLine2);
            if (bl) {
                this.fireTreeNodesInserted(this, new Object[]{tableLine}, new int[]{this.getChildCount(tableLine) - 1}, new Object[]{tableLine2});
            }
        }
    }

    void group() {
        TableLine tableLine = (TableLine)this.getRoot();
        tableLine.children = this.fakeGroupedRoot.children;
        this.fireTreeStructureChanged(this, new Object[]{tableLine}, null, null);
    }

    void ungroup() {
        TableLine tableLine = (TableLine)this.getRoot();
        tableLine.children = new ArrayList(this.numLeaves());
        Iterator iterator = this.fakeGroupedRoot.children.iterator();
        while (iterator.hasNext()) {
            TableLine tableLine2 = (TableLine)iterator.next();
            if (this.isLeaf(tableLine2)) {
                this.addLineInternal(tableLine, tableLine2.createClone(), null, false);
                continue;
            }
            int n = 0;
            while (n < tableLine2.children.size()) {
                TableLine tableLine3 = (TableLine)tableLine2.children.get(n);
                Assert.that(this.isLeaf(tableLine3));
                this.addLineInternal(tableLine, tableLine3.createClone(), null, false);
                ++n;
            }
        }
        this.fireTreeStructureChanged(this, new Object[]{tableLine}, null, null);
    }

    void sort(int n, boolean bl) {
        TableLine tableLine = (TableLine)this.getRoot();
        if (this.schema == null) {
            Collections.sort((List)tableLine.children, (Comparator)TableLine.newComparator(n, bl));
        } else {
            int n2 = n;
            if (this.hasProperties) {
                n2 = this.displayIndices[n];
            }
            Collections.sort((List)tableLine.children, (Comparator)XMLTableLine.newComparator(n2, bl, this.schema));
        }
        List list = tableLine.children;
        int n3 = 0;
        while (n3 < list.size()) {
            TableLine tableLine2 = (TableLine)list.get(n3);
            tableLine2.childName = n3++;
        }
        this.fireTreeStructureChanged(this, new Object[]{tableLine}, null, null);
    }

    int numLeaves() {
        return this.leaves;
    }

    LimeXMLSchema getSchema() {
        return this.schema;
    }

    private int repOk(TableLine tableLine) {
        if (tableLine.children == null) {
            return 1;
        }
        int n = 0;
        int n2 = 0;
        while (n2 < tableLine.children.size()) {
            TableLine tableLine2 = (TableLine)tableLine.children.get(n2);
            Assert.that(tableLine2 != null, "Null children");
            Assert.that(tableLine2.childName == n2, "Child's name is " + tableLine2.childName + " but I expected " + n2);
            n += this.repOk(tableLine2);
            ++n2;
        }
        return n;
    }

    boolean hasProps() {
        return this.hasProperties;
    }

    private static String extractNameFromProp(String string) {
        int n = string.indexOf("^");
        if (n == -1) {
            return string;
        }
        return string.substring(0, n);
    }

    private static int extractSizeFromProp(String string) {
        int n;
        int n2 = string.indexOf("^");
        if (n2 == -1) {
            return -1;
        }
        string = string.substring(++n2);
        try {
            n = Integer.parseInt(string);
        }
        catch (NumberFormatException numberFormatException) {
            n = -1;
        }
        if (n < 0) {
            n *= -1;
        }
        return n;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

