/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.search;

import com.limegroup.gnutella.GUID;
import com.limegroup.gnutella.MediaType;
import com.limegroup.gnutella.gui.ChatRenderer;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.JTreeTable;
import com.limegroup.gnutella.gui.search.BuyListener;
import com.limegroup.gnutella.gui.search.CachingEndpointRenderer;
import com.limegroup.gnutella.gui.search.CancelAction;
import com.limegroup.gnutella.gui.search.ChatAction;
import com.limegroup.gnutella.gui.search.DownloadAllAction;
import com.limegroup.gnutella.gui.search.DownloadAnyAction;
import com.limegroup.gnutella.gui.search.QualityRenderer;
import com.limegroup.gnutella.gui.search.ResultPanelModel;
import com.limegroup.gnutella.gui.search.ResultSpeedRenderer;
import com.limegroup.gnutella.gui.search.StandardSearchView;
import com.limegroup.gnutella.gui.search.TableLine;
import com.limegroup.gnutella.gui.search.TableLineGrouper;
import com.limegroup.gnutella.gui.search.XMLTableLine;
import com.limegroup.gnutella.util.KeyValue;
import com.limegroup.gnutella.util.PairTuple;
import com.limegroup.gnutella.util.UnmodifiableIterator;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLSchema;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.sun.java.util.collections.ArrayList;
import com.sun.java.util.collections.Arrays;
import com.sun.java.util.collections.HashMap;
import com.sun.java.util.collections.Iterator;
import com.sun.java.util.collections.Map;
import com.sun.java.util.collections.NoSuchElementException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class ResultPanel
extends JPanel {
    static final int QUALITY_COL = 0;
    static final int NAME_COL = 1;
    static final int EXTENSION_COL = 2;
    static final int SIZE_COL = 3;
    static final int SPEED_COL = 4;
    static final int SCORE_COL = 5;
    static final int CHAT_COL = 6;
    static final int LOCATION_COL = 7;
    private String query;
    private String richQuery;
    private MediaType type;
    private GUID guid;
    private long timeLastResultReceived;
    private final long REPEAT_SEARCH_DELAY = 0L;
    private ResultPanelModel dataModel;
    private JTreeTable table;
    private boolean grouped;
    private boolean ascending = true;
    private final TableLineGrouper grouper = new TableLineGrouper();
    private boolean debug = false;
    private final StandardSearchView parent;
    private final ArrayList schemaToArrayPair = new ArrayList();
    private LimeXMLSchema schema;
    private final HashMap menuItemToSchemas = new HashMap();
    private final HashMap dispStrToSchemas = new HashMap();
    private SchemaMenuListener schemaListener;
    private JPanel tpan;
    private JScrollPane scrollpane;
    private JPopupMenu menu = new JPopupMenu();
    private JMenuItem chatItem;
    private JMenuItem annotationItem;
    private JMenu schemasMenu = null;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$ChatHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$QualityHolder;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$CachingEndpoint;
    static /* synthetic */ Class class$com$limegroup$gnutella$gui$search$ResultSpeed;

    ResultPanel(final StandardSearchView standardSearchView, GUID gUID, String string, MediaType mediaType, boolean bl, LimeXMLSchema limeXMLSchema, String string2) {
        this.type = mediaType;
        this.schema = limeXMLSchema;
        this.parent = standardSearchView;
        this.guid = gUID;
        this.query = string;
        this.richQuery = string2;
        this.grouped = bl;
        this.setLayout(new BorderLayout());
        this.dataModel = new ResultPanelModel(new TableLine(), bl, limeXMLSchema);
        this.timeLastResultReceived = -1L;
        this.initializeSchemaToArrayPair();
        this.createTreeTable();
        JMenuItem jMenuItem = new JMenuItem(StandardSearchView.DOWNLOAD_ANY_STRING);
        jMenuItem.addActionListener(new DownloadAnyAction(standardSearchView));
        this.menu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem(StandardSearchView.DOWNLOAD_ALL_STRING);
        jMenuItem2.addActionListener(new DownloadAllAction(standardSearchView));
        this.menu.add(jMenuItem2);
        this.chatItem = new JMenuItem(StandardSearchView.CHAT_STRING);
        this.chatItem.addActionListener(new ChatAction(this.parent));
        this.menu.add(this.chatItem);
        JMenuItem jMenuItem3 = new JMenuItem(GUIMediator.getStringResource("SEARCH_BUY_CD_LABEL"));
        this.menu.add(jMenuItem3);
        jMenuItem3.addActionListener(new BuyListener(standardSearchView));
        this.menu.addSeparator();
        JMenuItem jMenuItem4 = new JMenuItem(StandardSearchView.REPEAT_SEARCH_STRING);
        jMenuItem4.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                ResultPanel.this.repeatSearch();
            }
        });
        this.menu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem(StandardSearchView.STOP_STRING);
        jMenuItem5.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                standardSearchView.stopSearch();
            }
        });
        this.menu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem(StandardSearchView.KILL_STRING);
        jMenuItem6.addActionListener(new CancelAction(standardSearchView));
        this.menu.add(jMenuItem6);
        this.menu.addSeparator();
        this.annotationItem = new JMenuItem(StandardSearchView.SHOW_META_STRING);
        this.annotationItem.addActionListener(new AbstractAction(){

            public boolean isEnabled() {
                return true;
            }

            public void actionPerformed(ActionEvent actionEvent) {
                standardSearchView.showMetaResult();
            }
        });
        this.menu.add(this.annotationItem);
        this.initializeChangeViewMenu();
        this.scrollpane = new JScrollPane(this.table);
        this.createPanel();
    }

    private void initializeChangeViewMenu() {
        if (this.schemasMenu != null) {
            this.menu.remove(this.schemasMenu);
        }
        this.schemasMenu = new JMenu(StandardSearchView.VIEW_STRING);
        this.schemaListener = new SchemaMenuListener();
        this.menu.add(this.schemasMenu);
        JMenuItem jMenuItem = new JMenuItem("Normal");
        this.schemasMenu.add(jMenuItem);
        this.menuItemToSchemas.put((Object)jMenuItem, null);
        this.dispStrToSchemas.put((Object)"normal", null);
        jMenuItem.addActionListener(this.schemaListener);
    }

    private void initializeSchemaToArrayPair() {
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        PairTuple pairTuple = new PairTuple(arrayList, arrayList2);
        KeyValue keyValue = new KeyValue(null, pairTuple);
        this.schemaToArrayPair.add((Object)keyValue);
    }

    private void markTimeLastResultReceived() {
        this.timeLastResultReceived = System.currentTimeMillis();
    }

    public boolean isRepeatSearchEnabled() {
        if (this.timeLastResultReceived == -1L) {
            return true;
        }
        long l = System.currentTimeMillis();
        return l - this.timeLastResultReceived > 0L;
    }

    private void repeatSearch() {
        if (this.isRepeatSearchEnabled()) {
            this.resetPanel();
            this.parent.setTabDisplayCount(this);
            String string = this.schema == null ? null : this.schema.getSchemaURI();
            this.parent.repeatSearch(this.type, this.query, this.richQuery, string);
        }
    }

    void resetPanel() {
        this.grouper.clear();
        this.menuItemToSchemas.clear();
        this.dispStrToSchemas.clear();
        this.initializeChangeViewMenu();
        this.schemaToArrayPair.clear();
        this.initializeSchemaToArrayPair();
        this.dataModel = new ResultPanelModel(new TableLine(), this.grouped, this.schema);
        this.createTreeTable();
        this.scrollpane = new JScrollPane(this.table);
        this.createPanel();
    }

    private void createPanel() {
        if (this.tpan != null) {
            this.remove(this.tpan);
        }
        ResultPanel resultPanel = this;
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (SwingUtilities.isRightMouseButton(mouseEvent)) {
                    ResultPanel.this.parent.showMenu(mouseEvent.getX(), mouseEvent.getY() % ResultPanel.this.getSize().height);
                } else if (mouseEvent.getClickCount() == 2) {
                    ResultPanel.this.parent.doDownload(false);
                }
            }
        };
        this.table.addMouseListener(mouseAdapter);
        this.tpan = new JPanel();
        this.tpan.setLayout(new BorderLayout());
        this.tpan.setBackground(Color.white);
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.table.getTableHeader().getBackground());
        jPanel.setBorder(BorderFactory.createBevelBorder(0));
        this.scrollpane.setCorner("UPPER_RIGHT_CORNER", jPanel);
        this.scrollpane.getViewport().setBackground(Color.white);
        this.tpan.add((Component)this.scrollpane, "Center");
        this.add((Component)this.tpan, "Center");
    }

    private void createTreeTable() {
        this.table = new JTreeTable(this.dataModel);
        this.table.setLeafIcon(null);
        this.table.setOpenIcon(null);
        this.table.setClosedIcon(null);
        if (this.schema == null) {
            this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$ChatHolder == null ? (class$com$limegroup$gnutella$gui$ChatHolder = ResultPanel.class$("com.limegroup.gnutella.gui.ChatHolder")) : class$com$limegroup$gnutella$gui$ChatHolder, new ChatRenderer());
            this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$QualityHolder == null ? (class$com$limegroup$gnutella$gui$search$QualityHolder = ResultPanel.class$("com.limegroup.gnutella.gui.search.QualityHolder")) : class$com$limegroup$gnutella$gui$search$QualityHolder, new QualityRenderer());
            this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$CachingEndpoint == null ? (class$com$limegroup$gnutella$gui$search$CachingEndpoint = ResultPanel.class$("com.limegroup.gnutella.gui.search.CachingEndpoint")) : class$com$limegroup$gnutella$gui$search$CachingEndpoint, new CachingEndpointRenderer());
            this.table.setDefaultRenderer(class$com$limegroup$gnutella$gui$search$ResultSpeed == null ? (class$com$limegroup$gnutella$gui$search$ResultSpeed = ResultPanel.class$("com.limegroup.gnutella.gui.search.ResultSpeed")) : class$com$limegroup$gnutella$gui$search$ResultSpeed, new ResultSpeedRenderer());
            this.table.getColumnModel().getColumn(1).setPreferredWidth(230);
            this.table.getColumnModel().getColumn(2).setPreferredWidth(30);
            this.table.getColumnModel().getColumn(3).setPreferredWidth(60);
            this.table.getColumnModel().getColumn(4).setPreferredWidth(30);
            this.table.getColumnModel().getColumn(5).setPreferredWidth(30);
            this.table.getColumnModel().getColumn(0).setPreferredWidth(40);
            this.table.getColumnModel().getColumn(6).setPreferredWidth(10);
        } else if (this.dataModel.hasProps()) {
            int n = this.dataModel.getColumnCount();
            int n2 = 0;
            while (n2 < n) {
                int n3 = this.dataModel.getColumnWidth(n2);
                if (n3 > 0) {
                    this.table.getColumnModel().getColumn(n2).setPreferredWidth(n3);
                }
                ++n2;
            }
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = ResultPanel.this.table.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                int n2 = ResultPanel.this.table.convertColumnIndexToModel(n);
                if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                    int n3 = mouseEvent.getModifiers() & 1;
                    ResultPanel.this.sort(n2);
                }
            }
        };
        JTableHeader jTableHeader = this.table.getTableHeader();
        jTableHeader.addMouseListener(mouseAdapter);
        ListSelectionModel listSelectionModel = this.table.getSelectionModel();
        listSelectionModel.addListSelectionListener(new ResultSelectionListener());
        this.table.addTreeExpansionListener(new ResultExpansionListener());
    }

    void addLine(TableLine tableLine, TableLine tableLine2) {
        LimeXMLSchema limeXMLSchema = null;
        if (tableLine instanceof XMLTableLine) {
            XMLTableLine xMLTableLine = (XMLTableLine)tableLine;
            limeXMLSchema = xMLTableLine.getSchema();
            int n = this.schemaToArrayPair.size();
            KeyValue keyValue = null;
            int n2 = 1;
            while (n2 < n) {
                keyValue = (KeyValue)this.schemaToArrayPair.get(n2);
                if (keyValue.getKey() == limeXMLSchema) break;
                keyValue = null;
                ++n2;
            }
            if (keyValue == null) {
                String string = LimeXMLSchema.getDisplayString(limeXMLSchema.getSchemaURI());
                JMenuItem jMenuItem = new JMenuItem(LimeXMLUtils.capitalizeFirst(string));
                this.schemasMenu.add(jMenuItem);
                this.menuItemToSchemas.put((Object)jMenuItem, (Object)limeXMLSchema);
                if (this.menuItemToSchemas.size() == 2) {
                    this.parent.setViewChangeButtonEnabled();
                }
                this.dispStrToSchemas.put((Object)string.toLowerCase(), (Object)limeXMLSchema);
                jMenuItem.addActionListener(this.schemaListener);
                ArrayList arrayList = new ArrayList();
                ArrayList arrayList2 = new ArrayList();
                if (tableLine2 == null) {
                    arrayList.add((Object)xMLTableLine);
                } else {
                    arrayList2.add((Object)xMLTableLine);
                }
                PairTuple pairTuple = new PairTuple(arrayList, arrayList2);
                keyValue = new KeyValue(limeXMLSchema, pairTuple);
                this.schemaToArrayPair.add((Object)keyValue);
            } else {
                PairTuple pairTuple = (PairTuple)keyValue.getValue();
                ArrayList arrayList = tableLine2 == null ? (ArrayList)pairTuple.getFirst() : (ArrayList)pairTuple.getSecond();
                arrayList.add((Object)xMLTableLine);
            }
        } else {
            KeyValue keyValue = (KeyValue)this.schemaToArrayPair.get(0);
            PairTuple pairTuple = (PairTuple)keyValue.getValue();
            ArrayList arrayList = tableLine2 == null ? (ArrayList)pairTuple.getFirst() : (ArrayList)pairTuple.getSecond();
            arrayList.add((Object)tableLine);
            this.markTimeLastResultReceived();
        }
        if (limeXMLSchema == this.schema) {
            this.dataModel.addLine(tableLine, tableLine2, this.grouped);
            this.table.revalidate();
        }
    }

    public void setSchema(LimeXMLSchema limeXMLSchema) {
        TableLine tableLine;
        TableLine tableLine2;
        Object object;
        if (this.schema == limeXMLSchema) {
            return;
        }
        int n = this.schemaToArrayPair.size();
        KeyValue keyValue = null;
        int n2 = 0;
        while (n2 < n) {
            keyValue = (KeyValue)this.schemaToArrayPair.get(n2);
            if (keyValue.getKey() == limeXMLSchema) break;
            keyValue = null;
            ++n2;
        }
        if (keyValue == null) {
            return;
        }
        byte[] byArray = null;
        long l = -1L;
        if (this.getRowsSelected() && (object = this.getFirstSelectedTableLine()) != null) {
            byArray = ((TableLine)object).clientGUID;
            l = ((TableLine)object).index;
            this.debug("Selected Client guid, index =" + byArray + ", " + l);
        }
        object = (PairTuple)keyValue.getValue();
        ArrayList arrayList = (ArrayList)((PairTuple)object).getFirst();
        ArrayList arrayList2 = (ArrayList)((PairTuple)object).getSecond();
        this.schema = limeXMLSchema;
        this.dataModel = new ResultPanelModel(new TableLine(), this.grouped, this.schema);
        this.remove(this.tpan);
        this.createTreeTable();
        this.scrollpane = new JScrollPane(this.table);
        this.createPanel();
        this.parent.changeViewIcon(limeXMLSchema, this);
        int n3 = arrayList.size();
        int n4 = -1;
        int n5 = 0;
        int n6 = 0;
        while (n6 < n3) {
            TableLine tableLine3 = (TableLine)arrayList.get(n6);
            tableLine3.unMutate();
            tableLine2 = this.grouper.match(tableLine3);
            if (tableLine2 == tableLine3) {
                tableLine2 = null;
            }
            if (tableLine2 == null) {
                ++n5;
            }
            this.dataModel.addLine(tableLine3, tableLine2, this.grouped);
            this.parent.setTabDisplayCount(this);
            ++n6;
        }
        this.debug("added lines with children");
        n3 = arrayList2.size();
        int n7 = 0;
        while (n7 < n3) {
            tableLine2 = (TableLine)arrayList2.get(n7);
            tableLine2.unMutate();
            tableLine = this.grouper.match(tableLine2);
            if (tableLine == tableLine2) {
                tableLine = null;
            }
            if (tableLine == null) {
                ++n5;
            }
            this.dataModel.addLine(tableLine2, tableLine, this.grouped);
            this.parent.setTabDisplayCount(this);
            ++n7;
        }
        int n8 = 0;
        while (n8 < n5) {
            if (byArray == null) {
                this.debug("No line was selected in prev view. quitting...");
                break;
            }
            tableLine = (TableLine)this.table.nodeForRow(n8);
            this.debug("rowCount, currentCount=" + n5 + ", " + n8);
            boolean bl = Arrays.equals((byte[])tableLine.clientGUID, (byte[])byArray);
            if (bl && tableLine.index == l) {
                n4 = n8;
                this.debug("Row found, row number == " + n4);
                break;
            }
            ++n8;
        }
        if (n4 > -1) {
            this.focusChange(n4);
        }
        this.table.revalidate();
    }

    private void focusChange(int n) {
        this.table.setRowSelectionInterval(n, n);
        Rectangle rectangle = this.table.getCellRect(n, 0, false);
        if (rectangle != null) {
            this.table.scrollRectToVisible(rectangle);
        }
    }

    synchronized void setGrouped(boolean bl) {
        if (this.grouped == bl) {
            return;
        }
        this.grouped = bl;
        if (this.grouped) {
            this.dataModel.group();
        } else {
            this.dataModel.ungroup();
        }
        this.table.revalidate();
    }

    TableLineGrouper getGrouper() {
        return this.grouper;
    }

    boolean matches(GUID gUID) {
        return this.guid.equals(gUID);
    }

    boolean hasValidSchema() {
        return this.schema != null;
    }

    void setGUID(GUID gUID) {
        this.guid = gUID;
    }

    String getQuery() {
        return this.query;
    }

    synchronized void sort(int n) {
        this.dataModel.sort(n, this.ascending);
        this.table.revalidate();
        this.ascending = !this.ascending;
    }

    int numResults() {
        return this.dataModel.numLeaves();
    }

    JPopupMenu getPopup() {
        this.annotationItem.setEnabled(this.dataModel.getSchema() != null);
        if (!this.getRowsSelected()) {
            this.chatItem.setEnabled(false);
        } else {
            TableLine tableLine = this.getFirstSelectedTableLine();
            this.chatItem.setEnabled(tableLine.getChatEnabled());
        }
        return this.menu;
    }

    Iterator getSelectedRows() {
        return new SelectedRowIterator();
    }

    int getFirstIndex() {
        return this.dataModel.firstIndex;
    }

    void handlePanelSelection() {
        this.parent.setViewChangeButtonEnabled();
        if (!this.getRowsSelected()) {
            this.parent.setHostButtonsEnabled(false);
        } else {
            TableLine tableLine = this.getFirstSelectedTableLine();
            this.parent.setButtonEnabled(2, tableLine.getChatEnabled());
            this.parent.setButtonEnabled(0, true);
            this.parent.setButtonEnabled(1, true);
            this.parent.setButtonEnabled(3, true);
        }
    }

    int getViewCount() {
        return this.menuItemToSchemas.size();
    }

    LimeXMLSchema getSchema() {
        return this.schema;
    }

    LimeXMLDocument[] getCorrespondingDocs(byte[] byArray, Long l) {
        Object object;
        long l2 = l;
        int n = this.schemaToArrayPair.size();
        ArrayList arrayList = new ArrayList();
        int n2 = 0;
        while (n2 < n) {
            TableLine tableLine;
            KeyValue keyValue = (KeyValue)this.schemaToArrayPair.get(n2);
            object = (PairTuple)keyValue.getValue();
            ArrayList arrayList2 = (ArrayList)((PairTuple)object).getFirst();
            ArrayList arrayList3 = (ArrayList)((PairTuple)object).getSecond();
            int n3 = arrayList2.size();
            int n4 = 0;
            while (n4 < n3) {
                TableLine tableLine2 = (TableLine)arrayList2.get(n4);
                if (tableLine2 instanceof XMLTableLine) {
                    tableLine = (XMLTableLine)tableLine2;
                    boolean bl = Arrays.equals((byte[])tableLine2.clientGUID, (byte[])byArray);
                    if (bl && tableLine2.index == l2) {
                        arrayList.add((Object)((XMLTableLine)tableLine).getDocument());
                    }
                }
                ++n4;
            }
            n3 = arrayList3.size();
            int n5 = 0;
            while (n5 < n3) {
                tableLine = (TableLine)arrayList3.get(n5);
                if (tableLine instanceof XMLTableLine) {
                    TableLine tableLine3 = tableLine;
                    boolean bl = Arrays.equals((byte[])tableLine.clientGUID, (byte[])byArray);
                    if (bl && tableLine.index == l2) {
                        arrayList.add((Object)((XMLTableLine)tableLine3).getDocument());
                    }
                }
                ++n5;
            }
            ++n2;
        }
        int n6 = arrayList.size();
        object = new LimeXMLDocument[n6];
        int n7 = 0;
        while (n7 < n6) {
            object[n7] = (LimeXMLDocument)arrayList.get(n7);
            ++n7;
        }
        return object;
    }

    private boolean isSelectedPanel() {
        return this.parent.isSelectedPanel(this);
    }

    private void debug(String string) {
        if (this.debug) {
            System.out.println(string);
        }
    }

    Map getDisplayToSchemaMap() {
        return this.dispStrToSchemas;
    }

    String getCurrentSchemaString() {
        if (this.schema == null) {
            return "Normal";
        }
        return LimeXMLSchema.getDisplayString(this.schema.getSchemaURI());
    }

    final boolean getRowsSelected() {
        return this.table.getSelectedRow() != -1;
    }

    final TableLine getFirstSelectedTableLine() {
        if (!this.getRowsSelected()) {
            return null;
        }
        return (TableLine)this.table.nodeForRow(this.table.getSelectedRow());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class SchemaMenuListener
    implements ActionListener {
        private SchemaMenuListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            LimeXMLSchema limeXMLSchema = (LimeXMLSchema)ResultPanel.this.menuItemToSchemas.get(object);
            ResultPanel.this.setSchema(limeXMLSchema);
            ResultPanel.this.table.revalidate();
        }
    }

    private class ResultExpansionListener
    implements TreeExpansionListener {
        private ResultExpansionListener() {
        }

        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            try {
                ResultPanel.this.table.removeRowSelectionInterval(0, ResultPanel.this.table.getRowCount() - 1);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
        }
    }

    private class ResultSelectionListener
    implements ListSelectionListener {
        private ResultSelectionListener() {
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            TableLine tableLine;
            int n;
            if (listSelectionEvent.getValueIsAdjusting()) {
                if (ResultPanel.this.isSelectedPanel()) {
                    ResultPanel.this.parent.setHostButtonsEnabled(false);
                }
                return;
            }
            ListSelectionModel listSelectionModel = (ListSelectionModel)listSelectionEvent.getSource();
            if (ResultPanel.this.isSelectedPanel()) {
                n = listSelectionModel.getMinSelectionIndex();
                if (n != -1) {
                    tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n);
                    ResultPanel.this.parent.setChatButtonEnabled(tableLine.getChatEnabled());
                    ResultPanel.this.parent.setBuyButtonEnabled(true);
                    ResultPanel.this.parent.setDownloadAnyButtonEnabled(true);
                    ResultPanel.this.parent.setDownloadAllButtonEnabled(true);
                } else {
                    ResultPanel.this.parent.setHostButtonsEnabled(false);
                }
            }
            n = listSelectionEvent.getFirstIndex();
            while (n <= listSelectionEvent.getLastIndex()) {
                if (listSelectionModel.isSelectedIndex(n) && (tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n)) != null && !ResultPanel.this.dataModel.isLeaf(tableLine) && ResultPanel.this.table.isExpanded(n)) {
                    int n2 = n + 1;
                    int n3 = n + ResultPanel.this.dataModel.getChildCount(tableLine);
                    listSelectionModel.addSelectionInterval(n2, n3);
                }
                ++n;
            }
        }
    }

    private class SelectedRowIterator
    extends UnmodifiableIterator {
        private int next = 0;
        private int[] selectedRows = ResultPanel.access$300(ResultPanel.this).getSelectedRows();

        private SelectedRowIterator() {
        }

        public boolean hasNext() {
            return this.next < this.selectedRows.length;
        }

        public Object next() throws NoSuchElementException {
            try {
                int n = this.selectedRows[this.next];
                ++this.next;
                TableLine tableLine = (TableLine)ResultPanel.this.table.nodeForRow(n);
                return tableLine;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException();
            }
        }
    }
}

