/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import com.limegroup.gnutella.util.CommonUtils;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JRadioButton;

public class ShutdownPaneItem
extends AbstractPaneItem {
    private JRadioButton shutdownImmediately;
    private JRadioButton shutdownAfterTransfers;
    private JRadioButton minimizeToTray;

    public ShutdownPaneItem(String string) {
        super(string);
        BoxPanel boxPanel = new BoxPanel();
        String string2 = "OPTIONS_SHUTDOWN_IMMEDIATELY_LABEL";
        String string3 = "OPTIONS_SHUTDOWN_AFTER_TRANSFERS_LABEL";
        String string4 = "OPTIONS_SHUTDOWN_TO_TRAY_LABEL";
        this.shutdownImmediately = new JRadioButton(this.MEDIATOR.getString(string2));
        this.shutdownAfterTransfers = new JRadioButton(this.MEDIATOR.getString(string3));
        this.minimizeToTray = new JRadioButton(this.MEDIATOR.getString(string4));
        ButtonGroup buttonGroup = new ButtonGroup();
        boxPanel.add(this.shutdownImmediately);
        boxPanel.add(this.shutdownAfterTransfers);
        buttonGroup.add(this.shutdownImmediately);
        buttonGroup.add(this.shutdownAfterTransfers);
        if (CommonUtils.supportsTray()) {
            boxPanel.add(this.minimizeToTray);
            buttonGroup.add(this.minimizeToTray);
        }
        BoxPanel boxPanel2 = new BoxPanel(0);
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel2.add(boxPanel);
        boxPanel2.add(Box.createHorizontalGlue());
        this.add(boxPanel2);
    }

    public void applyOptions() throws IOException {
        SettingsManager settingsManager = SettingsManager.instance();
        if (this.minimizeToTray.isSelected()) {
            settingsManager.setMinimizeToTray(true);
            settingsManager.setShutdownAfterTransfers(false);
        } else if (this.shutdownAfterTransfers.isSelected()) {
            settingsManager.setMinimizeToTray(false);
            settingsManager.setShutdownAfterTransfers(true);
        } else {
            settingsManager.setMinimizeToTray(false);
            settingsManager.setShutdownAfterTransfers(false);
        }
    }

    public void initOptions() {
        SettingsManager settingsManager = SettingsManager.instance();
        if (settingsManager.getMinimizeToTray()) {
            this.minimizeToTray.setSelected(true);
        } else if (settingsManager.getShutdownAfterTransfers()) {
            this.shutdownAfterTransfers.setSelected(true);
        } else {
            this.shutdownImmediately.setSelected(true);
        }
    }
}

