/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.StandardListEditor;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;

public final class SharedDirPaneItem
extends AbstractPaneItem {
    private final StandardListEditor DIR_LIST = new StandardListEditor(new SelectSharedDirectoryListener());
    private boolean _directoryAdded = false;

    public SharedDirPaneItem(String string) {
        super(string);
        this.add(this.DIR_LIST.getComponent());
    }

    private void addDirectory(File file) {
        if (!file.isDirectory()) {
            return;
        }
        boolean bl = true;
        File[] fileArray = this.DIR_LIST.getDataAsFileArray();
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        int n = 0;
        while (n < fileArray.length) {
            block8: {
                File file2 = fileArray[n];
                String string2 = "";
                try {
                    string2 = file2.getCanonicalPath();
                }
                catch (IOException iOException) {
                    break block8;
                }
                if (string2.equals(string)) {
                    bl = false;
                    break;
                }
            }
            ++n;
        }
        if (bl) {
            this.DIR_LIST.addFile(file);
            this._directoryAdded = true;
        }
    }

    private void handleSaveDirectory() {
        boolean bl = this.MEDIATOR.getSaveDirectoryChanged();
        if (!bl) {
            return;
        }
        String string = "MESSAGE_SHARE_SAVE_DIR";
        int n = GUIMediator.showYesNoMessage(string);
        if (n == 101) {
            try {
                File file = this.SETTINGS.getSaveDirectory();
                this.addDirectory(file);
            }
            catch (FileNotFoundException fileNotFoundException) {
                // empty catch block
            }
        }
    }

    public void initOptions() {
        File[] fileArray = this.SETTINGS.getDirectories();
        this.DIR_LIST.setListData(fileArray);
        this.DIR_LIST.resetList();
        this._directoryAdded = false;
    }

    public void applyOptions() throws IOException {
        this.handleSaveDirectory();
        if (this.DIR_LIST.getListChanged() || this._directoryAdded) {
            this.DIR_LIST.resetList();
            this._directoryAdded = false;
            this.SETTINGS.setDirectories(this.DIR_LIST.getDataAsFileArray());
            Thread thread = new Thread(){

                public void run() {
                    FileManager fileManager = GUIMediator.instance().getRouter().getFileManager();
                    fileManager.loadSettings(true);
                }
            };
            thread.setDaemon(true);
            thread.start();
        }
    }

    private class SelectSharedDirectoryListener
    implements ActionListener {
        private SelectSharedDirectoryListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (SharedDirPaneItem.this.MEDIATOR.showDirectoryChooser() == 0) {
                SharedDirPaneItem.this.addDirectory(SharedDirPaneItem.this.MEDIATOR.getDirectoryChooserSelectedFile());
            }
        }
    }
}

