/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.options.panes;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledComponent;
import com.limegroup.gnutella.gui.SizedWholeNumberField;
import com.limegroup.gnutella.gui.WholeNumberField;
import com.limegroup.gnutella.gui.options.panes.AbstractPaneItem;
import java.io.IOException;

public final class PortPaneItem
extends AbstractPaneItem {
    private final String OPTION_LABEL = "OPTIONS_PORT_BOX_LABEL";
    private WholeNumberField _portField = new SizedWholeNumberField();
    private int _port;

    public PortPaneItem(String string) {
        super(string);
        LabeledComponent labeledComponent = new LabeledComponent("OPTIONS_PORT_BOX_LABEL", this._portField, 120);
        this.add(labeledComponent.getComponent());
    }

    public void initOptions() {
        this._port = this.SETTINGS.getPort();
        this._portField.setValue(this._port);
    }

    public void applyOptions() throws IOException {
        int n = this._portField.getValue();
        if (n != this._port) {
            try {
                this.SETTINGS.setPort(n);
                try {
                    GUIMediator.instance().getRouter().setListeningPort(n);
                    this._port = n;
                }
                catch (IOException iOException) {
                    GUIMediator.showError("ERROR_PORT_UNAVAILABLE");
                    this.SETTINGS.setPort(this._port);
                    this._portField.setValue(this._port);
                    throw new IOException();
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                GUIMediator.showError("ERROR_PORT_RANGE");
                this._portField.setValue(this._port);
                throw new IOException();
            }
        }
    }
}

