/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.notify;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.notify.NotifyUser;

final class WindowsNotifyUser
implements NotifyUser {
    private int _handler = 0;
    private String _tooltip;
    private String _imageFileName;

    WindowsNotifyUser() {
    }

    public void addNotify() {
        String string = "LimeWire: Running the Gnutella Network";
        this.updateNotify("LimeWire.ico", string);
    }

    public void removeNotify() {
        try {
            this.nativeDisable();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public void updateNotify(String string, String string2) {
        try {
            this._tooltip = string2;
            this._imageFileName = string;
            int n = WindowsNotifyUser.nativeLoadImage(string);
            if (n == -1) {
                return;
            }
            this.nativeEnable(n, this._tooltip);
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            unsatisfiedLinkError.printStackTrace();
        }
    }

    public void updateImage(String string) {
        this.updateNotify(string, this._tooltip);
    }

    public void updateDesc(String string) {
        this.updateNotify(this._imageFileName, string);
    }

    public void hideNotify() {
        try {
            this.nativeHide();
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            // empty catch block
        }
    }

    public void restoreApplication() {
        GUIMediator.restoreView();
    }

    public void exitApplication() {
        GUIMediator.shutdown();
    }

    public void exitAfterTransfers() {
        GUIMediator.shutdownAfterTransfers();
    }

    public void showAboutWindow() {
        GUIMediator.showAboutWindow();
    }

    private synchronized native void nativeDisable() throws UnsatisfiedLinkError;

    private synchronized native void nativeEnable(int var1, String var2) throws UnsatisfiedLinkError;

    private static synchronized native void nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImage(String var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageFromResource(int var0) throws UnsatisfiedLinkError;

    private synchronized native void nativeHide() throws UnsatisfiedLinkError;
}

