/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.StatusLine;
import com.limegroup.gnutella.gui.mp3.PlayList;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.mp3.PlayingSongRenderer;
import com.limegroup.gnutella.mp3.MP3Info;
import com.sun.java.util.collections.ArrayList;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class PlayListGUI
extends PaddedPanel
implements MouseListener {
    public static final String TEMP_PL_NAME = ".temp.m3u.LW";
    private static PlayListGUI _instance = null;
    private SettingsManager _settings;
    private JFileChooser _fileChooser;
    private JFileChooser _saveAsChooser;
    private GUIMediator _mediator;
    private BasicTableModel _tableModel;
    private JTable _table;
    private PlayList _playList;
    private PlayList _tempPL;
    private boolean _repeatSongs = true;
    private boolean _shuffleSongs = false;
    private int _playIndex = -1;
    private ArrayList _unsavedFiles = new ArrayList();
    private boolean debugOn = true;
    static /* synthetic */ Class class$java$lang$String;

    public boolean shouldRepeat() {
        return this._repeatSongs;
    }

    public int getPlayIndex() {
        return this._playIndex;
    }

    private void resetPlayIndex() {
        this._playIndex = -1;
    }

    public static PlayListGUI instance() {
        if (_instance == null) {
            _instance = new PlayListGUI();
        }
        return _instance;
    }

    private PlayListGUI() {
        super(GUIMediator.getStringResource("PLAYLIST_TITLE"));
        this._settings = SettingsManager.instance();
        this._fileChooser = new JFileChooser();
        this._fileChooser.setDialogTitle(GUIMediator.getStringResource("PLAYLIST_DIALOG_OPEN_TITLE"));
        this._saveAsChooser = new JFileChooser();
        this._saveAsChooser.setDialogTitle(GUIMediator.getStringResource("PLAYLIST_DIALOG_SAVE_TITLE"));
        this._saveAsChooser.setApproveButtonText(GUIMediator.getStringResource("PLAYLIST_DIALOG_SAVE_SAVE"));
        this._tableModel = new BasicTableModel();
        this._tableModel.addColumn(GUIMediator.getStringResource("PLAYLIST_TABLE_NAME"));
        this._tableModel.addColumn(GUIMediator.getStringResource("PLAYLIST_TABLE_LENGTH"));
        this._tableModel.addColumn(GUIMediator.getStringResource("PLAYLIST_TABLE_BITRATE"));
        this._table = new JTable(this._tableModel);
        this._table.setShowGrid(false);
        this._table.setColumnSelectionAllowed(false);
        this._table.getColumnModel().getColumn(0).setPreferredWidth(450);
        this._table.getColumnModel().getColumn(1).setPreferredWidth(20);
        this._table.getColumnModel().getColumn(2).setPreferredWidth(20);
        this._table.setDefaultRenderer(class$java$lang$String == null ? (class$java$lang$String = PlayListGUI.class$("java.lang.String")) : class$java$lang$String, new PlayingSongRenderer());
        this._table.addMouseListener(this);
        JTableHeader jTableHeader = this._table.getTableHeader();
        jTableHeader.addMouseListener(new SortTableListener());
        JScrollPane jScrollPane = new JScrollPane(this._table);
        jScrollPane.getViewport().setBackground(Color.white);
        this.add(jScrollPane);
        String[] stringArray = new String[]{"PLAYLIST_LOAD_BUTTON_LABEL", "PLAYLIST_SAVE_BUTTON_LABEL", "PLAYLIST_DELETE_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"PLAYLIST_LOAD_BUTTON_TIP", "PLAYLIST_SAVE_BUTTON_TIP", "PLAYLIST_DELETE_BUTTON_TIP"};
        ActionListener[] actionListenerArray = new ActionListener[]{new LoadListener(), new SaveListener(), new DeleteListener()};
        this.add(Box.createVerticalStrut(6));
        JPanel jPanel = new JPanel(new BorderLayout());
        jPanel.add((Component)new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 14), "West");
        JLabel jLabel = new JLabel(GUIMediator.getStringResource("PLAYLIST_OPTIONS_STRING"));
        final JCheckBox jCheckBox = new JCheckBox(GUIMediator.getStringResource("PLAYLIST_OPTIONS_SHUFFLE"), false);
        jCheckBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayListGUI.this._shuffleSongs = !PlayListGUI.this._shuffleSongs;
                PlayList playList = PlayListGUI.this.getCurrentPlayList();
                if (playList != null && playList.isShuffled() != PlayListGUI.this._shuffleSongs) {
                    playList.toggleShuffle();
                }
            }
        });
        JCheckBox jCheckBox2 = new JCheckBox(GUIMediator.getStringResource("PLAYLIST_OPTIONS_CONTINUE"), true);
        jCheckBox2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                PlayListGUI.this._repeatSongs = !PlayListGUI.this._repeatSongs;
                jCheckBox.setEnabled(PlayListGUI.this._repeatSongs);
            }
        });
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jLabel);
        jPanel2.add(jCheckBox2);
        jPanel2.add(jCheckBox);
        jPanel.add((Component)jPanel2, "East");
        this.add(jPanel);
        try {
            this._tempPL = new PlayList(TEMP_PL_NAME);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public File getFileToPlay() {
        File file = null;
        PlayList playList = this.getCurrentPlayList();
        int[] nArray = this._table.getSelectedRows();
        if (playList != null) {
            int n = this._playIndex;
            if (nArray.length > 0) {
                file = playList.getSong(nArray[0]);
                this._playIndex = playList.setCurrSongIndex(nArray[0]);
                this._table.clearSelection();
            } else if (this.shouldRepeat()) {
                file = playList.getNextSong();
                this._playIndex = playList.getCurrSongIndex();
            }
            this.focusChange(this._playIndex);
            if (n >= 0) {
                this._tableModel.fireTableRowsUpdated(n, n);
            }
            if (this._playIndex >= 0) {
                this._tableModel.fireTableRowsUpdated(this._playIndex, this._playIndex);
            }
        }
        return file;
    }

    public boolean songIsSelected() {
        boolean bl = false;
        int[] nArray = this._table.getSelectedRows();
        if (nArray.length > 0) {
            bl = true;
        }
        return bl;
    }

    public void setBackwardsMode() {
        PlayList playList = this.getCurrentPlayList();
        if (playList != null) {
            playList.setBackwardsMode();
        }
    }

    public void playComplete(boolean bl) {
        if (bl) {
            int n = this._playIndex;
            this.resetPlayIndex();
            if (n >= 0) {
                this._tableModel.fireTableRowsUpdated(n, n);
            }
        }
    }

    public void addFileToPlayList(File file) {
        if (this._playList != null) {
            this._playList.addSong(file);
        } else {
            if (this._tempPL != null) {
                this._tempPL.addSong(file);
            }
            this._unsavedFiles.add((Object)file);
        }
        ArrayList arrayList = this.constructRow(file);
        this._tableModel.addRow(arrayList);
    }

    private void focusChange(int n) {
        if (n > -1 && n < this._tableModel.getRowCount()) {
            this._table.setRowSelectionInterval(n, n);
            Rectangle rectangle = this._table.getCellRect(n, 0, false);
            if (rectangle != null) {
                this._table.scrollRectToVisible(rectangle);
            }
        }
        this._table.clearSelection();
    }

    private ArrayList constructRow(File file) {
        ArrayList arrayList = new ArrayList();
        arrayList.add((Object)file.getName());
        try {
            MP3Info mP3Info = new MP3Info(file.getCanonicalPath());
            arrayList.add((Object)this.getSecondsLength(mP3Info));
            arrayList.add((Object)(new String() + mP3Info.getBitRate()));
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return arrayList;
    }

    private void fillUpJTable(PlayList playList) {
        int n = 0;
        int n2 = 0;
        int n3 = 0;
        while (n3 < playList.getNumSongs()) {
            File file = playList.getSong(n3);
            ArrayList arrayList = this.constructRow(file);
            this._tableModel.addRowSansUpdate(arrayList);
            if (n3 % 19 == 0 || n3 == playList.getNumSongs() - 1) {
                n2 = n3;
                final int n4 = n;
                final int n5 = n2;
                SwingUtilities.invokeLater(new Thread(){

                    public void run() {
                        PlayListGUI.this._tableModel.updateRows(n4, n5);
                    }
                });
                n = n2 + 1;
            }
            ++n3;
        }
    }

    private String getSecondsLength(MP3Info mP3Info) {
        StringBuffer stringBuffer = new StringBuffer();
        long l = mP3Info.getLengthInSeconds();
        long l2 = l / 60L;
        long l3 = l - 60L * l2;
        stringBuffer.append("" + l2);
        stringBuffer.append(":");
        if (l3 > 9L) {
            stringBuffer.append("" + l3);
        } else {
            stringBuffer.append("0" + l3);
        }
        return stringBuffer.toString();
    }

    private PlayList getCurrentPlayList() {
        PlayList playList = null;
        playList = this._playList != null ? this._playList : this._tempPL;
        return playList;
    }

    public void launchSong(File file) {
        StatusLine.launchSong(file);
        this.resetPlayIndex();
    }

    private void debug(String string) {
        if (this.debugOn) {
            System.out.println(string);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() > 1) {
            StatusLine.songDoubleClicked();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static /* synthetic */ void access$1100(PlayListGUI playListGUI, PlayList playList) {
        playListGUI.fillUpJTable(playList);
    }

    static /* synthetic */ void access$2000(PlayListGUI playListGUI, int n) {
        playListGUI.focusChange(n);
    }

    private class SortTableListener
    extends MouseAdapter {
        private SortTableListener() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = PlayListGUI.this._table.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = PlayListGUI.this._table.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 == 0) {
                PlayListGUI playListGUI = PlayListGUI.instance();
                synchronized (playListGUI) {
                    PlayList playList = PlayListGUI.this.getCurrentPlayList();
                    if (playList != null) {
                        File file = null;
                        if (PlayListGUI.this._playIndex > -1) {
                            file = playList.getSong(PlayListGUI.this._playIndex);
                        }
                        playList.sortByName();
                        PlayListGUI.this._tableModel.clearTable();
                        if (PlayListGUI.this._playIndex > -1 && file != null) {
                            PlayListGUI.this._playIndex = playList.getIndexOfSong(file);
                            playList.setCurrSongIndex(PlayListGUI.this._playIndex);
                        }
                        new Thread(this, playList){
                            private final /* synthetic */ PlayList val$plToSort;
                            private final /* synthetic */ SortTableListener this$1;
                            {
                                this.this$1 = sortTableListener;
                                this.val$plToSort = playList;
                            }

                            public void run() {
                                PlayListGUI.access$1100(SortTableListener.access$1800(this.this$1), this.val$plToSort);
                                if (PlayListGUI.access$1700(SortTableListener.access$1800(this.this$1)) > 0) {
                                    SwingUtilities.invokeLater(new Thread(this){
                                        private final /* synthetic */ 5 this$2;
                                        {
                                            this.this$2 = var1_1;
                                        }

                                        public void run() {
                                            PlayListGUI.access$2000(SortTableListener.access$1800(5.access$1900(this.this$2)), PlayListGUI.access$1700(SortTableListener.access$1800(5.access$1900(this.this$2))));
                                        }
                                    });
                                }
                            }

                            static /* synthetic */ SortTableListener access$1900(5 var0) {
                                return var0.this$1;
                            }
                        }.start();
                    }
                }
            }
        }

        static /* synthetic */ PlayListGUI access$1800(SortTableListener sortTableListener) {
            return sortTableListener.PlayListGUI.this;
        }
    }

    private class BasicTableModel
    extends AbstractTableModel {
        private ArrayList names;
        private ArrayList data;
        private Class stringClass = new String().getClass();

        public BasicTableModel() {
            this.names = new ArrayList();
            this.data = new ArrayList();
        }

        public String getColumnName(int n) {
            return (String)this.names.get(n);
        }

        public int getColumnCount() {
            return this.names.size();
        }

        public int getRowCount() {
            return this.data.size();
        }

        public Object getValueAt(int n, int n2) {
            String string = null;
            try {
                ArrayList arrayList = (ArrayList)this.data.get(n);
                if (n2 < arrayList.size()) {
                    string = (String)arrayList.get(n2);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return string;
        }

        public Class getColumnClass(int n) {
            return this.stringClass;
        }

        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public void setValueAt(Object object, int n, int n2) {
            ArrayList arrayList = (ArrayList)this.data.get(n);
            if (n2 >= arrayList.size()) {
                while (n2 >= arrayList.size()) {
                    arrayList.add(null);
                }
            }
            arrayList.set(n2, object);
            this.fireTableCellUpdated(n, n2);
        }

        public void addColumn(String string) {
            this.names.add((Object)string);
            this.fireTableStructureChanged();
        }

        public int addRow() {
            ArrayList arrayList = new ArrayList();
            return this.addRow(arrayList);
        }

        public int addRow(ArrayList arrayList) {
            this.data.add((Object)arrayList);
            this.fireTableRowsInserted(this.data.size() - 1, this.data.size() - 1);
            return this.data.size() - 1;
        }

        public int addRowSansUpdate(ArrayList arrayList) {
            this.data.add((Object)arrayList);
            return this.data.size() - 1;
        }

        public void updateRows(int n, int n2) {
            this.fireTableRowsInserted(n, n2);
        }

        public void deleteRow(int n) {
            if (n == -1) {
                return;
            }
            this.data.remove(n);
            this.fireTableRowsDeleted(n, n);
        }

        public void clearTable() {
            this.data.clear();
            this.fireTableDataChanged();
        }
    }

    private class DeleteListener
    implements ActionListener {
        private DeleteListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            PlayList playList = PlayListGUI.this.getCurrentPlayList();
            int[] nArray = PlayListGUI.this._table.getSelectedRows();
            if (nArray.length > 0 && playList != null) {
                int n = 0;
                while (n < nArray.length) {
                    int n2 = nArray[n] - n;
                    playList.deleteSong(n2);
                    if (PlayListGUI.this._playIndex == n2) {
                        PlayListGUI.this.resetPlayIndex();
                    } else if (PlayListGUI.this._playIndex > n2) {
                        PlayListGUI.this._playIndex--;
                    }
                    PlayListGUI.this._tableModel.deleteRow(n2);
                    ++n;
                }
            }
        }
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (PlayListGUI.this._playList == null && (n = PlayListGUI.this._saveAsChooser.showOpenDialog(PlayListGUI.instance())) == 0) {
                try {
                    File file = PlayListGUI.this._saveAsChooser.getSelectedFile();
                    if (file.exists()) {
                        file.delete();
                    }
                    PlayListGUI.this._playList = new PlayList(file.getCanonicalPath());
                    if (PlayListGUI.this._playList.isShuffled() != PlayListGUI.this._shuffleSongs) {
                        PlayListGUI.this._playList.toggleShuffle();
                    }
                    int n2 = 0;
                    while (n2 < PlayListGUI.this._unsavedFiles.size()) {
                        File file2 = (File)PlayListGUI.this._unsavedFiles.get(n2);
                        PlayListGUI.this._playList.addSong(file2);
                        ++n2;
                    }
                    PlayListGUI.this._unsavedFiles.clear();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                PlayListGUI.this._tempPL = null;
            }
            if (PlayListGUI.this._playList != null) {
                try {
                    PlayListGUI.this._playList.save();
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    private class LoadListener
    implements ActionListener {
        private LoadListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = PlayListGUI.this._fileChooser.showOpenDialog(PlayListGUI.instance());
            if (n == 0) {
                new Thread(this){
                    private final /* synthetic */ LoadListener this$1;
                    {
                        this.this$1 = loadListener;
                    }

                    public void run() {
                        try {
                            PlayListGUI.access$900(LoadListener.access$800(this.this$1)).clearTable();
                            File file = PlayListGUI.access$700(LoadListener.access$800(this.this$1)).getSelectedFile();
                            PlayListGUI.access$1002(LoadListener.access$800(this.this$1), new PlayList(file.getCanonicalPath()));
                            if (PlayListGUI.access$1000(LoadListener.access$800(this.this$1)).isShuffled() != PlayListGUI.access$400(LoadListener.access$800(this.this$1))) {
                                PlayListGUI.access$1000(LoadListener.access$800(this.this$1)).toggleShuffle();
                            }
                            PlayListGUI.access$1100(LoadListener.access$800(this.this$1), PlayListGUI.access$1000(LoadListener.access$800(this.this$1)));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                }.start();
                PlayListGUI.this.resetPlayIndex();
            }
        }

        static /* synthetic */ PlayListGUI access$800(LoadListener loadListener) {
            return loadListener.PlayListGUI.this;
        }
    }
}

