/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.Assert;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.mp3.BasicPlayer;
import com.limegroup.gnutella.gui.mp3.BasicPlayerListener;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.gui.mp3.SongProgressBar;
import com.sun.java.util.collections.LinkedList;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.plaf.metal.MetalProgressBarUI;

public class MediaPlayerComponent
implements BasicPlayerListener {
    private static BasicPlayer myPlayer;
    private JProgressBar myProgressBar;
    private static PlayListGUI myPlayList;
    private static PlayThread myPlayThread;
    private File myCurrentPlayingFile = null;
    private int currBeginIndex = -1;
    private static final int STRING_SIZE_TO_SHOW = 24;
    private static int lastButtonPressed;
    private static final int PLAY_BUTTON = 0;
    private static final int PAUSE_BUTTON = 1;
    private static final int STOP_BUTTON = 2;
    public static MediaPlayerComponent myInstance;
    private JPanel myMediaPanel = null;
    private InitialDisplayThread myIDT = null;
    int iterations = 0;
    private final boolean debugOn = false;

    public MediaPlayerComponent() {
        myPlayer = new BasicPlayer(this);
        myPlayThread = new PlayThread();
        myPlayThread.start();
        myInstance = this;
    }

    public JPanel getMediaPanel() {
        if (this.myMediaPanel == null) {
            this.myMediaPanel = this.constructMediaPanel();
        }
        return this.myMediaPanel;
    }

    private JPanel constructMediaPanel() {
        BoxPanel boxPanel = GUIMediator.shouldShowAds() ? new BoxPanel(1) : new BoxPanel(0);
        BoxPanel boxPanel2 = new BoxPanel(0);
        ImageIcon imageIcon = null;
        int n = 0;
        int n2 = 0;
        JButton jButton = new JButton();
        imageIcon = GUIMediator.getImageResource("play_up.gif");
        jButton.setIcon(imageIcon);
        jButton.setHorizontalAlignment(0);
        jButton.setPressedIcon(GUIMediator.getImageResource("play_dn.gif"));
        jButton.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        jButton.setMargin(new Insets(0, 0, 0, 0));
        n += imageIcon.getIconWidth() + 2;
        n2 += imageIcon.getIconHeight() + 2;
        JButton jButton2 = new JButton();
        imageIcon = GUIMediator.getImageResource("pause_up.gif");
        jButton2.setIcon(imageIcon);
        jButton2.setPressedIcon(GUIMediator.getImageResource("pause_dn.gif"));
        jButton2.setHorizontalAlignment(0);
        jButton2.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        jButton2.setMargin(new Insets(0, 0, 0, 0));
        n += imageIcon.getIconWidth() + 2;
        JButton jButton3 = new JButton();
        imageIcon = GUIMediator.getImageResource("stop_up.gif");
        jButton3.setIcon(imageIcon);
        jButton3.setPressedIcon(GUIMediator.getImageResource("stop_dn.gif"));
        jButton3.setHorizontalAlignment(0);
        jButton3.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        jButton3.setMargin(new Insets(0, 0, 0, 0));
        n += imageIcon.getIconWidth() + 2;
        JButton jButton4 = new JButton();
        imageIcon = GUIMediator.getImageResource("forward_up.gif");
        jButton4.setIcon(imageIcon);
        jButton4.setPressedIcon(GUIMediator.getImageResource("forward_dn.gif"));
        jButton4.setHorizontalAlignment(0);
        jButton4.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        jButton4.setMargin(new Insets(0, 0, 0, 0));
        n += imageIcon.getIconWidth() + 2;
        JButton jButton5 = new JButton();
        imageIcon = GUIMediator.getImageResource("rewind_up.gif");
        jButton5.setIcon(imageIcon);
        jButton5.setPressedIcon(GUIMediator.getImageResource("rewind_dn.gif"));
        jButton5.setHorizontalAlignment(0);
        jButton5.setPreferredSize(new Dimension(imageIcon.getIconWidth(), imageIcon.getIconHeight()));
        jButton5.setMargin(new Insets(0, 0, 0, 0));
        n += imageIcon.getIconWidth() + 2;
        this.myProgressBar = new SongProgressBar();
        this.myProgressBar.setUI(new MetalProgressBarUI());
        this.myProgressBar.setMaximumSize(new Dimension(110, 15));
        this.myProgressBar.setPreferredSize(new Dimension(110, 15));
        this.myProgressBar.setBorderPainted(true);
        jButton.addActionListener(new PlayListener());
        jButton2.addActionListener(new PauseListener());
        jButton3.addActionListener(new StopListener());
        jButton4.addActionListener(new NextListener());
        jButton5.addActionListener(new BackListener());
        this.myProgressBar.addChangeListener(new SeekChangeListener());
        this.updatePBValue(0);
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel2.setMaximumSize(new Dimension(n, n2));
        boxPanel2.setMinimumSize(new Dimension(n, n2));
        boxPanel2.add(jButton5);
        boxPanel2.add(jButton);
        boxPanel2.add(jButton2);
        boxPanel2.add(jButton3);
        boxPanel2.add(jButton4);
        boxPanel2.add(Box.createHorizontalGlue());
        boxPanel.add(Box.createVerticalGlue());
        if (GUIMediator.shouldShowAds()) {
            boxPanel.add(this.myProgressBar);
            boxPanel.add(boxPanel2);
        } else {
            boxPanel.add(boxPanel2);
            boxPanel.add(this.myProgressBar);
        }
        boxPanel.add(Box.createVerticalGlue());
        BoxPanel boxPanel3 = boxPanel;
        boxPanel = new BoxPanel(0);
        boxPanel.add(Box.createHorizontalGlue());
        boxPanel.add(boxPanel3);
        myPlayList = PlayListGUI.instance();
        this.myIDT = new InitialDisplayThread();
        this.myIDT.start();
        return boxPanel;
    }

    private void playPressedAndPaused() {
        if (myPlayer.getStatus() == 1 && myPlayer.getFrameSeek() == 0) {
            myPlayer.unpause();
        }
    }

    void skipSong() {
        if (myPlayer.getStatus() == 0 && myPlayList.shouldRepeat()) {
            myPlayer.stop();
        }
    }

    void stopSong() {
        myPlayer.stop();
    }

    void pauseSong() {
        if (myPlayer.getStatus() == 1) {
            if (myPlayer.getFrameSeek() != 0) {
                myPlayer.stop();
            } else {
                myPlayer.unpause();
            }
        } else {
            myPlayer.pause();
        }
    }

    public void setUpSeek(int n) {
        if (this.myIDT != null) {
            this.updatePBStringPainted(false);
            if (this.myIDT.isAlive()) {
                this.myIDT.shutdown();
            }
            try {
                this.myIDT.join();
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.myIDT = null;
        }
        this.updatePBValue(0);
        this.updatePBMaximum(n);
        this.updatePBString(this.myCurrentPlayingFile.getName());
        this.updatePBStringPainted(true);
        this.currBeginIndex = 0;
    }

    public void playComplete() {
        this.updatePBValue(this.myProgressBar.getMaximum());
        this.updatePBStringPainted(false);
        this.updatePBString(null);
        if (lastButtonPressed == 2 || !myPlayList.shouldRepeat()) {
            myPlayList.playComplete(true);
        } else {
            myPlayList.playComplete(false);
        }
        if (myPlayList.shouldRepeat() && lastButtonPressed != 2) {
            myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
        }
    }

    public void updateSongPosition(int n) {
        this.updatePBValue(n);
        if (this.iterations++ > 9) {
            if (this.myCurrentPlayingFile.getName().length() > 24) {
                String string = "*** " + this.myCurrentPlayingFile.getName() + " ";
                if (++this.currBeginIndex > string.length()) {
                    this.currBeginIndex = 0;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (this.currBeginIndex + 24 > string.length()) {
                    stringBuffer.append(string.substring(this.currBeginIndex));
                    int n2 = 24 - (string.length() - this.currBeginIndex);
                    stringBuffer.append(string.substring(0, n2));
                } else {
                    stringBuffer.append(string.substring(this.currBeginIndex, this.currBeginIndex + 24));
                }
                this.updatePBString(stringBuffer.toString());
            }
            this.iterations = 0;
        }
    }

    private void updatePBString(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setString(string);
            }
        });
    }

    private void updatePBStringPainted(final boolean bl) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setStringPainted(bl);
            }
        });
    }

    private void updatePBValue(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setValue(n);
            }
        });
    }

    private void updatePBMaximum(final int n) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                MediaPlayerComponent.this.myProgressBar.setMaximum(n);
            }
        });
    }

    public static void songDoubleClicked() {
        if (myInstance == null) {
            return;
        }
        switch (myPlayer.getStatus()) {
            case 2: {
                lastButtonPressed = 0;
                myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                break;
            }
            case 0: {
                if (!myPlayList.shouldRepeat()) {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                    break;
                }
                myInstance.skipSong();
                break;
            }
            case 1: {
                if (!myPlayList.shouldRepeat()) {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
                    break;
                }
                myPlayer.stop();
                myInstance.skipSong();
            }
        }
    }

    public static void launchSong(File file) {
        if (myInstance != null && file != null) {
            switch (myPlayer.getStatus()) {
                case 2: {
                    myPlayThread.addFileToPlay(file);
                    break;
                }
                case 0: {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(file);
                    break;
                }
                case 1: {
                    myPlayer.stop();
                    myPlayThread.addFileToPlay(file);
                }
            }
        }
    }

    private void debug(String string) {
    }

    static {
        myPlayThread = null;
        lastButtonPressed = -1;
    }

    public class PlayThread
    extends Thread {
        private LinkedList list = new LinkedList();
        private Object lock = new Object();
        private boolean shouldRun = true;

        public void shutdown() {
            this.shouldRun = false;
        }

        public void run() {
            MediaPlayerComponent.this.debug("PlayThread.run(): entered.");
            while (this.shouldRun) {
                Object object = this.lock;
                synchronized (object) {
                    if (this.list.isEmpty()) {
                        try {
                            MediaPlayerComponent.this.debug("PlayThread.run(): waiting for a file.");
                            this.lock.wait();
                            MediaPlayerComponent.this.debug("PlayThread.run(): woken up.");
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                Assert.that(!this.list.isEmpty());
                MediaPlayerComponent.this.debug("PlayThread.run(): myPlayer.getStatus() = " + myPlayer.getStatus());
                if (myPlayer.getStatus() != 2) continue;
                File file = null;
                while (!this.list.isEmpty()) {
                    file = this.getFileToPlay();
                    try {
                        if (this.list.isEmpty()) {
                            Thread.sleep(250L);
                            continue;
                        }
                        Thread.sleep(50L);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                MediaPlayerComponent.this.debug("PlayThread.run(): playing file " + file);
                myPlayer.play(file);
                MediaPlayerComponent.this.myCurrentPlayingFile = file;
            }
        }

        public void addFileToPlay(File file) {
            if (file != null) {
                Object object = this.lock;
                synchronized (object) {
                    this.list.addLast((Object)file);
                    this.lock.notify();
                }
            }
        }

        private File getFileToPlay() {
            File file = null;
            Object object = this.lock;
            synchronized (object) {
                file = (File)this.list.removeFirst();
            }
            return file;
        }
    }

    public class InitialDisplayThread
    extends Thread {
        private boolean shouldRun = true;
        private final int SLEEP_INTERVAL = 400;
        private final String DISPLAY = GUIMediator.getStringResource("MEDIA_PLAYER_DEFAULT_STRING");
        private int showIndex = -1;

        public void shutdown() {
            this.shouldRun = false;
        }

        public void run() {
            MediaPlayerComponent.this.updatePBStringPainted(true);
            while (this.shouldRun) {
                try {
                    Thread.sleep(400L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (++this.showIndex > this.DISPLAY.length()) {
                    this.showIndex = 0;
                }
                StringBuffer stringBuffer = new StringBuffer();
                if (this.DISPLAY.length() <= 24) {
                    stringBuffer.append(this.DISPLAY);
                } else if (this.showIndex + 24 > this.DISPLAY.length()) {
                    stringBuffer.append(this.DISPLAY.substring(this.showIndex));
                    int n = 24 - (this.DISPLAY.length() - this.showIndex);
                    stringBuffer.append(this.DISPLAY.substring(0, n));
                } else {
                    stringBuffer.append(this.DISPLAY.substring(this.showIndex, this.showIndex + 24));
                }
                MediaPlayerComponent.this.updatePBString(stringBuffer.toString());
            }
        }
    }

    public class SeekChangeListener
    implements ChangeListener {
        public void stateChanged(ChangeEvent changeEvent) {
        }
    }

    private class PauseListener
    implements ActionListener {
        private PauseListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            MediaPlayerComponent.this.pauseSong();
        }
    }

    private class BackListener
    implements ActionListener {
        private BackListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (myPlayer.getStatus() != 2) {
                myPlayList.setBackwardsMode();
                if (myPlayer.getStatus() == 1) {
                    myPlayer.unpause();
                }
                MediaPlayerComponent.this.skipSong();
            }
        }
    }

    private class NextListener
    implements ActionListener {
        private NextListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (myPlayer.getStatus() != 2) {
                if (myPlayer.getStatus() == 1) {
                    myPlayer.unpause();
                }
                MediaPlayerComponent.this.skipSong();
            }
        }
    }

    private class StopListener
    implements ActionListener {
        private StopListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            lastButtonPressed = 2;
            MediaPlayerComponent.this.stopSong();
        }
    }

    private class PlayListener
    implements ActionListener {
        private PlayListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            lastButtonPressed = 0;
            if (myPlayer.getStatus() == 1) {
                MediaPlayerComponent.this.playPressedAndPaused();
            } else if (myPlayer.getStatus() == 2) {
                myPlayThread.addFileToPlay(myPlayList.getFileToPlay());
            } else if (myPlayer.getStatus() == 0 && myPlayList.songIsSelected()) {
                MediaPlayerComponent.this.skipSong();
            }
        }
    }
}

