/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.mp3;

import com.limegroup.gnutella.gui.mp3.BasicPlayerListener;
import com.limegroup.gnutella.gui.mp3.WaveStreamObuffer;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.DataLine;
import javax.sound.sampled.FloatControl;
import javax.sound.sampled.SourceDataLine;
import javazoom.jl.decoder.Bitstream;
import javazoom.jl.decoder.Decoder;
import javazoom.jl.decoder.JavaLayerException;
import javazoom.jl.decoder.Obuffer;

public class BasicPlayer {
    public static final int STATUS_PLAYING = 0;
    public static final int STATUS_PAUSED = 1;
    public static final int STATUS_STOPPED = 2;
    private int status = 2;
    private static Thread playthread;
    private WaveStreamObuffer output = null;
    private Decoder decoder;
    private SourceDataLine line = null;
    private FloatControl Jvolume;
    private FloatControl Jpan;
    int currentFrameLength = 413;
    float volumeLevel = 0.0f;
    float panLevel = 0.0f;
    int frameSeek = 0;
    private String currentMP3;
    int framesRead = 0;
    private Object pauseLock = new Object();
    private BasicPlayerListener parent;
    private static final int MAX_JOIN_TIME = 3000;
    static /* synthetic */ Class class$javax$sound$sampled$SourceDataLine;

    public int getFrameSeek() {
        return this.frameSeek;
    }

    public int getFramesRead() {
        return this.framesRead;
    }

    public BasicPlayer(BasicPlayerListener basicPlayerListener) {
        this.parent = basicPlayerListener;
    }

    public void play(String string) {
        this.currentMP3 = string;
        playthread = new PlayThread(string);
        playthread.start();
    }

    public void play(File file) {
        try {
            this.play(file.getCanonicalPath());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    private void doplay(String var1_1) throws JavaLayerException {
        block41: {
            this.framesRead = 0;
            this.decoder = new Decoder(null);
            if (this.line != null) {
                this.line = null;
            }
            var2_2 = null;
            var3_3 = false;
            try {
                block40: {
                    try {
                        var2_2 = this.openInput(var1_1);
                        var4_4 = new Bitstream(var2_2);
                        this.status = 0;
                        while (this.status != 2) {
                            if (this.status == 0) {
                                if (this.status == 2) {
                                    throw new Exception();
                                }
                                var5_6 /* !! */  = var4_4.readFrame();
                                if (var5_6 /* !! */  == null) ** break;
                                ++this.framesRead;
                                this.currentFrameLength = var5_6 /* !! */ .framesize;
                                if (this.status == 2) {
                                    throw new Exception();
                                }
                                while (true) {
                                    if (this.frameSeek <= 0) {
                                        if (!var3_3) {
                                            this.parent.setUpSeek(this.countFrames(var1_1));
                                            var3_3 = true;
                                        }
                                        this.parent.updateSongPosition(this.framesRead);
                                        if (this.status != 2) break;
                                        throw new Exception();
                                    }
                                    var4_4.closeFrame();
                                    --this.frameSeek;
                                    var5_6 /* !! */  = var4_4.readFrame();
                                    ++this.framesRead;
                                }
                                if (this.line == null) {
                                    var6_8 = var5_6 /* !! */ .mode() == 3 ? 1 : 2;
                                    var7_9 = var5_6 /* !! */ .frequency();
                                    this.output = new WaveStreamObuffer(var6_8, var7_9);
                                    this.decoder.setOutputBuffer((Obuffer)this.output);
                                    this.line = this.getALine(var6_8, var7_9);
                                    this.setUpControls();
                                    this.line.start();
                                }
                                this.decoder.decodeFrame(var5_6 /* !! */ , var4_4);
                                if (this.status == 2) {
                                    throw new Exception();
                                }
                                var6_7 = this.output.get_data();
                                if (this.line != null && this.line.isOpen()) {
                                    this.line.write(var6_7, 0, var6_7.length);
                                }
                                var4_4.closeFrame();
                            }
                            if (this.status != 1) continue;
                            var5_6 /* !! */  = this.pauseLock;
                            // MONITORENTER : var5_6 /* !! */ 
                            this.pauseLock.wait();
                            // MONITOREXIT : var5_6 /* !! */ 
                        }
                    }
                    catch (Exception var4_5) {
                        block42: {
                            var10_11 = null;
                            if (this.output != null) {
                                this.output.close();
                            }
                            if (this.line != null) {
                                try {}
                                catch (Throwable var12_26) {
                                    var13_18 = null;
                                    this.line = null;
                                    throw var12_26;
                                }
                                try {}
                                catch (Exception var11_23) {
                                    var13_17 = null;
                                    this.line = null;
                                    break block42;
                                }
                                this.line.drain();
                                this.line.stop();
                                this.line.close();
                                var13_16 = null;
                                this.line = null;
                            }
                        }
                        if (var2_2 == null) break block41;
                        try {}
                        catch (Throwable var14_38) {
                            var15_33 = null;
                            var2_2 = null;
                            throw var14_38;
                        }
                        try {}
                        catch (Exception var11_23) {
                            var15_32 = null;
                            var2_2 = null;
                            break block41;
                        }
                        var2_2.close();
                        var15_31 = null;
                        var2_2 = null;
                        break block41;
                    }
                    var10_10 = null;
                    if (this.output != null) {
                        this.output.close();
                    }
                    if (this.line != null) {
                        try {
                            try {
                                this.line.drain();
                                this.line.stop();
                                this.line.close();
                            }
                            catch (Exception var11_22) {
                                var13_14 = null;
                                this.line = null;
                                break block40;
                            }
                            var13_13 = null;
                            this.line = null;
                        }
                        catch (Throwable var12_25) {
                            var13_15 = null;
                            this.line = null;
                            throw var12_25;
                        }
                    }
                }
                if (var2_2 == null) break block41;
                try {
                    try {
                        var2_2.close();
                    }
                    catch (Exception var11_22) {
                        var15_29 = null;
                        var2_2 = null;
                    }
                    var15_28 = null;
                    var2_2 = null;
                }
                catch (Throwable var14_37) {
                    var15_30 = null;
                    var2_2 = null;
                    throw var14_37;
                }
            }
            catch (Throwable var9_40) {
                block43: {
                    var10_12 = null;
                    if (this.output != null) {
                        this.output.close();
                    }
                    if (this.line != null) {
                        try {}
                        catch (Throwable var12_27) {
                            var13_21 = null;
                            this.line = null;
                            throw var12_27;
                        }
                        try {}
                        catch (Exception var11_24) {
                            var13_20 = null;
                            this.line = null;
                            break block43;
                        }
                        this.line.drain();
                        this.line.stop();
                        this.line.close();
                        var13_19 = null;
                        this.line = null;
                    }
                }
                if (var2_2 == null) throw var9_40;
                try {}
                catch (Throwable var14_39) {
                    var15_36 = null;
                    var2_2 = null;
                    throw var14_39;
                }
                try {}
                catch (Exception var11_24) {
                    var15_35 = null;
                    var2_2 = null;
                    throw var9_40;
                }
                var2_2.close();
                var15_34 = null;
                var2_2 = null;
                throw var9_40;
            }
        }
        if (this.status != 2) {
            this.status = 2;
        }
        this.parent.playComplete();
    }

    private SourceDataLine getALine(int n, int n2) throws Exception {
        AudioFormat audioFormat = new AudioFormat(n2, 16, n, true, false);
        DataLine.Info info = new DataLine.Info(class$javax$sound$sampled$SourceDataLine == null ? (class$javax$sound$sampled$SourceDataLine = BasicPlayer.class$("javax.sound.sampled.SourceDataLine")) : class$javax$sound$sampled$SourceDataLine, audioFormat);
        SourceDataLine sourceDataLine = (SourceDataLine)AudioSystem.getLine(info);
        sourceDataLine.open(audioFormat, sourceDataLine.getBufferSize());
        return sourceDataLine;
    }

    public int fileLength(String string) {
        File file = new File(string);
        if (file.exists()) {
            return (int)file.length();
        }
        return -1;
    }

    public int countFrames(String string) {
        int n = this.fileLength(string);
        if (n != -1) {
            return n / this.currentFrameLength;
        }
        return -1;
    }

    public void seek(int n) {
        this.frameSeek = n;
    }

    public void unpause() {
        this.status = 0;
        Object object = this.pauseLock;
        synchronized (object) {
            this.pauseLock.notify();
        }
        if (this.line != null) {
            this.line.start();
        }
    }

    public void pause() {
        if (this.line != null) {
            this.line.stop();
        }
        if (this.status != 2) {
            this.status = 1;
        }
    }

    public void stop() {
        if (this.line != null) {
            this.line.flush();
            this.line.stop();
            this.line.close();
        }
        if (this.status == 1) {
            playthread.interrupt();
        }
        this.status = 2;
        try {
            if (playthread != null) {
                playthread.join(3000L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public void setUpControls() {
        if (this.line.isControlSupported(FloatControl.Type.MASTER_GAIN)) {
            this.Jvolume = (FloatControl)this.line.getControl(FloatControl.Type.MASTER_GAIN);
            this.setVolume(this.volumeLevel);
        }
        if (this.line.isControlSupported(FloatControl.Type.PAN)) {
            this.Jpan = (FloatControl)this.line.getControl(FloatControl.Type.PAN);
            this.setPan(this.panLevel);
        }
    }

    public void setPan(float f) {
        this.panLevel = f;
        if (this.status != 2) {
            this.Jpan.setValue(f);
        }
    }

    public void setVolume(float f) {
        this.volumeLevel = f;
        if (this.status != 2) {
            this.Jvolume.setValue(this.volumeLevel);
        }
    }

    public int getStatus() {
        return this.status;
    }

    protected InputStream openInput(String string) throws IOException {
        File file = new File(string);
        FileInputStream fileInputStream = new FileInputStream(file);
        BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream);
        return bufferedInputStream;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class PlayThread
    extends Thread {
        String playFile;

        public PlayThread(String string) {
            this.playFile = string;
        }

        public void run() {
            try {
                BasicPlayer.this.doplay(this.playFile);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

