/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.menu.FileMenu;
import com.limegroup.gnutella.gui.menu.HelpMenu;
import com.limegroup.gnutella.gui.menu.Menu;
import com.limegroup.gnutella.gui.menu.NavMenu;
import com.limegroup.gnutella.gui.menu.ToolsMenu;
import com.limegroup.gnutella.gui.menu.ViewMenu;
import com.limegroup.gnutella.util.CommonUtils;
import javax.swing.JMenu;
import javax.swing.JMenuBar;

public final class MenuMediator {
    private static final MenuMediator INSTANCE = new MenuMediator();
    private final JMenuBar MENU_BAR = new JMenuBar();
    private final FileMenu FILE_MENU = new FileMenu("FILE");
    private final NavMenu NAV_MENU = new NavMenu("NAV");
    private final ToolsMenu TOOLS_MENU = new ToolsMenu("TOOLS");
    private final HelpMenu HELP_MENU = new HelpMenu("HELP");
    private final ViewMenu VIEW_MENU = new ViewMenu("VIEW");

    public static final MenuMediator instance() {
        return INSTANCE;
    }

    private MenuMediator() {
        this.addMenu(this.FILE_MENU);
        if (!CommonUtils.isMacClassic()) {
            this.addMenu(this.VIEW_MENU);
        }
        this.addMenu(this.NAV_MENU);
        this.addMenu(this.TOOLS_MENU);
        this.addMenu(this.HELP_MENU);
    }

    public JMenuBar getMenuBar() {
        return this.MENU_BAR;
    }

    public void handleLibrarySelection() {
        this.FILE_MENU.handleLibrarySelection();
    }

    public void handleStandardSelection() {
        this.FILE_MENU.handleStandardSelection();
    }

    public void setConnected(boolean bl) {
        this.FILE_MENU.setConnected(bl);
    }

    private void addMenu(Menu menu) {
        JMenu jMenu = menu.getMenu();
        this.MENU_BAR.add(jMenu);
    }

    public void removeNavMonitorMenuItem() {
        this.NAV_MENU.removeMonitorMenuItem();
    }

    public void removeNavConnectionMenuItem() {
        this.NAV_MENU.removeConnectionMenuItem();
    }

    public void removeNavLibraryMenuItem() {
        this.NAV_MENU.removeLibraryMenuItem();
    }

    public void insertNavMonitorMenuItem() {
        this.NAV_MENU.insertMonitorMenuItem();
    }

    public void insertNavConnectionMenuItem() {
        this.NAV_MENU.insertConnectionMenuItem();
    }

    public void insertNavLibraryMenuItem() {
        this.NAV_MENU.insertLibraryMenuItem();
    }
}

