/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.menu;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.menu.AbstractMenu;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;

final class HelpMenu
extends AbstractMenu {
    private final HelpListener HELP_LISTENER = new HelpListener();
    private final FAQListener FAQ_LISTENER = new FAQListener();
    private final ForumListener FORUM_LISTENER = new ForumListener();
    private final FriendListener FRIEND_LISTENER = new FriendListener();
    private final ReviewListener REVIEW_LISTENER = new ReviewListener();
    private final AboutListener ABOUT_LISTENER = new AboutListener();

    HelpMenu(String string) {
        super(string);
        this.MENU.setMnemonic(72);
        this.addMenuItem("HELP_USING_LIMEWIRE", 85, this.HELP_LISTENER);
        this.addMenuItem("HELP_FAQ", 70, this.FAQ_LISTENER);
        this.addMenuItem("HELP_FORUM", 82, this.FORUM_LISTENER);
        this.addMenuItem("HELP_FRIEND", 78, this.FRIEND_LISTENER);
        this.addMenuItem("HELP_REVIEW", 86, this.REVIEW_LISTENER);
        this.addSeparator();
        this.addMenuItem("HELP_ABOUT", 65, this.ABOUT_LISTENER);
    }

    private class AboutListener
    implements ActionListener {
        private AboutListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            GUIMediator.instance();
            GUIMediator.showAboutWindow();
        }
    }

    private class ReviewListener
    implements ActionListener {
        private ReviewListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = CommonUtils.isWindows() ? "http://www.limewire.com/review/pc.htm" : (CommonUtils.isMacClassic() ? "http://www.limewire.com/review/mac_classic.htm" : (CommonUtils.isMacOSX() ? "http://www.limewire.com/review/mac_osx.htm" : (CommonUtils.isLinux() ? "http://www.limewire.com/review/linux.htm" : (CommonUtils.isSolaris() ? "http://www.limewire.com/review/linux.htm" : "http://www.limewire.com/review/pc.htm"))));
            try {
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                String string2 = "ERROR_LOCATING_BROWSER_GENERAL";
                GUIMediator.showError(string2);
            }
        }
    }

    private class FriendListener
    implements ActionListener {
        private FriendListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = "http://www.limewire.com/index.jsp/tell_friend";
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                String string = "ERROR_LOCATING_BROWSER_FRIEND";
                GUIMediator.showError(string);
            }
        }
    }

    private class ForumListener
    implements ActionListener {
        private ForumListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = "http://www.limewire.com/forum.htm";
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                String string = "ERROR_LOCATING_BROWSER_FORUM";
                GUIMediator.showError(string);
            }
        }
    }

    private class FAQListener
    implements ActionListener {
        private FAQListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = "http://www.limewire.com/support/faq.htm";
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                String string = "ERROR_LOCATING_BROWSER_FAQ";
                GUIMediator.showError(string);
            }
        }
    }

    private class HelpListener
    implements ActionListener {
        private HelpListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = "http://www.limewire.com/support.htm";
                GUIMediator.openURL(string);
            }
            catch (IOException iOException) {
                String string = "ERROR_LOCATING_BROWSER_SUPPORT";
                GUIMediator.showError(string);
            }
        }
    }
}

