/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import javax.swing.JLabel;
import javax.swing.Timer;

final class LinkHandler {
    private final CardLayout CARD_LAYOUT = new CardLayout();
    private final LabelURLPair[] PC_PAIRS = new LabelURLPair[]{new LabelURLPair("Burn CD...", "http://www.limewire.com/ads/burn/pc.htm"), new LabelURLPair("Auto-Organize Music...", "http://www.limewire.com/ads/moodlogic/pc.htm")};
    private final LabelURLPair[] MAC_PAIRS = new LabelURLPair[]{new LabelURLPair("Burn CD...", "http://www.limewire.com/ads/burn/mac.htm")};
    private LabelURLPair[] LABELS = new LabelURLPair[0];
    private int _curLabelIndex = 0;
    private LabelURLPair _currentLabelURLPair;
    private final Timer TIMER;
    private final JLabel LABEL = new JLabel();

    LinkHandler() {
        if (CommonUtils.isWindows()) {
            this.LABELS = this.PC_PAIRS;
        } else if (CommonUtils.isMacClassic() || CommonUtils.isMacOSX()) {
            this.LABELS = this.MAC_PAIRS;
        } else if (CommonUtils.isLinux()) {
            this.LABELS = this.MAC_PAIRS;
        }
        if (this.LABELS.length > 0) {
            this._currentLabelURLPair = this.LABELS[0];
            if (this._currentLabelURLPair != null) {
                this.LABEL.setText(this._currentLabelURLPair.getLabel());
            }
        }
        FontMetrics fontMetrics = ((Component)this.LABEL).getFontMetrics(this.LABEL.getFont());
        int n = fontMetrics.stringWidth("123456789/123456789/1");
        Dimension dimension = new Dimension(n, fontMetrics.getHeight());
        this.LABEL.setPreferredSize(dimension);
        this.LABEL.setMaximumSize(dimension);
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                LinkHandler.this.handleLinkClick();
            }
        };
        this.LABEL.addMouseListener(mouseAdapter);
        this.TIMER = new Timer(30000, new LabelTimerListener());
    }

    private void handleLinkClick() {
        try {
            GUIMediator.openURL(this._currentLabelURLPair.getURL());
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void startTimer() {
        if (CommonUtils.isWindows()) {
            this.TIMER.start();
        }
    }

    Component getComponent() {
        return this.LABEL;
    }

    private void handleLinkChange() {
        this._currentLabelURLPair = this.getNextLabelURLPair();
        this.LABEL.setText(this._currentLabelURLPair.getLabel());
    }

    private LabelURLPair getNextLabelURLPair() {
        if (this._curLabelIndex == this.LABELS.length - 1) {
            this._curLabelIndex = 0;
            return this.LABELS[this._curLabelIndex];
        }
        ++this._curLabelIndex;
        return this.LABELS[this._curLabelIndex];
    }

    private static final class LabelURLPair {
        private final String LABEL_STRING;
        private final String URL;

        private LabelURLPair(String string, String string2) {
            this.LABEL_STRING = string;
            this.URL = string2;
        }

        private String getLabel() {
            return "<html><a href=\"\">" + this.LABEL_STRING + "</a></html>";
        }

        private String getURL() {
            return this.URL;
        }
    }

    private class LabelTimerListener
    implements ActionListener {
        private LabelTimerListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LinkHandler.this.handleLinkChange();
        }
    }
}

