/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTreeCellEditor;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

final class LibraryTree {
    private final String INCOMPLETE_FILE_NAME = "Incomplete";
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final JTree TREE = new JTree();
    private final LibraryTreeNode ROOT_NODE = new LibraryTreeNode();
    private final DefaultTreeModel TREE_MODEL = new DefaultTreeModel(this.ROOT_NODE);
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private final JPopupMenu DIRECTORY_POPUP = new JPopupMenu();
    private boolean _isFirstDirectoryAdded = true;
    private AbstractFileHolder _currentTreeFileHolder;
    private LibraryTreeNode _currentTreeNode;
    private int _currentTreeRow;

    LibraryTree() {
        this.TREE.setModel(this.TREE_MODEL);
        this.TREE.setRootVisible(false);
        this.TREE.getSelectionModel().setSelectionMode(1);
        this.TREE.setEditable(true);
        this.TREE.setInvokesStopCellEditing(true);
        this.TREE.setShowsRootHandles(true);
        this.TREE.putClientProperty("JTree.lineStyle", "None");
        this.makePopupMenu();
        this.TREE.addTreeSelectionListener(new LibraryTreeSelectionListener());
        this.TREE.setCellEditor(new DefaultTreeCellEditor(this.TREE, (DefaultTreeCellRenderer)this.TREE.getCellRenderer(), new LibraryTreeCellEditor(this)));
        this.addIncompleteDirectory();
    }

    void addSharedDirectory(File file, File file2) {
        LibraryTreeNode libraryTreeNode = null;
        LibraryTreeNode libraryTreeNode2 = null;
        InternalNodeFileHolder internalNodeFileHolder = null;
        if (file2 == null) {
            if (!this.ROOT_NODE.isChild(file)) {
                internalNodeFileHolder = new InternalNodeFileHolder(file);
                libraryTreeNode = new LibraryTreeNode(internalNodeFileHolder);
                this.TREE_MODEL.insertNodeInto(libraryTreeNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 1);
                libraryTreeNode2 = this.ROOT_NODE;
            }
        } else {
            AbstractFileHolder abstractFileHolder = null;
            Enumeration<TreeNode> enumeration = this.ROOT_NODE.breadthFirstEnumeration();
            if (enumeration.hasMoreElements()) {
                while (enumeration.hasMoreElements()) {
                    libraryTreeNode = (LibraryTreeNode)enumeration.nextElement();
                    abstractFileHolder = libraryTreeNode.getFileHolder();
                    if (!abstractFileHolder.matchesFile(file2)) continue;
                    if (!libraryTreeNode.isChild(file)) {
                        internalNodeFileHolder = new InternalNodeFileHolder(file);
                        LibraryTreeNode libraryTreeNode3 = new LibraryTreeNode(internalNodeFileHolder);
                        this.TREE_MODEL.insertNodeInto(libraryTreeNode3, libraryTreeNode, libraryTreeNode.getChildCount());
                        libraryTreeNode2 = libraryTreeNode;
                    }
                    break;
                }
            } else {
                InternalNodeFileHolder internalNodeFileHolder2 = new InternalNodeFileHolder(file);
                libraryTreeNode = new LibraryTreeNode(internalNodeFileHolder2);
                this.TREE_MODEL.insertNodeInto(libraryTreeNode, this.ROOT_NODE, this.ROOT_NODE.getChildCount() - 1);
                libraryTreeNode2 = this.ROOT_NODE;
            }
        }
        if (this._isFirstDirectoryAdded) {
            this._isFirstDirectoryAdded = false;
            this._currentTreeFileHolder = internalNodeFileHolder;
        }
        this.TREE_MODEL.reload(libraryTreeNode2);
    }

    void addNewLibraryFolder() {
        if (this._currentTreeFileHolder == null) {
            return;
        }
        if (this._currentTreeNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            this.showIncompleteFolderMessage("add a new folder to");
            return;
        }
        File file = this._currentTreeFileHolder.getFile();
        File file2 = new File(file, "New Folder");
        int n = 2;
        boolean bl = false;
        while (!bl) {
            bl = file2.mkdir();
            if (bl) {
                LibraryTreeNode libraryTreeNode = new LibraryTreeNode(new InternalNodeFileHolder(file2));
                this.TREE_MODEL.insertNodeInto(libraryTreeNode, this._currentTreeNode, this._currentTreeNode.getChildCount());
                this.TREE.expandRow(this._currentTreeRow);
                this.TREE.setSelectionRow(this._currentTreeRow + this._currentTreeNode.getChildCount());
                this.LIBRARY_MEDIATOR.refresh();
            } else {
                file2 = new File(file, "New Folder (" + String.valueOf(n) + ")");
            }
            ++n;
        }
    }

    void renameLibraryFolder() {
        if (this._currentTreeFileHolder != null) {
            if (!this.incompleteDirectoryIsSelected()) {
                this.TREE.startEditingAtPath(this.TREE.getPathForRow(this._currentTreeRow));
            } else {
                this.showIncompleteFolderMessage("rename");
            }
        }
    }

    void addPlayListEntries() {
        if (this._currentTreeFileHolder == null) {
            return;
        }
        if (this._currentTreeNode == null) {
            return;
        }
        if (this.incompleteDirectoryIsSelected()) {
            return;
        }
        final File file = this._currentTreeFileHolder.getFile();
        new Thread(){

            public void run() {
                PlayListGUI playListGUI;
                String[] stringArray = new String[]{"mp3"};
                File[] fileArray = FileManager.getFilesRecursive(file, stringArray);
                PlayListGUI playListGUI2 = playListGUI = PlayListGUI.instance();
                synchronized (playListGUI2) {
                    int n = 0;
                    while (fileArray != null && n < fileArray.length) {
                        playListGUI.addFileToPlayList(fileArray[n]);
                        ++n;
                    }
                }
            }
        }.start();
    }

    File getFileForPoint(Point point) {
        TreePath treePath = this.TREE.getPathForLocation(point.x, point.y);
        if (treePath != null) {
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)treePath.getLastPathComponent();
            AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
            File file = abstractFileHolder.getFile();
            if (file.isDirectory()) {
                return file;
            }
            return null;
        }
        return null;
    }

    boolean droppingToIncompleteFolder(Point point) {
        TreePath treePath = this.TREE.getPathForLocation(point.x, point.y);
        if (treePath == null) {
            return false;
        }
        LibraryTreeNode libraryTreeNode = (LibraryTreeNode)treePath.getLastPathComponent();
        AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
        return this.isIncompleteDirectory(abstractFileHolder);
    }

    File getSelectedDirectory() {
        return this._currentTreeFileHolder.getFile();
    }

    File[] getSharedDirectories() {
        StringBuffer stringBuffer = new StringBuffer();
        String string = "";
        int n = this.ROOT_NODE.getChildCount();
        ArrayList<File> arrayList = new ArrayList<File>();
        int n2 = 0;
        while (n2 < n) {
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.ROOT_NODE.getChildAt(n2);
            AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
            if (!this.isIncompleteDirectory(abstractFileHolder)) {
                File file = abstractFileHolder.getFile();
                String string2 = "";
                if (file.isDirectory()) {
                    arrayList.add(file);
                }
            }
            ++n2;
        }
        return (File[])arrayList.toArray();
    }

    void setSelectionRow(int n) {
        this.TREE.setSelectionRow(n);
    }

    boolean parentIsSelected(File file) {
        if (this._currentTreeFileHolder != null) {
            return this._currentTreeFileHolder.matchesFile(file);
        }
        return false;
    }

    void clear() {
        this.ROOT_NODE.removeAllChildren();
        this._isFirstDirectoryAdded = true;
        this._currentTreeFileHolder = null;
        this._currentTreeNode = null;
        this._currentTreeRow = -1;
        this.addIncompleteDirectory();
    }

    Object handleNameChange(String string) {
        File file;
        boolean bl;
        File file2;
        String string2;
        if (this._currentTreeFileHolder != null && !string.equals(this._currentTreeFileHolder.toString()) && (string2 = (file2 = this._currentTreeFileHolder.getFile()).getParent()) != null && (bl = file2.renameTo(file = new File(string2, string)))) {
            InternalNodeFileHolder internalNodeFileHolder = new InternalNodeFileHolder(file);
            this._currentTreeNode.setUserObject(internalNodeFileHolder);
            this._currentTreeFileHolder = internalNodeFileHolder;
            this.TREE_MODEL.nodeChanged(this._currentTreeNode);
            if (!this._currentTreeNode.isLeaf()) {
                this._currentTreeNode.removeAllChildren();
            }
            this.handleDirectoryChange(this._currentTreeNode);
        }
        return this._currentTreeFileHolder;
    }

    void deleteLibraryFolder() {
        if (this._currentTreeFileHolder != null) {
            if (!this.incompleteDirectoryIsSelected()) {
                String string = "MESSAGE_CONFIRM_DIRECTORY_DELETE";
                int n = GUIMediator.showYesNoMessage(string);
                if (n != 101) {
                    return;
                }
                if (this._currentTreeNode != null) {
                    this.deleteLibraryFolderInternal(this._currentTreeNode);
                }
            } else {
                this.showIncompleteFolderMessage("delete");
            }
        }
    }

    boolean incompleteDirectoryIsSelected() {
        if (this._currentTreeFileHolder != null) {
            return this.isIncompleteDirectory(this._currentTreeFileHolder);
        }
        return false;
    }

    void setCursor(Cursor cursor) {
        this.TREE.setCursor(cursor);
    }

    Point getTreeLocation() {
        return this.TREE.getLocationOnScreen();
    }

    Dimension getTreeSize() {
        return this.TREE.getSize();
    }

    JTree getTree() {
        return this.TREE;
    }

    private boolean isIncompleteDirectory(AbstractFileHolder abstractFileHolder) {
        return abstractFileHolder.toString().equals("Incomplete");
    }

    private void addIncompleteDirectory() {
        try {
            File file = this.SETTINGS.getIncompleteDirectory();
            InternalNodeFileHolder internalNodeFileHolder = new InternalNodeFileHolder(file);
            LibraryTreeNode libraryTreeNode = new LibraryTreeNode(internalNodeFileHolder);
            this.TREE_MODEL.insertNodeInto(libraryTreeNode, this.ROOT_NODE, 0);
            this.TREE_MODEL.reload(this.ROOT_NODE);
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
    }

    private void showIncompleteFolderMessage(String string) {
        String string2 = "MESSAGE_INCOMPLETE_DIRECTORY_START";
        String string3 = "MESSAGE_INCOMPLETE_DIRECTORY_END";
        GUIMediator.showError(string2 + string + string3);
    }

    private void deleteLibraryFolderInternal(final LibraryTreeNode libraryTreeNode) {
        Thread thread = new Thread(){

            public void run() {
                AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
                File file = abstractFileHolder.getFile();
                if (file.isDirectory() && LibraryTree.this.deleteFolderRecursively(libraryTreeNode)) {
                    LibraryTree.this._currentTreeFileHolder = null;
                    LibraryTree.this._currentTreeNode = null;
                    LibraryTree.this._currentTreeRow = -1;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    private boolean deleteFolderRecursively(final LibraryTreeNode libraryTreeNode) {
        int n = libraryTreeNode.getChildCount();
        --n;
        while (n >= 0) {
            LibraryTreeNode libraryTreeNode2 = (LibraryTreeNode)libraryTreeNode.getChildAt(n);
            if (!this.deleteFolderRecursively(libraryTreeNode2)) {
                return false;
            }
            --n;
        }
        AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
        File file = abstractFileHolder.getFile();
        String string = "";
        String string2 = "";
        try {
            string2 = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            this.showFolderDeletionError(file.toString());
            return false;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n2 = stringArray.length;
            --n2;
            while (n2 >= 0) {
                File file2 = new File(string2, stringArray[n2]);
                if (!file2.delete()) {
                    this.showFileDeletionError(file2.toString());
                    return false;
                }
                FileManager fileManager = GUIMediator.instance().getRouter().getFileManager();
                fileManager.removeFileIfShared(file2);
                --n2;
            }
        }
        if (!file.delete()) {
            this.showFolderDeletionError(file.toString());
            return false;
        }
        this.handleDirectoryChange(libraryTreeNode);
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                LibraryTree.this.TREE_MODEL.removeNodeFromParent(libraryTreeNode);
            }
        });
        return true;
    }

    private void showFileDeletionError(String string) {
        String string2 = "'" + string + "'.";
        GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", string2, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
    }

    private void showFolderDeletionError(String string) {
        String string2 = "'" + string + "'.";
        GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_DIRECTORY_START", string2, "MESSAGE_UNABLE_TO_DELETE_DIRECTORY_END");
    }

    private void handleDirectoryChange(LibraryTreeNode libraryTreeNode) {
        if (libraryTreeNode.getLibraryTreeNodeParent().isRoot()) {
            this.LIBRARY_MEDIATOR.handleRootSharedDirectoryChange();
        } else {
            this.LIBRARY_MEDIATOR.refresh();
        }
    }

    private void makePopupMenu() {
        JMenuItem jMenuItem = new JMenuItem("New Folder");
        JMenuItem jMenuItem2 = new JMenuItem("Delete");
        JMenuItem jMenuItem3 = new JMenuItem("Rename");
        JMenuItem jMenuItem4 = new JMenuItem("To PlayList");
        jMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTree.this.addNewLibraryFolder();
            }
        });
        jMenuItem2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTree.this.deleteLibraryFolder();
            }
        });
        jMenuItem3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTree.this.renameLibraryFolder();
            }
        });
        jMenuItem4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                LibraryTree.this.addPlayListEntries();
            }
        });
        this.DIRECTORY_POPUP.add(jMenuItem);
        this.DIRECTORY_POPUP.add(jMenuItem2);
        this.DIRECTORY_POPUP.add(jMenuItem3);
        if (!CommonUtils.isMacClassic()) {
            this.DIRECTORY_POPUP.add(jMenuItem4);
        }
        MouseAdapter mouseAdapter = new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                int n = LibraryTree.this.TREE.getRowForLocation(mouseEvent.getX(), mouseEvent.getY());
                if (n != -1) {
                    LibraryTree.this.TREE.setSelectionRow(n);
                    if (SwingUtilities.isRightMouseButton(mouseEvent) && !LibraryTree.this.incompleteDirectoryIsSelected()) {
                        LibraryTree.this.DIRECTORY_POPUP.show(LibraryTree.this.TREE, mouseEvent.getX(), mouseEvent.getY());
                    }
                }
            }
        };
        this.TREE.addMouseListener(mouseAdapter);
    }

    private class RootNodeFileHolder
    extends AbstractFileHolder {
        private RootNodeFileHolder() {
        }

        protected File getFile() {
            return null;
        }

        protected boolean matchesFile(File file) {
            return false;
        }

        protected boolean matchesPath(File file) {
            return false;
        }

        public String toString() {
            return "";
        }
    }

    private class InternalNodeFileHolder
    extends AbstractFileHolder {
        private File _file;
        private String _name;
        private String _path;

        protected InternalNodeFileHolder(File file) {
            try {
                this._file = file;
                this._path = file.getCanonicalPath();
                this._name = file.getName();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        protected File getFile() {
            return this._file;
        }

        protected boolean matchesFile(File file) {
            return this._file.equals(file);
        }

        protected boolean matchesPath(File file) {
            String string = "";
            try {
                string = file.getCanonicalPath();
                if (string.equals(this._path)) {
                    return true;
                }
            }
            catch (IOException iOException) {
                return false;
            }
            return false;
        }

        public String toString() {
            return this._name;
        }
    }

    private abstract class AbstractFileHolder {
        private AbstractFileHolder() {
        }

        protected abstract File getFile();

        protected abstract boolean matchesFile(File var1);

        protected abstract boolean matchesPath(File var1);

        public abstract String toString();
    }

    private class LibraryTreeNode
    extends DefaultMutableTreeNode {
        private AbstractFileHolder _holder;

        private LibraryTreeNode() {
            this._holder = new RootNodeFileHolder();
        }

        private LibraryTreeNode(AbstractFileHolder abstractFileHolder) {
            super(abstractFileHolder);
            this._holder = abstractFileHolder;
        }

        private AbstractFileHolder getFileHolder() {
            return this._holder;
        }

        private boolean isChild(File file) {
            int n = 0;
            int n2 = this.getChildCount();
            while (n < n2) {
                LibraryTreeNode libraryTreeNode = (LibraryTreeNode)this.getChildAt(n);
                AbstractFileHolder abstractFileHolder = libraryTreeNode.getFileHolder();
                if (abstractFileHolder.matchesPath(file)) {
                    return true;
                }
                ++n;
            }
            return false;
        }

        private void setUserObject(AbstractFileHolder abstractFileHolder) {
            super.setUserObject(abstractFileHolder);
            this._holder = abstractFileHolder;
        }

        private LibraryTreeNode getLibraryTreeNodeParent() {
            return (LibraryTreeNode)super.getParent();
        }
    }

    private class LibraryTreeSelectionListener
    implements TreeSelectionListener {
        private LibraryTreeSelectionListener() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            LibraryTreeNode libraryTreeNode = (LibraryTreeNode)LibraryTree.this.TREE.getLastSelectedPathComponent();
            if (libraryTreeNode != null) {
                LibraryTree.this._currentTreeFileHolder = libraryTreeNode.getFileHolder();
                LibraryTree.this._currentTreeNode = libraryTreeNode;
                LibraryTree.this._currentTreeRow = LibraryTree.this.TREE.getLeadSelectionRow();
                if (!LibraryTree.this.incompleteDirectoryIsSelected()) {
                    LibraryTree.this.LIBRARY_MEDIATOR.updateTableFiles(LibraryTree.this._currentTreeFileHolder.getFile());
                } else {
                    LibraryTree.this.LIBRARY_MEDIATOR.showIncompleteFiles();
                }
            }
        }
    }
}

