/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.library.DeleteListener;
import com.limegroup.gnutella.gui.library.DragSourceListener;
import com.limegroup.gnutella.gui.library.LaunchListener;
import com.limegroup.gnutella.gui.library.LibraryList;
import com.limegroup.gnutella.gui.library.LibraryMediator;
import com.limegroup.gnutella.gui.library.LibraryTableCellEditor;
import com.limegroup.gnutella.gui.library.LibraryTableModel;
import com.limegroup.gnutella.gui.library.RefreshListener;
import com.limegroup.gnutella.util.CommonUtils;
import com.limegroup.gnutella.xml.LimeXMLDocument;
import com.limegroup.gnutella.xml.LimeXMLUtils;
import com.limegroup.gnutella.xml.MetaFileManager;
import com.limegroup.gnutella.xml.gui.MetaEditorFrame;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.util.StringTokenizer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumnModel;

final class LibraryTable {
    private final LibraryMediator LIBRARY_MEDIATOR = LibraryMediator.instance();
    private final JTable TABLE = new JTable();
    private final LibraryList LIST = new LibraryList();
    private final AbstractTableModel TABLE_MODEL = new LibraryTableModel(this.TABLE, this.LIST);
    private final JPopupMenu POPUP_MENU = new JPopupMenu();
    private boolean _shiftPressed;
    private boolean _multiSelection;
    private int _indexCandidate;
    static /* synthetic */ Class class$java$lang$String;

    LibraryTable() {
        this.TABLE.setModel(this.TABLE_MODEL);
        this.TABLE.getTableHeader().addMouseListener(new ColumnSorter());
        this.TABLE.getColumnModel().getColumn(0).setPreferredWidth(150);
        this.TABLE.getColumnModel().getColumn(1).setPreferredWidth(40);
        this.TABLE.getColumnModel().getColumn(2).setPreferredWidth(30);
        this.TABLE.getColumnModel().getColumn(3).setPreferredWidth(120);
        this.TABLE.setColumnSelectionAllowed(false);
        this.TABLE.setShowGrid(false);
        this.TABLE.addKeyListener(new LibraryKeyListener());
        LibraryListSelectionModel libraryListSelectionModel = new LibraryListSelectionModel();
        libraryListSelectionModel.setSelectionMode(1);
        this.TABLE.setSelectionModel(libraryListSelectionModel);
        this.TABLE.setDefaultEditor(class$java$lang$String == null ? (class$java$lang$String = LibraryTable.class$("java.lang.String")) : class$java$lang$String, new LibraryTableCellEditor(this));
        this.makePopupMenu();
    }

    void addMouseListeners(DragSourceListener dragSourceListener) {
        this.TABLE.addMouseListener(dragSourceListener);
        this.TABLE.addMouseMotionListener(dragSourceListener);
    }

    void addSharedFile(File file) {
        if (this.TABLE.isEditing()) {
            TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
            tableCellEditor.cancelCellEditing();
        }
        this.LIST.add(file);
        int n = this.LIST.size() - 1;
        this.TABLE_MODEL.fireTableRowsInserted(n, n);
    }

    private void makePopupMenu() {
        String string = GUIMediator.getStringResource("LIBRARY_LAUNCH_BUTTON_LABEL");
        String string2 = GUIMediator.getStringResource("LIBRARY_DELETE_BUTTON_LABEL");
        String string3 = GUIMediator.getStringResource("LIBRARY_REFRESH_BUTTON_LABEL");
        String string4 = GUIMediator.getStringResource("LIBRARY_ANNOTATE_BUTTON_LABEL");
        String string5 = GUIMediator.getStringResource("LIBRARY_PLAYLIST_BUTTON_LABEL");
        String string6 = GUIMediator.getStringResource("SEARCH_BUY_CD_LABEL");
        JMenuItem jMenuItem = new JMenuItem(string);
        JMenuItem jMenuItem2 = new JMenuItem(string2);
        JMenuItem jMenuItem3 = new JMenuItem(string3);
        JMenuItem jMenuItem4 = new JMenuItem(string4);
        JMenuItem jMenuItem5 = new JMenuItem(string5);
        JMenuItem jMenuItem6 = new JMenuItem(string6);
        jMenuItem.addActionListener(new LaunchListener());
        jMenuItem2.addActionListener(new DeleteListener());
        jMenuItem3.addActionListener(new RefreshListener());
        jMenuItem4.addActionListener(new AnnotateListener());
        jMenuItem5.addActionListener(new AddPLFileListener());
        jMenuItem6.addActionListener(new BuyListener());
        this.POPUP_MENU.add(jMenuItem);
        this.POPUP_MENU.add(jMenuItem2);
        this.POPUP_MENU.add(jMenuItem3);
        this.POPUP_MENU.add(jMenuItem4);
        if (!CommonUtils.isMacClassic()) {
            this.POPUP_MENU.add(jMenuItem5);
        }
        this.POPUP_MENU.add(jMenuItem6);
    }

    void showPopup(MouseEvent mouseEvent) {
        this.POPUP_MENU.show(this.TABLE, mouseEvent.getX(), mouseEvent.getY());
    }

    File getFile(int n) {
        return this.LIST.getFile(n);
    }

    void setMultiSelection(boolean bl) {
        this._multiSelection = bl;
    }

    boolean getMultiSelection() {
        return this._multiSelection;
    }

    int getIndexCandidate() {
        return this._indexCandidate;
    }

    JTable getTable() {
        return this.TABLE;
    }

    ListSelectionModel getSelectionModel() {
        return this.TABLE.getSelectionModel();
    }

    void clear() {
        this.TABLE.getSelectionModel().clearSelection();
        this.LIST.clear();
        this.TABLE_MODEL.fireTableRowsDeleted(0, this.LIST.size());
    }

    void handleRefresh() {
        this.LIST.handleRefresh();
        this.clear();
    }

    void editMeta() {
        int[] nArray = this.TABLE.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[n - 1];
        File file = this.LIST.getFile(n2);
        String string = "";
        try {
            string = file.getCanonicalPath();
        }
        catch (IOException iOException) {
            return;
        }
        Frame frame = GUIMediator.getAppFrame();
        MetaEditorFrame metaEditorFrame = new MetaEditorFrame(string, frame);
        metaEditorFrame.show();
    }

    void buyItem() {
        Object object;
        MetaFileManager metaFileManager = (MetaFileManager)GUIMediator.instance().getRouter().getFileManager();
        int[] nArray = this.TABLE.getSelectedRows();
        int n = nArray.length;
        if (n == 0) {
            return;
        }
        int n2 = nArray[n - 1];
        File file = this.LIST.getFile(n2);
        String string = this.LIST.getName(n2);
        String string2 = "http://www.limewire.com/schemas/audio.xsd";
        LimeXMLDocument limeXMLDocument = metaFileManager.getDocument(string2, file);
        String string3 = "";
        if (limeXMLDocument != null) {
            Object object2;
            object = limeXMLDocument.getValue("audios__audio__artist__");
            if (object != null) {
                object2 = new StringTokenizer((String)object);
                while (((StringTokenizer)object2).hasMoreTokens()) {
                    string3 = string3 + "%20" + ((StringTokenizer)object2).nextToken();
                }
            }
            if ((object2 = limeXMLDocument.getValue("audios__audio__album__")) != null) {
                string3 = string3 + "+";
                StringTokenizer stringTokenizer = new StringTokenizer((String)object2);
                while (stringTokenizer.hasMoreTokens()) {
                    string3 = string3 + "%20" + stringTokenizer.nextToken();
                }
            }
        }
        if (limeXMLDocument == null || string3.equals("")) {
            object = new StringTokenizer(string, "-_*~ ");
            while (((StringTokenizer)object).hasMoreTokens()) {
                string3 = string3 + "%20" + ((StringTokenizer)object).nextToken();
            }
        }
        string3 = string3 + "&mode=music";
        object = "http://www.limewire.com/buystuff?tag=wwwlimewireco-20&keyword=" + string3;
        try {
            GUIMediator.instance();
            GUIMediator.openURL((String)object);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    void deleteRows() {
        int[] nArray = this.TABLE.getSelectedRows();
        if (nArray.length > 0) {
            String string = "MESSAGE_CONFIRM_FILE_DELETE";
            int n = GUIMediator.showYesNoMessage(string);
            if (n != 101) {
                return;
            }
            if (this.TABLE.isEditing()) {
                TableCellEditor tableCellEditor = this.TABLE.getCellEditor();
                tableCellEditor.cancelCellEditing();
            }
            int n2 = nArray.length;
            --n2;
            while (n2 >= 0) {
                File file = this.LIST.getFile(nArray[n2]);
                if (file.delete()) {
                    this.LIST.remove(nArray[n2]);
                    this.TABLE_MODEL.fireTableRowsDeleted(nArray[n2], nArray[n2]);
                    GUIMediator.instance().getRouter().getFileManager().removeFileIfShared(file);
                } else {
                    String string2 = "'" + file.getName() + "'.";
                    GUIMediator.showError("MESSAGE_UNABLE_TO_DELETE_FILE_START", string2, "MESSAGE_UNABLE_TO_DELETE_FILE_END");
                }
                --n2;
            }
            this.TABLE.getSelectionModel().clearSelection();
        }
    }

    void launch() {
        int[] nArray = this.TABLE.getSelectedRows();
        boolean bl = false;
        int n = 0;
        int n2 = nArray.length;
        while (n < n2) {
            try {
                File file = this.LIST.getFile(nArray[n]);
                if (SettingsManager.instance().getPlayerEnabled() && LimeXMLUtils.isMP3File(file)) {
                    if (!bl) {
                        this.LIBRARY_MEDIATOR.launchSong(file);
                        bl = true;
                    }
                } else {
                    GUIMediator.launchFile(file);
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
            ++n;
        }
    }

    String handleNameChange(String string) {
        int n = this.TABLE.getEditingRow();
        File file = this.LIST.getFile(n);
        String string2 = file.getParent();
        String string3 = string;
        string = string + "." + this.LIST.getType(n);
        File file2 = new File(string2, string);
        if (!this.LIST.getName(n).equals(string)) {
            boolean bl = file.renameTo(file2);
            if (bl) {
                GUIMediator.instance().getRouter().getFileManager().renameFileIfShared(file, file2);
                this.LIST.handleFileChangeInternal(n, file2);
                return string3;
            }
            String string4 = "'" + this.LIST.getName(n) + "'.";
            GUIMediator.showError("MESSAGE_UNABLE_TO_RENAME_FILE_START", string4, "MESSAGE_UNABLE_TO_RENAME_FILE_END");
            return this.LIST.getName(n);
        }
        return string3;
    }

    boolean canDragAndDrop() {
        int[] nArray = this.TABLE.getSelectedRows();
        return nArray.length > 0 && !this.TABLE.isEditing();
    }

    void setCursor(Cursor cursor) {
        this.TABLE.setCursor(cursor);
    }

    Point getTableLocation() {
        return this.TABLE.getLocationOnScreen();
    }

    Dimension getTableSize() {
        return this.TABLE.getSize();
    }

    int[] getSelectedRows() {
        return this.TABLE.getSelectedRows();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    private class LibraryListSelectionModel
    extends DefaultListSelectionModel {
        private LibraryListSelectionModel() {
        }

        public void setSelectionInterval(int n, int n2) {
            LibraryTable.this._indexCandidate = -1;
            if (LibraryTable.this._multiSelection) {
                LibraryTable.this._indexCandidate = n;
            }
            if (!LibraryTable.this._multiSelection) {
                super.setSelectionInterval(n, n2);
            } else if (this.getMinSelectionIndex() > n || this.getMaxSelectionIndex() < n2) {
                super.setSelectionInterval(n, n2);
            } else {
                LibraryTable.this._indexCandidate = n;
            }
        }

        public void setLeadSelectionIndex(int n) {
            if (LibraryTable.this._shiftPressed) {
                super.setLeadSelectionIndex(n);
            }
        }
    }

    private class AddPLFileListener
    implements ActionListener {
        private AddPLFileListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = LibraryTable.this.TABLE.getSelectedRows();
            int n = 0;
            while (n < nArray.length) {
                int n2 = nArray[n];
                File file = LibraryTable.this.LIST.getFile(n2);
                LibraryTable.this.LIBRARY_MEDIATOR.addFileToPlayList(file);
                ++n;
            }
        }
    }

    private class BuyListener
    implements ActionListener {
        private BuyListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTable.this.buyItem();
        }
    }

    private class AnnotateListener
    implements ActionListener {
        private AnnotateListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            LibraryTable.this.editMeta();
        }
    }

    private class LibraryKeyListener
    implements KeyListener {
        private LibraryKeyListener() {
        }

        public void keyTyped(KeyEvent keyEvent) {
            if (keyEvent.getKeyChar() != '\b') {
                return;
            }
            LibraryTable.this.deleteRows();
        }

        public void keyPressed(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16) {
                LibraryTable.this._shiftPressed = true;
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            if (keyEvent.getKeyCode() == 16) {
                LibraryTable.this._shiftPressed = false;
            }
        }
    }

    private class ColumnSorter
    extends MouseAdapter {
        private ColumnSorter() {
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            TableColumnModel tableColumnModel = LibraryTable.this.TABLE.getColumnModel();
            int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
            int n2 = LibraryTable.this.TABLE.convertColumnIndexToModel(n);
            if (mouseEvent.getClickCount() == 1 && n2 != -1) {
                Class<?> clazz = LibraryTable.this.TABLE_MODEL.getColumnClass(n2);
                LibraryTable.this.LIST.sort(n2, clazz);
                LibraryTable.this.TABLE_MODEL.fireTableDataChanged();
            }
        }
    }
}

