/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.FileManager;
import com.limegroup.gnutella.RouterService;
import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.PaddedPanel;
import com.limegroup.gnutella.gui.library.LibraryConstructor;
import com.limegroup.gnutella.gui.library.LibraryTable;
import com.limegroup.gnutella.gui.library.LibraryTree;
import com.limegroup.gnutella.gui.mp3.PlayListGUI;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JFileChooser;
import javax.swing.ListSelectionModel;

public final class LibraryMediator
extends PaddedPanel {
    private static final LibraryMediator INSTANCE = new LibraryMediator();
    private final SettingsManager SETTINGS = SettingsManager.instance();
    private static final LibraryTree LIBRARY_TREE = new LibraryTree();
    private static final LibraryTable LIBRARY_TABLE = new LibraryTable();
    private static final LibraryConstructor LIBRARY_CONSTRUCTOR = new LibraryConstructor(LIBRARY_TABLE, LIBRARY_TREE);
    private final JFileChooser FILE_CHOOSER = new JFileChooser();
    private final PlayListGUI PLAY_LIST = PlayListGUI.instance();

    public static LibraryMediator instance() {
        return INSTANCE;
    }

    private LibraryMediator() {
        this.FILE_CHOOSER.setFileSelectionMode(1);
        this.FILE_CHOOSER.setDialogTitle("Select Directory");
    }

    public Component getComponent() {
        return LIBRARY_CONSTRUCTOR.getComponent();
    }

    public void launch() {
        LIBRARY_TABLE.launch();
    }

    public void deleteLibraryFile() {
        LIBRARY_TABLE.deleteRows();
    }

    public void clearLibrary() {
        LIBRARY_TREE.clear();
        LIBRARY_TABLE.clear();
    }

    public void refresh() {
        LIBRARY_TABLE.handleRefresh();
        if (LIBRARY_TREE.incompleteDirectoryIsSelected()) {
            this.showIncompleteFiles();
        } else {
            RouterService routerService = GUIMediator.instance().getRouter();
            FileManager fileManager = routerService.getFileManager();
            fileManager.loadSettings(false);
        }
    }

    public void addSharedLibraryFolder() {
        String string = "Select";
        int n = this.FILE_CHOOSER.showDialog(this, string);
        if (n == 0) {
            File file = this.FILE_CHOOSER.getSelectedFile();
            try {
                this.SETTINGS.addDirectory(file);
                GUIMediator.instance().getRouter().getFileManager().loadSettings(false);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public void handleRootSharedDirectoryChange() {
        File[] fileArray = LIBRARY_TREE.getSharedDirectories();
        this.SETTINGS.setDirectories(fileArray);
        GUIMediator.instance().getRouter().getFileManager().loadSettings(true);
    }

    public void addSharedDirectory(File file, File file2) {
        LIBRARY_TREE.addSharedDirectory(file, file2);
    }

    public void addSharedFile(File file, File file2) {
        if (LIBRARY_TREE.parentIsSelected(file2)) {
            LIBRARY_TABLE.addSharedFile(file);
        }
    }

    public void addNewLibraryFolder() {
        LIBRARY_TREE.addNewLibraryFolder();
    }

    public void deleteLibraryFolder() {
        LIBRARY_TREE.deleteLibraryFolder();
    }

    public void renameLibraryFolder() {
        LIBRARY_TREE.renameLibraryFolder();
    }

    void addFileToPlayList(File file) {
        this.PLAY_LIST.addFileToPlayList(file);
    }

    void launchSong(File file) {
        this.PLAY_LIST.launchSong(file);
    }

    void updateTableFiles(File file) {
        File[] fileArray = GUIMediator.instance().getRouter().getSharedFiles(file);
        if (fileArray != null) {
            LIBRARY_TABLE.clear();
            int n = 0;
            while (n < fileArray.length) {
                LIBRARY_TABLE.addSharedFile(fileArray[n]);
                ++n;
            }
        } else {
            LIBRARY_TABLE.clear();
        }
    }

    void showIncompleteFiles() {
        LIBRARY_TABLE.clear();
        File file = null;
        try {
            file = this.SETTINGS.getIncompleteDirectory();
        }
        catch (FileNotFoundException fileNotFoundException) {
            return;
        }
        String[] stringArray = file.list();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                File file2;
                if (!stringArray[n].equals("downloads.dat") && (file2 = new File(file, stringArray[n])).isFile()) {
                    LIBRARY_TABLE.addSharedFile(file2);
                }
                ++n;
            }
        }
    }

    boolean canDragAndDrop() {
        return LIBRARY_TABLE.canDragAndDrop();
    }

    void setMultiSelection(boolean bl) {
        LIBRARY_TABLE.setMultiSelection(bl);
    }

    boolean getTableMultiSelection() {
        return LIBRARY_TABLE.getMultiSelection();
    }

    void handleDropToTreePoint(Point point) {
        File file = LIBRARY_TREE.getFileForPoint(point);
        boolean bl = LIBRARY_TREE.droppingToIncompleteFolder(point);
        boolean bl2 = LIBRARY_TREE.incompleteDirectoryIsSelected();
        if (file != null) {
            String string = "";
            try {
                string = file.getCanonicalPath();
            }
            catch (IOException iOException) {
                return;
            }
            int[] nArray = LIBRARY_TABLE.getSelectedRows();
            int n = nArray.length;
            --n;
            while (n >= 0) {
                File file2;
                File file3 = LIBRARY_TABLE.getFile(nArray[n]);
                boolean bl3 = file3.renameTo(file2 = new File(string, file3.getName()));
                if (bl3) {
                    if (bl) {
                        this.handleDropToIncomplete(file3);
                    } else if (bl2) {
                        this.handleDragFromIncomplete(file2);
                    } else {
                        this.handleStandardDragAndDrop(file3, file2);
                    }
                }
                --n;
            }
        }
    }

    void setCursors(Cursor cursor) {
        LIBRARY_TREE.setCursor(cursor);
        LIBRARY_TABLE.setCursor(cursor);
    }

    Point getTableLocation() {
        return LIBRARY_TABLE.getTableLocation();
    }

    Point getTreeLocation() {
        return LIBRARY_TREE.getTreeLocation();
    }

    Dimension getTableSize() {
        return LIBRARY_TABLE.getTableSize();
    }

    Dimension getTreeSize() {
        return LIBRARY_TREE.getTreeSize();
    }

    void showTablePopupMenu(MouseEvent mouseEvent) {
        LIBRARY_TABLE.showPopup(mouseEvent);
    }

    int getTableIndexCandidate() {
        return LIBRARY_TABLE.getIndexCandidate();
    }

    ListSelectionModel getTableSelectionModel() {
        return LIBRARY_TABLE.getSelectionModel();
    }

    private void handleDropToIncomplete(File file) {
        GUIMediator.instance().getRouter().getFileManager().removeFileIfShared(file);
        this.updateTableFiles(LIBRARY_TREE.getSelectedDirectory());
    }

    private void handleDragFromIncomplete(File file) {
        GUIMediator.instance().getRouter().getFileManager().addFileIfShared(file);
        this.showIncompleteFiles();
    }

    private void handleStandardDragAndDrop(File file, File file2) {
        GUIMediator.instance().getRouter().getFileManager().renameFileIfShared(file, file2);
        this.updateTableFiles(LIBRARY_TREE.getSelectedDirectory());
    }

    int[] getSelectedRows() {
        return LIBRARY_TABLE.getSelectedRows();
    }

    void deleteTableRows() {
        LIBRARY_TABLE.deleteRows();
    }

    void launchTableFiles() {
        LIBRARY_TABLE.launch();
    }

    File getTableFile(int n) {
        return LIBRARY_TABLE.getFile(n);
    }

    void editMeta() {
        LIBRARY_TABLE.editMeta();
    }
}

