/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.library;

import com.limegroup.gnutella.gui.library.LibraryMediator;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseEvent;
import javax.swing.ListSelectionModel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;

public class DragSourceListener
implements MouseInputListener {
    private final LibraryMediator MEDIATOR = LibraryMediator.instance();
    private int _lowerRow;
    private int _upperRow;
    private boolean _potentialDrop;
    private boolean _dragging;
    private boolean _outsideSelection = false;

    DragSourceListener() {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        ListSelectionModel listSelectionModel = this.MEDIATOR.getTableSelectionModel();
        this._outsideSelection = listSelectionModel.getMinSelectionIndex() < this._lowerRow || listSelectionModel.getMaxSelectionIndex() > this._upperRow;
        this._lowerRow = listSelectionModel.getMinSelectionIndex();
        this._upperRow = listSelectionModel.getMaxSelectionIndex();
        if (this._lowerRow != this._upperRow) {
            this.MEDIATOR.setMultiSelection(true);
        } else {
            this.MEDIATOR.setMultiSelection(false);
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        int n;
        ListSelectionModel listSelectionModel = this.MEDIATOR.getTableSelectionModel();
        if (this.MEDIATOR.getTableMultiSelection() && !this._dragging && !this._outsideSelection && !SwingUtilities.isRightMouseButton(mouseEvent) && (n = this.MEDIATOR.getTableIndexCandidate()) != -1) {
            this.MEDIATOR.setMultiSelection(false);
            listSelectionModel.setSelectionInterval(n, n);
        }
        if (this._dragging) {
            this._dragging = false;
            this.MEDIATOR.setCursors(Cursor.getPredefinedCursor(0));
            if (this._potentialDrop) {
                Point point = this.MEDIATOR.getTableLocation();
                Point point2 = this.MEDIATOR.getTreeLocation();
                Dimension dimension = this.MEDIATOR.getTableSize();
                Dimension dimension2 = this.MEDIATOR.getTreeSize();
                Point point3 = mouseEvent.getPoint();
                Point point4 = new Point(point.x + point3.x, point.y + point3.y);
                int n2 = point2.x + dimension2.width;
                int n3 = point2.y + dimension2.height;
                if (point4.x > point2.x && point4.x < n2 && point4.y > point2.y && point4.y < n3) {
                    Point point5 = new Point(point4.x - point2.x, point4.y - point2.y);
                    this.MEDIATOR.handleDropToTreePoint(point5);
                }
            }
        }
        this._potentialDrop = false;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        if (SwingUtilities.isRightMouseButton(mouseEvent)) {
            this.MEDIATOR.showTablePopupMenu(mouseEvent);
        } else if (mouseEvent.getClickCount() == 2) {
            this.MEDIATOR.launch();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this._potentialDrop = false;
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this._potentialDrop = true;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.MEDIATOR.canDragAndDrop()) {
            this.MEDIATOR.setCursors(Cursor.getPredefinedCursor(13));
            this._dragging = true;
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }
}

