/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.FileScan;
import com.limegroup.gnutella.gui.init.FinishWindow;
import com.limegroup.gnutella.gui.init.SaveWindow;
import com.limegroup.gnutella.gui.init.ScanConfirmWindow;
import com.limegroup.gnutella.gui.init.ScanWindow;
import com.limegroup.gnutella.gui.init.SetupButtons;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.limegroup.gnutella.gui.init.SetupWindowHolder;
import com.limegroup.gnutella.gui.init.SpeedWindow;
import com.limegroup.gnutella.gui.init.WaitWindow;
import com.limegroup.gnutella.gui.init.WelcomeWindow;
import com.limegroup.gnutella.util.CommonUtils;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JDialog;
import javax.swing.JPanel;

public class SetupManager {
    private JDialog _dialog = new JDialog();
    private SetupButtons _setupButtons;
    private SetupWindowHolder _setupWindowHolder;
    private SetupWindow _currentWindow;
    private String[] _scannedPaths;
    private boolean _scanned = false;

    public SetupManager() {
        this._dialog.setModal(true);
        if (!CommonUtils.isUnix()) {
            this._dialog.setResizable(false);
        }
        this._dialog.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                SetupManager.this.cancelSetup();
            }
        });
        Container container = this._dialog.getContentPane();
        BoxLayout boxLayout = new BoxLayout(container, 1);
        container.setLayout(boxLayout);
        JPanel jPanel = new JPanel();
        BoxLayout boxLayout2 = new BoxLayout(jPanel, 1);
        jPanel.setLayout(boxLayout2);
        Dimension dimension = new Dimension(500, 300);
        Dimension dimension2 = Toolkit.getDefaultToolkit().getScreenSize();
        ((Component)this._dialog).setLocation((dimension2.width - dimension.width) / 2, (dimension2.height - dimension.height) / 2);
        WelcomeWindow welcomeWindow = new WelcomeWindow(this);
        SaveWindow saveWindow = new SaveWindow(this);
        SpeedWindow speedWindow = new SpeedWindow(this);
        ScanWindow scanWindow = new ScanWindow(this);
        WaitWindow waitWindow = new WaitWindow(this);
        ScanConfirmWindow scanConfirmWindow = new ScanConfirmWindow(this);
        FinishWindow finishWindow = new FinishWindow(this);
        welcomeWindow.setNext(saveWindow);
        saveWindow.setNext(speedWindow);
        speedWindow.setNext(scanWindow);
        scanWindow.setYesWindow(waitWindow);
        scanWindow.setNoWindow(finishWindow);
        waitWindow.setNext(scanConfirmWindow);
        scanConfirmWindow.setNext(finishWindow);
        finishWindow.setNext(finishWindow);
        welcomeWindow.setPrevious(welcomeWindow);
        saveWindow.setPrevious(welcomeWindow);
        speedWindow.setPrevious(saveWindow);
        scanWindow.setPrevious(speedWindow);
        waitWindow.setPrevious(scanWindow);
        scanConfirmWindow.setPrevious(scanWindow);
        finishWindow.setPrevious(scanConfirmWindow);
        this._setupWindowHolder = new SetupWindowHolder();
        this._setupWindowHolder.add(welcomeWindow);
        this._setupWindowHolder.add(saveWindow);
        this._setupWindowHolder.add(speedWindow);
        this._setupWindowHolder.add(scanWindow);
        this._setupWindowHolder.add(waitWindow);
        this._setupWindowHolder.add(scanConfirmWindow);
        this._setupWindowHolder.add(finishWindow);
        this.show(welcomeWindow);
        this._setupButtons = new SetupButtons(this);
        jPanel.add(this._setupWindowHolder);
        jPanel.add(Box.createVerticalStrut(17));
        jPanel.add(this._setupButtons);
        container.add(jPanel);
        this._dialog.pack();
        ((Component)this._dialog).setVisible(true);
    }

    public void next() {
        SetupWindow setupWindow = this._currentWindow.getNext();
        try {
            this._currentWindow.applySettings();
            setupWindow.handleWindowOpeningEvent();
            this.show(setupWindow);
        }
        catch (ApplySettingsException applySettingsException) {
            GUIMediator.showError(applySettingsException.getMessage());
        }
    }

    public void previous() {
        SetupWindow setupWindow = this._currentWindow.getPrevious();
        setupWindow.handleWindowOpeningEvent();
        this.show(setupWindow);
    }

    public void scan() {
        if (!this._scanned) {
            this._scannedPaths = this.scanDrive();
            this._scanned = true;
        }
    }

    public String[] getScannedPaths() {
        return this._scannedPaths;
    }

    public void cancelSetup() {
        this._dialog.dispose();
        System.exit(0);
    }

    public void finishSetup() {
        this._dialog.dispose();
        SettingsManager.instance().setInstalled(true);
        SettingsManager.instance().writeProperties();
    }

    public void goToFinishButtons() {
        this._setupButtons.goToFinishButtons();
    }

    public void goToCancelButtons() {
        this._setupButtons.goToCancelButtons();
    }

    public void goToStandardButtons() {
        this._setupButtons.goToStandardButtons();
    }

    private void show(SetupWindow setupWindow) {
        this._setupWindowHolder.show(setupWindow.getKey());
        this._dialog.setTitle(setupWindow.getName());
        this._currentWindow = setupWindow;
    }

    private String[] scanDrive() {
        FileScan fileScan = new FileScan();
        String[] stringArray = new String[]{"Recycle", "Incomplete", "LimeWire", "Microsoft", "bin", "system", "WINNT"};
        fileScan.setFilters(stringArray);
        String string = CommonUtils.getCurrentDirectory();
        File file = this.getRoot(new File(string));
        try {
            fileScan.scan(file.getCanonicalPath());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return fileScan.getListAsArray();
    }

    private File getRoot(File file) {
        String string = file.getParent();
        if (string == null) {
            return file;
        }
        return this.getRoot(new File(string));
    }
}

