/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import com.sun.java.util.collections.ArrayList;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JPanel;

final class ScanConfirmWindow
extends SetupWindow {
    private final int SHARED_DIRECTORY_LIMIT = 5;
    private JCheckBox[] _dirCheckBoxes = new JCheckBox[5];
    private JPanel CHECK_BOX_PANEL = new BoxPanel(1);
    private boolean _windowOpened = false;

    ScanConfirmWindow(SetupManager setupManager) {
        super(setupManager, "SETUP_CONFIRM_TITLE", "SETUP_CONFIRM_LABEL");
        BoxPanel boxPanel = new BoxPanel(0);
        boxPanel.add(this.CHECK_BOX_PANEL);
        boxPanel.add(Box.createHorizontalGlue());
        this.addSetupComponent(boxPanel);
    }

    public void handleWindowOpeningEvent() {
        this._manager.goToStandardButtons();
        if (!this._windowOpened) {
            String[] stringArray = this._manager.getScannedPaths();
            this.setDirectories(stringArray);
            this._windowOpened = true;
        }
    }

    public void applySettings() throws ApplySettingsException {
        SettingsManager settingsManager = SettingsManager.instance();
        File[] fileArray = this.getSelectedDirectories();
        boolean bl = false;
        int n = fileArray.length;
        File file = null;
        try {
            file = settingsManager.getSaveDirectory();
            ++n;
            bl = true;
        }
        catch (FileNotFoundException fileNotFoundException) {
            // empty catch block
        }
        File[] fileArray2 = new File[n];
        int n2 = 0;
        while (n2 < fileArray.length) {
            fileArray2[n2] = fileArray[n2];
            ++n2;
        }
        if (bl) {
            fileArray2[fileArray.length] = file;
        }
        settingsManager.setDirectories(fileArray2);
    }

    private File[] getSelectedDirectories() {
        ArrayList arrayList = new ArrayList();
        int n = 0;
        int n2 = 0;
        while (n2 < this._dirCheckBoxes.length) {
            if (this._dirCheckBoxes[n2].isSelected()) {
                ++n;
            }
            arrayList.add((Object)new File(this._dirCheckBoxes[n2].getText()));
            ++n2;
        }
        File[] fileArray = new File[n];
        int n3 = 0;
        while (n3 < n) {
            fileArray[n3] = (File)arrayList.get(n3);
            ++n3;
        }
        return fileArray;
    }

    private void setDirectories(String[] stringArray) {
        int n = 0;
        while (n < stringArray.length) {
            if (stringArray[n] != null) {
                this._dirCheckBoxes[n] = new JCheckBox("", false);
                this._dirCheckBoxes[n].setText(stringArray[n]);
                this.CHECK_BOX_PANEL.add(this._dirCheckBoxes[n]);
            }
            ++n;
        }
        this.CHECK_BOX_PANEL.revalidate();
    }
}

