/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.gui.BoxPanel;
import com.limegroup.gnutella.gui.ButtonRow;
import com.limegroup.gnutella.gui.GUIMediator;
import com.limegroup.gnutella.gui.LabeledTextField;
import com.limegroup.gnutella.gui.init.ApplySettingsException;
import com.limegroup.gnutella.gui.init.SetupManager;
import com.limegroup.gnutella.gui.init.SetupWindow;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import javax.swing.JFileChooser;

class SaveWindow
extends SetupWindow {
    private LabeledTextField _saveField;
    private final JFileChooser FILE_CHOOSER = new JFileChooser();

    SaveWindow(SetupManager setupManager) {
        super(setupManager, "SETUP_SAVE_TITLE", "SETUP_SAVE_LABEL");
        BoxPanel boxPanel = new BoxPanel(1);
        this.FILE_CHOOSER.setFileSelectionMode(1);
        String[] stringArray = new String[]{"INIT_SAVE_BROWSE_BUTTON_LABEL", "INIT_SAVE_DEFAULT_BUTTON_LABEL"};
        String[] stringArray2 = new String[]{"INIT_SAVE_BROWSE_BUTTON_TIP", "INIT_SAVE_DEFAULT_BUTTON_TIP"};
        String string = "INIT_SAVE_DIRECTORY_FIELD_LABEL";
        String string2 = GUIMediator.getStringResource(string);
        this._saveField = new LabeledTextField(string2, 20);
        ActionListener[] actionListenerArray = new ActionListener[]{new SaveListener(), new DefaultListener()};
        ButtonRow buttonRow = new ButtonRow(stringArray, stringArray2, actionListenerArray, 0, 12);
        this._saveField.setText(this.getDefault());
        boxPanel.add(this._saveField);
        boxPanel.add(buttonRow);
        this.addSetupComponent(boxPanel);
    }

    public void applySettings() throws ApplySettingsException {
        try {
            String string = this._saveField.getText();
            File file = new File(string);
            File[] fileArray = new File[]{file};
            SettingsManager.instance().setSaveDirectory(file);
            SettingsManager.instance().setDirectories(fileArray);
        }
        catch (IOException iOException) {
            String string = "MESSAGE_INVALID_SAVE_DIRECTORY";
            throw new ApplySettingsException(string);
        }
    }

    private String getDefault() {
        return new File("Shared").getAbsolutePath();
    }

    private class SaveListener
    implements ActionListener {
        private SaveListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = GUIMediator.getStringResource("DIRECTORY_CHOOSER_CAPTION");
            int n = SaveWindow.this.FILE_CHOOSER.showDialog(SaveWindow.this, string);
            if (n == 0) {
                File file = SaveWindow.this.FILE_CHOOSER.getSelectedFile();
                SaveWindow.this._saveField.setText(file.getAbsolutePath());
            }
        }
    }

    private class DefaultListener
    implements ActionListener {
        private DefaultListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            SaveWindow.this._saveField.setText(SaveWindow.this.getDefault());
        }
    }
}

