/*
 * Decompiled with CFR 0.152.
 */
package com.limegroup.gnutella.gui.init;

import com.limegroup.gnutella.SettingsManager;
import com.limegroup.gnutella.util.LimitedList;
import com.limegroup.gnutella.util.Pair;
import com.limegroup.gnutella.util.StringUtils;
import java.io.File;
import java.io.IOException;

public class FileScan {
    private int MEM_WEIGHT = 1;
    private int NUM_WEIGHT = 1;
    private int MAX_DEPTH = 3;
    private String[] _extensions;
    private String[] _filters;
    private LimitedList _list = new LimitedList();

    public FileScan() {
        this._filters = new String[0];
        String string = SettingsManager.instance().getExtensions();
        this._extensions = StringUtils.split(string, ";");
    }

    public void setExtensions(String[] stringArray) {
        this._extensions = stringArray;
    }

    public void setFilters(String[] stringArray) {
        this._filters = stringArray;
    }

    public String[] getListAsArray() {
        Object[] objectArray = this._list.getAllElements();
        int n = objectArray.length;
        String[] stringArray = new String[n];
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] != null) {
                Pair pair = (Pair)objectArray[n2];
                File file = (File)pair.getElement();
                try {
                    stringArray[n2] = file.getCanonicalPath();
                }
                catch (IOException iOException) {
                    stringArray[n2] = "";
                }
            }
            ++n2;
        }
        return stringArray;
    }

    public String getListAsString() {
        Object[] objectArray = this._list.getAllElements();
        int n = objectArray.length;
        String string = "";
        int n2 = 0;
        while (n2 < n) {
            if (objectArray[n2] != null) {
                Pair pair = (Pair)objectArray[n2];
                File file = (File)pair.getElement();
                try {
                    string = string + file.getCanonicalPath();
                    string = string + ";";
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n2;
        }
        return string;
    }

    public void scan(String string) {
        this.scan(string, this.MAX_DEPTH);
    }

    private void scan(String string, int n) {
        if (n == 0) {
            return;
        }
        --n;
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = this.listFiles(file);
        int n2 = fileArray.length;
        String string2 = "";
        int n3 = 0;
        while (n3 < n2) {
            File file2 = fileArray[n3];
            if (file2.isDirectory()) {
                try {
                    string2 = file2.getCanonicalPath();
                    this.addDirectory(string2);
                    this.scan(string2, n);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            ++n3;
        }
    }

    public void scan(String[] stringArray) {
        this.scan(stringArray, this.MAX_DEPTH);
    }

    public void scan(String[] stringArray, int n) {
        if (n == 0) {
            return;
        }
        --n;
        int n2 = 0;
        while (n2 < stringArray.length) {
            String string = stringArray[n2];
            File file = new File(string);
            if (file.isDirectory()) {
                File[] fileArray = this.listFiles(file);
                int n3 = fileArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    File file2 = fileArray[n4];
                    String string2 = "";
                    if (file2.isDirectory()) {
                        try {
                            string2 = file2.getCanonicalPath();
                            this.addDirectory(string2);
                            this.scan(string2);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    ++n4;
                }
            }
            ++n2;
        }
    }

    private void addDirectory(String string) {
        File file = new File(string);
        if (!file.isDirectory()) {
            return;
        }
        File[] fileArray = this.listFiles(file);
        int n = fileArray.length;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        while (n4 < n) {
            File file2 = fileArray[n4];
            String string2 = file2.getName();
            if (this.hasExtension(string2) && !this.hasFilter(string)) {
                n2 = (int)((long)n2 + file2.length());
                ++n3;
            }
            ++n4;
        }
        int n5 = this.calculateKey(n3, n2);
        this._list.add(new Pair(n5, file), n5);
    }

    private int calculateKey(int n, int n2) {
        int n3 = n * this.NUM_WEIGHT + n2 * this.MEM_WEIGHT;
        return n3;
    }

    private boolean hasFilter(String string) {
        string = string.toLowerCase();
        int n = this._filters.length;
        String string2 = "";
        int n2 = 0;
        while (n2 < n) {
            string2 = this._filters[n2].toLowerCase();
            if (string.indexOf(string2) != -1) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    private boolean hasExtension(String string) {
        int n = string.lastIndexOf(".") + 1;
        if (n == -1) {
            return false;
        }
        int n2 = string.length();
        String string2 = string.substring(n, n2);
        int n3 = this._extensions.length;
        int n4 = 0;
        while (n4 < n3) {
            if (string2.equalsIgnoreCase(this._extensions[n4])) {
                return true;
            }
            ++n4;
        }
        return false;
    }

    private File[] listFiles(File file) {
        String[] stringArray = file.list();
        if (stringArray == null) {
            return new File[0];
        }
        File[] fileArray = new File[stringArray.length];
        int n = 0;
        while (n < stringArray.length) {
            fileArray[n] = new File(file, stringArray[n]);
            ++n;
        }
        return fileArray;
    }

    private void print() {
        this._list.print();
    }
}

